/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opendaylight.yangtools.yang.common.QName;

public class SchemaPath {
    private final int hashBooleanTrue = 1231;
    private final int hashBooleanFalse = 1237;
    private final List<QName> path;
    private final boolean absolute;

    public SchemaPath(List<QName> path, boolean absolute) {
        this.path = Collections.unmodifiableList(new ArrayList<QName>(path));
        this.absolute = absolute;
    }

    public List<QName> getPath() {
        return this.path;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.absolute ? 1231 : 1237);
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SchemaPath other = (SchemaPath)obj;
        if (this.absolute != other.absolute) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SchemaPath [path=");
        builder.append(this.path);
        builder.append(", absolute=");
        builder.append(this.absolute);
        builder.append("]");
        return builder.toString();
    }
}

