/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.northbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetAware;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.networkconfig.neutron.northbound.NeutronSubnetRequest;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.InternalServerErrorException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@Path(value="/subnets")
public class NeutronSubnetsNorthbound {
    private NeutronSubnet extractFields(NeutronSubnet o, List<String> fields) {
        return o.extractFields(fields);
    }

    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response listSubnets(@QueryParam(value="fields") List<String> fields, @QueryParam(value="id") String queryID, @QueryParam(value="network_id") String queryNetworkID, @QueryParam(value="name") String queryName, @QueryParam(value="ip_version") String queryIPVersion, @QueryParam(value="cidr") String queryCIDR, @QueryParam(value="gateway_ip") String queryGatewayIP, @QueryParam(value="enable_dhcp") String queryEnableDHCP, @QueryParam(value="tenant_id") String queryTenantID, @QueryParam(value="limit") String limit, @QueryParam(value="marker") String marker, @QueryParam(value="page_reverse") String pageReverse) {
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List allNetworks = subnetInterface.getAllSubnets();
        ArrayList<NeutronSubnet> ans = new ArrayList<NeutronSubnet>();
        for (NeutronSubnet oSS : allNetworks) {
            if (queryID != null && !queryID.equals(oSS.getID()) || queryNetworkID != null && !queryNetworkID.equals(oSS.getNetworkUUID()) || queryName != null && !queryName.equals(oSS.getName()) || queryIPVersion != null && !queryIPVersion.equals(oSS.getIpVersion()) || queryCIDR != null && !queryCIDR.equals(oSS.getCidr()) || queryGatewayIP != null && !queryGatewayIP.equals(oSS.getGatewayIP()) || queryEnableDHCP != null && !queryEnableDHCP.equals(oSS.getEnableDHCP()) || queryTenantID != null && !queryTenantID.equals(oSS.getTenantID())) continue;
            if (fields.size() > 0) {
                ans.add(this.extractFields(oSS, fields));
                continue;
            }
            ans.add(oSS);
        }
        return Response.status((int)200).entity((Object)new NeutronSubnetRequest(ans)).build();
    }

    @Path(value="{subnetUUID}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response showSubnet(@PathParam(value="subnetUUID") String subnetUUID, @QueryParam(value="fields") List<String> fields) {
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!subnetInterface.subnetExists(subnetUUID)) {
            return Response.status((int)404).build();
        }
        if (fields.size() > 0) {
            NeutronSubnet ans = subnetInterface.getSubnet(subnetUUID);
            return Response.status((int)200).entity((Object)new NeutronSubnetRequest(this.extractFields(ans, fields))).build();
        }
        return Response.status((int)200).entity((Object)new NeutronSubnetRequest(subnetInterface.getSubnet(subnetUUID))).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Created"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response createSubnets(NeutronSubnetRequest input) {
        block21: {
            INeutronSubnetAware service;
            INeutronNetworkCRUD networkInterface;
            INeutronSubnetCRUD subnetInterface;
            block20: {
                INeutronSubnetAware service2;
                subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
                if (subnetInterface == null) {
                    throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
                if (networkInterface == null) {
                    throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                if (!input.isSingleton()) break block20;
                NeutronSubnet singleton = input.getSingleton();
                if (subnetInterface.subnetExists(singleton.getID())) {
                    return Response.status((int)400).build();
                }
                if (!networkInterface.networkExists(singleton.getNetworkUUID())) {
                    return Response.status((int)404).build();
                }
                if (!singleton.isValidCIDR()) {
                    return Response.status((int)400).build();
                }
                if (!singleton.initDefaults()) {
                    throw new InternalServerErrorException("subnet object could not be initialized properly");
                }
                if (singleton.gatewayIP_Pool_overlap()) {
                    return Response.status((int)409).build();
                }
                Object[] instances = ServiceHelper.getGlobalInstances(INeutronSubnetAware.class, (Object)this, null);
                if (instances != null) {
                    for (Object instance : instances) {
                        service2 = (INeutronSubnetAware)instance;
                        int status = service2.canCreateSubnet(singleton);
                        if (status >= 200 && status <= 299) continue;
                        return Response.status((int)status).build();
                    }
                }
                subnetInterface.addSubnet(singleton);
                if (instances == null) break block21;
                for (Object instance : instances) {
                    service2 = (INeutronSubnetAware)instance;
                    service2.neutronSubnetCreated(singleton);
                }
                break block21;
            }
            List<NeutronSubnet> bulk = input.getBulk();
            Iterator<NeutronSubnet> i = bulk.iterator();
            HashMap<String, NeutronSubnet> testMap = new HashMap<String, NeutronSubnet>();
            Object[] instances = ServiceHelper.getGlobalInstances(INeutronSubnetAware.class, (Object)this, null);
            while (i.hasNext()) {
                NeutronSubnet test = i.next();
                if (!test.initDefaults()) {
                    throw new InternalServerErrorException("subnet object could not be initialized properly");
                }
                if (subnetInterface.subnetExists(test.getID())) {
                    return Response.status((int)400).build();
                }
                if (testMap.containsKey(test.getID())) {
                    return Response.status((int)400).build();
                }
                testMap.put(test.getID(), test);
                if (!networkInterface.networkExists(test.getNetworkUUID())) {
                    return Response.status((int)404).build();
                }
                if (!test.isValidCIDR()) {
                    return Response.status((int)400).build();
                }
                if (test.gatewayIP_Pool_overlap()) {
                    return Response.status((int)409).build();
                }
                if (instances == null) continue;
                for (Object instance : instances) {
                    service = (INeutronSubnetAware)instance;
                    int status = service.canCreateSubnet(test);
                    if (status >= 200 && status <= 299) continue;
                    return Response.status((int)status).build();
                }
            }
            for (NeutronSubnet test : bulk) {
                subnetInterface.addSubnet(test);
                if (instances == null) continue;
                for (Object instance : instances) {
                    service = (INeutronSubnetAware)instance;
                    service.neutronSubnetCreated(test);
                }
            }
        }
        return Response.status((int)201).entity((Object)input).build();
    }

    @Path(value="{subnetUUID}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response updateSubnet(@PathParam(value="subnetUUID") String subnetUUID, NeutronSubnetRequest input) {
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!subnetInterface.subnetExists(subnetUUID)) {
            return Response.status((int)404).build();
        }
        if (!input.isSingleton()) {
            return Response.status((int)400).build();
        }
        NeutronSubnet delta = input.getSingleton();
        NeutronSubnet original = subnetInterface.getSubnet(subnetUUID);
        if (delta.getID() != null || delta.getTenantID() != null || delta.getIpVersion() != null || delta.getCidr() != null || delta.getAllocationPools() != null) {
            return Response.status((int)400).build();
        }
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronSubnetAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronSubnetAware service = (INeutronSubnetAware)instance;
                int status = service.canUpdateSubnet(delta, original);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        subnetInterface.updateSubnet(subnetUUID, delta);
        NeutronSubnet updatedSubnet = subnetInterface.getSubnet(subnetUUID);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronSubnetAware service = (INeutronSubnetAware)instance;
                service.neutronSubnetUpdated(updatedSubnet);
            }
        }
        return Response.status((int)200).entity((Object)new NeutronSubnetRequest(subnetInterface.getSubnet(subnetUUID))).build();
    }

    @Path(value="{subnetUUID}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response deleteSubnet(@PathParam(value="subnetUUID") String subnetUUID) {
        INeutronSubnetAware service;
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!subnetInterface.subnetExists(subnetUUID)) {
            return Response.status((int)404).build();
        }
        if (subnetInterface.subnetInUse(subnetUUID)) {
            return Response.status((int)409).build();
        }
        NeutronSubnet singleton = subnetInterface.getSubnet(subnetUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronSubnetAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronSubnetAware)instance;
                int status = service.canDeleteSubnet(singleton);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        subnetInterface.removeSubnet(subnetUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronSubnetAware)instance;
                service.neutronSubnetDeleted(singleton);
            }
        }
        return Response.status((int)204).build();
    }
}

