/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.northbound;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronPortCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronRouterAware;
import org.opendaylight.controller.networkconfig.neutron.INeutronRouterCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;
import org.opendaylight.controller.networkconfig.neutron.NeutronRouter;
import org.opendaylight.controller.networkconfig.neutron.NeutronRouter_Interface;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.networkconfig.neutron.Neutron_IPs;
import org.opendaylight.controller.networkconfig.neutron.northbound.NeutronRouterRequest;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@Path(value="/routers")
public class NeutronRoutersNorthbound {
    private NeutronRouter extractFields(NeutronRouter o, List<String> fields) {
        return o.extractFields(fields);
    }

    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response listRouters(@QueryParam(value="fields") List<String> fields, @QueryParam(value="id") String queryID, @QueryParam(value="name") String queryName, @QueryParam(value="admin_state_up") String queryAdminStateUp, @QueryParam(value="status") String queryStatus, @QueryParam(value="tenant_id") String queryTenantID, @QueryParam(value="external_gateway_info") String queryExternalGatewayInfo, @QueryParam(value="limit") String limit, @QueryParam(value="marker") String marker, @QueryParam(value="page_reverse") String pageReverse) {
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List allRouters = routerInterface.getAllRouters();
        ArrayList<NeutronRouter> ans = new ArrayList<NeutronRouter>();
        for (NeutronRouter oSS : allRouters) {
            if (queryID != null && !queryID.equals(oSS.getID()) || queryName != null && !queryName.equals(oSS.getName()) || queryAdminStateUp != null && !queryAdminStateUp.equals(oSS.getAdminStateUp()) || queryStatus != null && !queryStatus.equals(oSS.getStatus()) || queryExternalGatewayInfo != null && !queryExternalGatewayInfo.equals(oSS.getExternalGatewayInfo()) || queryTenantID != null && !queryTenantID.equals(oSS.getTenantID())) continue;
            if (fields.size() > 0) {
                ans.add(this.extractFields(oSS, fields));
                continue;
            }
            ans.add(oSS);
        }
        return Response.status((int)200).entity((Object)new NeutronRouterRequest(ans)).build();
    }

    @Path(value="{routerUUID}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response showRouter(@PathParam(value="routerUUID") String routerUUID, @QueryParam(value="fields") List<String> fields) {
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!routerInterface.routerExists(routerUUID)) {
            return Response.status((int)404).build();
        }
        if (fields.size() > 0) {
            NeutronRouter ans = routerInterface.getRouter(routerUUID);
            return Response.status((int)200).entity((Object)new NeutronRouterRequest(this.extractFields(ans, fields))).build();
        }
        return Response.status((int)200).entity((Object)new NeutronRouterRequest(routerInterface.getRouter(routerUUID))).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Created"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response createRouters(NeutronRouterRequest input) {
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (input.isSingleton()) {
            INeutronRouterAware service;
            Object[] instances;
            NeutronRouter singleton = input.getSingleton();
            if (routerInterface.routerExists(singleton.getID())) {
                return Response.status((int)400).build();
            }
            if (singleton.getExternalGatewayInfo() != null) {
                String externNetworkPtr = singleton.getExternalGatewayInfo().getNetworkID();
                if (!networkInterface.networkExists(externNetworkPtr)) {
                    return Response.status((int)400).build();
                }
                NeutronNetwork externNetwork = networkInterface.getNetwork(externNetworkPtr);
                if (!externNetwork.isRouterExternal()) {
                    return Response.status((int)400).build();
                }
            }
            if ((instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null)) != null) {
                for (Object instance : instances) {
                    service = (INeutronRouterAware)instance;
                    int status = service.canCreateRouter(singleton);
                    if (status >= 200 && status <= 299) continue;
                    return Response.status((int)status).build();
                }
            }
            routerInterface.addRouter(singleton);
            if (instances != null) {
                for (Object instance : instances) {
                    service = (INeutronRouterAware)instance;
                    service.neutronRouterCreated(singleton);
                }
            }
        } else {
            return Response.status((int)400).build();
        }
        return Response.status((int)201).entity((Object)input).build();
    }

    @Path(value="{routerUUID}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response updateRouter(@PathParam(value="routerUUID") String routerUUID, NeutronRouterRequest input) {
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!routerInterface.routerExists(routerUUID)) {
            return Response.status((int)404).build();
        }
        if (!input.isSingleton()) {
            return Response.status((int)400).build();
        }
        NeutronRouter singleton = input.getSingleton();
        NeutronRouter original = routerInterface.getRouter(routerUUID);
        if (singleton.getID() != null || singleton.getTenantID() != null || singleton.getStatus() != null) {
            return Response.status((int)400).build();
        }
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronRouterAware service = (INeutronRouterAware)instance;
                int status = service.canUpdateRouter(singleton, original);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        if (singleton.getExternalGatewayInfo() != null) {
            String externNetworkPtr = singleton.getExternalGatewayInfo().getNetworkID();
            if (!networkInterface.networkExists(externNetworkPtr)) {
                return Response.status((int)400).build();
            }
            NeutronNetwork externNetwork = networkInterface.getNetwork(externNetworkPtr);
            if (!externNetwork.isRouterExternal()) {
                return Response.status((int)400).build();
            }
        }
        routerInterface.updateRouter(routerUUID, singleton);
        NeutronRouter updatedRouter = routerInterface.getRouter(routerUUID);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronRouterAware service = (INeutronRouterAware)instance;
                service.neutronRouterUpdated(updatedRouter);
            }
        }
        return Response.status((int)200).entity((Object)new NeutronRouterRequest(routerInterface.getRouter(routerUUID))).build();
    }

    @Path(value="{routerUUID}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response deleteRouter(@PathParam(value="routerUUID") String routerUUID) {
        INeutronRouterAware service;
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!routerInterface.routerExists(routerUUID)) {
            return Response.status((int)404).build();
        }
        if (routerInterface.routerInUse(routerUUID)) {
            return Response.status((int)409).build();
        }
        NeutronRouter singleton = routerInterface.getRouter(routerUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronRouterAware)instance;
                int status = service.canDeleteRouter(singleton);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        routerInterface.removeRouter(routerUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronRouterAware)instance;
                service.neutronRouterDeleted(singleton);
            }
        }
        return Response.status((int)204).build();
    }

    @Path(value="{routerUUID}/add_router_interface")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response addRouterInterface(@PathParam(value="routerUUID") String routerUUID, NeutronRouter_Interface input) {
        INeutronRouterAware service;
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!routerInterface.routerExists(routerUUID)) {
            return Response.status((int)400).build();
        }
        NeutronRouter target = routerInterface.getRouter(routerUUID);
        if (input.getSubnetUUID() == null || input.getPortUUID() == null) {
            return Response.status((int)400).build();
        }
        NeutronSubnet targetSubnet = subnetInterface.getSubnet(input.getSubnetUUID());
        if (targetSubnet == null) {
            return Response.status((int)400).build();
        }
        NeutronPort targetPort = portInterface.getPort(input.getPortUUID());
        if (targetPort == null) {
            return Response.status((int)400).build();
        }
        if (!targetSubnet.getPortsInSubnet().contains(targetPort)) {
            return Response.status((int)400).build();
        }
        if (targetPort.getFixedIPs().size() != 1) {
            return Response.status((int)400).build();
        }
        if (targetPort.getDeviceID() != null || targetPort.getDeviceOwner() != null) {
            return Response.status((int)409).build();
        }
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronRouterAware)instance;
                service.canAttachInterface(target, input);
            }
        }
        targetPort.setDeviceOwner("network:router_interface");
        targetPort.setDeviceID(routerUUID);
        target.addInterface(input.getPortUUID(), input);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronRouterAware)instance;
                service.neutronRouterInterfaceAttached(target, input);
            }
        }
        return Response.status((int)200).entity((Object)input).build();
    }

    @Path(value="{routerUUID}/remove_router_interface")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response removeRouterInterface(@PathParam(value="routerUUID") String routerUUID, NeutronRouter_Interface input) {
        INeutronRouterCRUD routerInterface = NeutronCRUDInterfaces.getINeutronRouterCRUD((Object)this);
        if (routerInterface == null) {
            throw new ServiceUnavailableException("Router CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!routerInterface.routerExists(routerUUID)) {
            return Response.status((int)400).build();
        }
        NeutronRouter target = routerInterface.getRouter(routerUUID);
        if (input.getPortUUID() == null && input.getSubnetUUID() != null) {
            INeutronRouterAware service;
            NeutronPort port = portInterface.getGatewayPort(input.getSubnetUUID());
            if (port == null) {
                return Response.status((int)404).build();
            }
            input.setPortUUID(port.getID());
            input.setID(target.getID());
            input.setTenantID(target.getTenantID());
            Object[] instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null);
            if (instances != null) {
                for (Object instance : instances) {
                    service = (INeutronRouterAware)instance;
                    service.canDetachInterface(target, input);
                }
            }
            port.setDeviceID(null);
            port.setDeviceOwner(null);
            target.removeInterface(input.getPortUUID());
            if (instances != null) {
                for (Object instance : instances) {
                    service = (INeutronRouterAware)instance;
                    service.neutronRouterInterfaceDetached(target, input);
                }
            }
            return Response.status((int)200).entity((Object)input).build();
        }
        if (input.getPortUUID() != null && input.getSubnetUUID() == null) {
            Object[] instances;
            NeutronRouter_Interface targetInterface = (NeutronRouter_Interface)target.getInterfaces().get(input.getPortUUID());
            input.setSubnetUUID(targetInterface.getSubnetUUID());
            input.setID(target.getID());
            input.setTenantID(target.getTenantID());
            NeutronPort port = portInterface.getPort(input.getPortUUID());
            port.setDeviceID(null);
            port.setDeviceOwner(null);
            target.removeInterface(input.getPortUUID());
            for (Object instance : instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null)) {
                INeutronRouterAware service = (INeutronRouterAware)instance;
                service.neutronRouterInterfaceDetached(target, input);
            }
            return Response.status((int)200).entity((Object)input).build();
        }
        if (input.getPortUUID() != null && input.getSubnetUUID() != null) {
            INeutronRouterAware service;
            NeutronPort port = portInterface.getPort(input.getPortUUID());
            NeutronSubnet subnet = subnetInterface.getSubnet(input.getSubnetUUID());
            if (!subnet.isValidIP(((Neutron_IPs)port.getFixedIPs().get(0)).getIpAddress())) {
                return Response.status((int)409).build();
            }
            input.setID(target.getID());
            input.setTenantID(target.getTenantID());
            Object[] instances = ServiceHelper.getGlobalInstances(INeutronRouterAware.class, (Object)this, null);
            if (instances != null) {
                for (Object instance : instances) {
                    service = (INeutronRouterAware)instance;
                    service.canDetachInterface(target, input);
                }
            }
            port.setDeviceID(null);
            port.setDeviceOwner(null);
            target.removeInterface(input.getPortUUID());
            for (Object instance : instances) {
                service = (INeutronRouterAware)instance;
                service.neutronRouterInterfaceDetached(target, input);
            }
            return Response.status((int)200).entity((Object)input).build();
        }
        return Response.status((int)400).build();
    }
}

