/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.northbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronPortAware;
import org.opendaylight.controller.networkconfig.neutron.INeutronPortCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.networkconfig.neutron.Neutron_IPs;
import org.opendaylight.controller.networkconfig.neutron.northbound.NeutronPortRequest;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@Path(value="/ports")
public class NeutronPortsNorthbound {
    private NeutronPort extractFields(NeutronPort o, List<String> fields) {
        return o.extractFields(fields);
    }

    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response listPorts(@QueryParam(value="fields") List<String> fields, @QueryParam(value="id") String queryID, @QueryParam(value="network_id") String queryNetworkID, @QueryParam(value="name") String queryName, @QueryParam(value="admin_state_up") String queryAdminStateUp, @QueryParam(value="status") String queryStatus, @QueryParam(value="mac_address") String queryMACAddress, @QueryParam(value="device_id") String queryDeviceID, @QueryParam(value="device_owner") String queryDeviceOwner, @QueryParam(value="tenant_id") String queryTenantID, @QueryParam(value="limit") String limit, @QueryParam(value="marker") String marker, @QueryParam(value="page_reverse") String pageReverse) {
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List allPorts = portInterface.getAllPorts();
        ArrayList<NeutronPort> ans = new ArrayList<NeutronPort>();
        for (NeutronPort oSS : allPorts) {
            if (queryID != null && !queryID.equals(oSS.getID()) || queryNetworkID != null && !queryNetworkID.equals(oSS.getNetworkUUID()) || queryName != null && !queryName.equals(oSS.getName()) || queryAdminStateUp != null && !queryAdminStateUp.equals(oSS.getAdminStateUp()) || queryStatus != null && !queryStatus.equals(oSS.getStatus()) || queryMACAddress != null && !queryMACAddress.equals(oSS.getMacAddress()) || queryDeviceID != null && !queryDeviceID.equals(oSS.getDeviceID()) || queryDeviceOwner != null && !queryDeviceOwner.equals(oSS.getDeviceOwner()) || queryTenantID != null && !queryTenantID.equals(oSS.getTenantID())) continue;
            if (fields.size() > 0) {
                ans.add(this.extractFields(oSS, fields));
                continue;
            }
            ans.add(oSS);
        }
        return Response.status((int)200).entity((Object)new NeutronPortRequest(ans)).build();
    }

    @Path(value="{portUUID}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response showPort(@PathParam(value="portUUID") String portUUID, @QueryParam(value="fields") List<String> fields) {
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!portInterface.portExists(portUUID)) {
            return Response.status((int)404).build();
        }
        if (fields.size() > 0) {
            NeutronPort ans = portInterface.getPort(portUUID);
            return Response.status((int)200).entity((Object)new NeutronPortRequest(this.extractFields(ans, fields))).build();
        }
        return Response.status((int)200).entity((Object)new NeutronPortRequest(portInterface.getPort(portUUID))).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Created"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented"), @ResponseCode(code=503, condition="MAC generation failure")})
    public Response createPorts(NeutronPortRequest input) {
        block37: {
            INeutronPortAware service;
            INeutronSubnetCRUD subnetInterface;
            INeutronNetworkCRUD networkInterface;
            INeutronPortCRUD portInterface;
            block36: {
                List fixedIPs;
                portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
                if (portInterface == null) {
                    throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
                if (networkInterface == null) {
                    throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
                if (subnetInterface == null) {
                    throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                if (!input.isSingleton()) break block36;
                NeutronPort singleton = input.getSingleton();
                if (singleton.getNetworkUUID() == null) {
                    return Response.status((int)400).build();
                }
                if (portInterface.portExists(singleton.getID())) {
                    return Response.status((int)400).build();
                }
                if (!networkInterface.networkExists(singleton.getNetworkUUID())) {
                    return Response.status((int)404).build();
                }
                if (singleton.getMacAddress() == null || !singleton.getMacAddress().matches("^([0-9A-Fa-f]{2}[:-]){5}([0-9A-Fa-f]{2})$")) {
                    return Response.status((int)400).build();
                }
                if (portInterface.macInUse(singleton.getMacAddress())) {
                    return Response.status((int)409).build();
                }
                Object[] instances = ServiceHelper.getGlobalInstances(INeutronPortAware.class, (Object)this, null);
                if (instances != null) {
                    for (Object instance : instances) {
                        INeutronPortAware service2 = (INeutronPortAware)instance;
                        int status = service2.canCreatePort(singleton);
                        if (status >= 200 && status <= 299) continue;
                        return Response.status((int)status).build();
                    }
                }
                if ((fixedIPs = singleton.getFixedIPs()) != null && fixedIPs.size() > 0) {
                    for (Neutron_IPs ip : fixedIPs) {
                        if (ip.getSubnetUUID() == null) {
                            return Response.status((int)400).build();
                        }
                        if (!subnetInterface.subnetExists(ip.getSubnetUUID())) {
                            return Response.status((int)400).build();
                        }
                        NeutronSubnet subnet = subnetInterface.getSubnet(ip.getSubnetUUID());
                        if (!singleton.getNetworkUUID().equalsIgnoreCase(subnet.getNetworkUUID())) {
                            return Response.status((int)400).build();
                        }
                        if (ip.getIpAddress() == null) continue;
                        if (!subnet.isValidIP(ip.getIpAddress())) {
                            return Response.status((int)400).build();
                        }
                        if (!subnet.isIPInUse(ip.getIpAddress())) continue;
                        return Response.status((int)409).build();
                    }
                }
                portInterface.addPort(singleton);
                if (instances == null) break block37;
                for (Object instance : instances) {
                    INeutronPortAware service3 = (INeutronPortAware)instance;
                    service3.neutronPortCreated(singleton);
                }
                break block37;
            }
            List<NeutronPort> bulk = input.getBulk();
            Iterator<NeutronPort> i = bulk.iterator();
            HashMap<String, NeutronPort> testMap = new HashMap<String, NeutronPort>();
            Object[] instances = ServiceHelper.getGlobalInstances(INeutronPortAware.class, (Object)this, null);
            while (i.hasNext()) {
                List fixedIPs;
                NeutronPort test = i.next();
                if (portInterface.portExists(test.getID())) {
                    return Response.status((int)400).build();
                }
                if (testMap.containsKey(test.getID())) {
                    return Response.status((int)400).build();
                }
                for (NeutronPort check : testMap.values()) {
                    if (test.getMacAddress().equalsIgnoreCase(check.getMacAddress())) {
                        return Response.status((int)409).build();
                    }
                    for (Neutron_IPs test_fixedIP : test.getFixedIPs()) {
                        for (Neutron_IPs check_fixedIP : check.getFixedIPs()) {
                            if (!test_fixedIP.getIpAddress().equals(check_fixedIP.getIpAddress())) continue;
                            return Response.status((int)409).build();
                        }
                    }
                }
                testMap.put(test.getID(), test);
                if (!networkInterface.networkExists(test.getNetworkUUID())) {
                    return Response.status((int)404).build();
                }
                if (!test.getMacAddress().matches("^([0-9A-F]{2}[:-]){5}([0-9A-F]{2})$")) {
                    return Response.status((int)400).build();
                }
                if (portInterface.macInUse(test.getMacAddress())) {
                    return Response.status((int)409).build();
                }
                if (instances != null) {
                    for (Object instance : instances) {
                        service = (INeutronPortAware)instance;
                        int status = service.canCreatePort(test);
                        if (status >= 200 && status <= 299) continue;
                        return Response.status((int)status).build();
                    }
                }
                if ((fixedIPs = test.getFixedIPs()) == null || fixedIPs.size() <= 0) continue;
                for (Neutron_IPs ip : fixedIPs) {
                    if (ip.getSubnetUUID() == null) {
                        return Response.status((int)400).build();
                    }
                    if (!subnetInterface.subnetExists(ip.getSubnetUUID())) {
                        return Response.status((int)400).build();
                    }
                    NeutronSubnet subnet = subnetInterface.getSubnet(ip.getSubnetUUID());
                    if (!test.getNetworkUUID().equalsIgnoreCase(subnet.getNetworkUUID())) {
                        return Response.status((int)400).build();
                    }
                    if (ip.getIpAddress() == null) continue;
                    if (!subnet.isValidIP(ip.getIpAddress())) {
                        return Response.status((int)400).build();
                    }
                    if (!subnet.isIPInUse(ip.getIpAddress())) continue;
                    return Response.status((int)409).build();
                }
            }
            for (NeutronPort test : bulk) {
                portInterface.addPort(test);
                if (instances == null) continue;
                for (Object instance : instances) {
                    service = (INeutronPortAware)instance;
                    service.neutronPortCreated(test);
                }
            }
        }
        return Response.status((int)201).entity((Object)input).build();
    }

    @Path(value="{portUUID}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response updatePort(@PathParam(value="portUUID") String portUUID, NeutronPortRequest input) {
        List fixedIPs;
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!portInterface.portExists(portUUID)) {
            return Response.status((int)404).build();
        }
        NeutronPort target = portInterface.getPort(portUUID);
        if (!input.isSingleton()) {
            return Response.status((int)400).build();
        }
        NeutronPort singleton = input.getSingleton();
        NeutronPort original = portInterface.getPort(portUUID);
        if (singleton.getID() != null || singleton.getTenantID() != null || singleton.getStatus() != null) {
            return Response.status((int)400).build();
        }
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronPortAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronPortAware service = (INeutronPortAware)instance;
                int status = service.canUpdatePort(singleton, original);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        if ((fixedIPs = singleton.getFixedIPs()) != null && fixedIPs.size() > 0) {
            for (Neutron_IPs ip : fixedIPs) {
                if (ip.getSubnetUUID() == null) {
                    return Response.status((int)400).build();
                }
                if (!subnetInterface.subnetExists(ip.getSubnetUUID())) {
                    return Response.status((int)400).build();
                }
                NeutronSubnet subnet = subnetInterface.getSubnet(ip.getSubnetUUID());
                if (!target.getNetworkUUID().equalsIgnoreCase(subnet.getNetworkUUID())) {
                    return Response.status((int)400).build();
                }
                if (ip.getIpAddress() == null) continue;
                if (!subnet.isValidIP(ip.getIpAddress())) {
                    return Response.status((int)400).build();
                }
                if (!subnet.isIPInUse(ip.getIpAddress())) continue;
                return Response.status((int)409).build();
            }
        }
        portInterface.updatePort(portUUID, singleton);
        NeutronPort updatedPort = portInterface.getPort(portUUID);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronPortAware service = (INeutronPortAware)instance;
                service.neutronPortUpdated(updatedPort);
            }
        }
        return Response.status((int)200).entity((Object)new NeutronPortRequest(updatedPort)).build();
    }

    @Path(value="{portUUID}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response deletePort(@PathParam(value="portUUID") String portUUID) {
        INeutronPortAware service;
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!portInterface.portExists(portUUID)) {
            return Response.status((int)404).build();
        }
        NeutronPort port = portInterface.getPort(portUUID);
        if (port.getDeviceID() != null || port.getDeviceOwner() != null) {
            Response.status((int)403).build();
        }
        NeutronPort singleton = portInterface.getPort(portUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronPortAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronPortAware)instance;
                int status = service.canDeletePort(singleton);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        portInterface.removePort(portUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronPortAware)instance;
                service.neutronPortDeleted(singleton);
            }
        }
        return Response.status((int)204).build();
    }
}

