/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.northbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkAware;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.controller.networkconfig.neutron.northbound.NeutronNetworkRequest;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@Path(value="/networks")
public class NeutronNetworksNorthbound {
    private NeutronNetwork extractFields(NeutronNetwork o, List<String> fields) {
        return o.extractFields(fields);
    }

    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized")})
    public Response listNetworks(@QueryParam(value="fields") List<String> fields, @QueryParam(value="id") String queryID, @QueryParam(value="name") String queryName, @QueryParam(value="admin_state_up") String queryAdminStateUp, @QueryParam(value="status") String queryStatus, @QueryParam(value="shared") String queryShared, @QueryParam(value="tenant_id") String queryTenantID, @QueryParam(value="router_external") String queryRouterExternal, @QueryParam(value="provider_network_type") String queryProviderNetworkType, @QueryParam(value="provider_physical_network") String queryProviderPhysicalNetwork, @QueryParam(value="provider_segmentation_id") String queryProviderSegmentationID, @QueryParam(value="limit") String limit, @QueryParam(value="marker") String marker, @QueryParam(value="page_reverse") String pageReverse) {
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List allNetworks = networkInterface.getAllNetworks();
        ArrayList<NeutronNetwork> ans = new ArrayList<NeutronNetwork>();
        for (NeutronNetwork oSN : allNetworks) {
            Boolean bAdminStateUp = null;
            Boolean bShared = null;
            Boolean bRouterExternal = null;
            if (queryAdminStateUp != null) {
                bAdminStateUp = Boolean.valueOf(queryAdminStateUp);
            }
            if (queryShared != null) {
                bShared = Boolean.valueOf(queryShared);
            }
            if (queryRouterExternal != null) {
                bRouterExternal = Boolean.valueOf(queryRouterExternal);
            }
            if (queryID != null && !queryID.equals(oSN.getID()) || queryName != null && !queryName.equals(oSN.getNetworkName()) || bAdminStateUp != null && bAdminStateUp.booleanValue() != oSN.isAdminStateUp() || queryStatus != null && !queryStatus.equals(oSN.getStatus()) || bShared != null && bShared.booleanValue() != oSN.isShared() || bRouterExternal != null && bRouterExternal.booleanValue() != oSN.isRouterExternal() || queryTenantID != null && !queryTenantID.equals(oSN.getTenantID())) continue;
            if (fields.size() > 0) {
                ans.add(this.extractFields(oSN, fields));
                continue;
            }
            ans.add(oSN);
        }
        return Response.status((int)200).entity((Object)new NeutronNetworkRequest(ans)).build();
    }

    @Path(value="{netUUID}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found")})
    public Response showNetwork(@PathParam(value="netUUID") String netUUID, @QueryParam(value="fields") List<String> fields) {
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!networkInterface.networkExists(netUUID)) {
            return Response.status((int)404).build();
        }
        if (fields.size() > 0) {
            NeutronNetwork ans = networkInterface.getNetwork(netUUID);
            return Response.status((int)200).entity((Object)new NeutronNetworkRequest(this.extractFields(ans, fields))).build();
        }
        return Response.status((int)200).entity((Object)new NeutronNetworkRequest(networkInterface.getNetwork(netUUID))).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @TypeHint(value=NeutronNetwork.class)
    @StatusCodes(value={@ResponseCode(code=201, condition="Created"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized")})
    public Response createNetworks(NeutronNetworkRequest input) {
        block13: {
            INeutronNetworkAware service;
            INeutronNetworkCRUD networkInterface;
            block12: {
                INeutronNetworkAware service2;
                networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
                if (networkInterface == null) {
                    throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
                }
                if (!input.isSingleton()) break block12;
                NeutronNetwork singleton = input.getSingleton();
                if (networkInterface.networkExists(singleton.getID())) {
                    return Response.status((int)400).build();
                }
                Object[] instances = ServiceHelper.getGlobalInstances(INeutronNetworkAware.class, (Object)this, null);
                if (instances != null) {
                    for (Object instance : instances) {
                        service2 = (INeutronNetworkAware)instance;
                        int status = service2.canCreateNetwork(singleton);
                        if (status >= 200 && status <= 299) continue;
                        return Response.status((int)status).build();
                    }
                }
                singleton.initDefaults();
                networkInterface.addNetwork(singleton);
                if (instances == null) break block13;
                for (Object instance : instances) {
                    service2 = (INeutronNetworkAware)instance;
                    service2.neutronNetworkCreated(singleton);
                }
                break block13;
            }
            List<NeutronNetwork> bulk = input.getBulk();
            Iterator<NeutronNetwork> i = bulk.iterator();
            HashMap<String, NeutronNetwork> testMap = new HashMap<String, NeutronNetwork>();
            Object[] instances = ServiceHelper.getGlobalInstances(INeutronNetworkAware.class, (Object)this, null);
            while (i.hasNext()) {
                NeutronNetwork test = i.next();
                if (networkInterface.networkExists(test.getID())) {
                    return Response.status((int)400).build();
                }
                if (testMap.containsKey(test.getID())) {
                    return Response.status((int)400).build();
                }
                if (instances != null) {
                    for (Object instance : instances) {
                        service = (INeutronNetworkAware)instance;
                        int status = service.canCreateNetwork(test);
                        if (status >= 200 && status <= 299) continue;
                        return Response.status((int)status).build();
                    }
                }
                testMap.put(test.getID(), test);
            }
            for (NeutronNetwork test : bulk) {
                test.initDefaults();
                networkInterface.addNetwork(test);
                if (instances == null) continue;
                for (Object instance : instances) {
                    service = (INeutronNetworkAware)instance;
                    service.neutronNetworkCreated(test);
                }
            }
        }
        return Response.status((int)201).entity((Object)input).build();
    }

    @Path(value="{netUUID}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=403, condition="Forbidden"), @ResponseCode(code=404, condition="Not Found")})
    public Response updateNetwork(@PathParam(value="netUUID") String netUUID, NeutronNetworkRequest input) {
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!networkInterface.networkExists(netUUID)) {
            return Response.status((int)404).build();
        }
        if (!input.isSingleton()) {
            return Response.status((int)400).build();
        }
        NeutronNetwork delta = input.getSingleton();
        if (delta.getID() != null || delta.getTenantID() != null || delta.getStatus() != null) {
            return Response.status((int)400).build();
        }
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronNetworkAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronNetworkAware service = (INeutronNetworkAware)instance;
                NeutronNetwork original = networkInterface.getNetwork(netUUID);
                int status = service.canUpdateNetwork(delta, original);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        networkInterface.updateNetwork(netUUID, delta);
        NeutronNetwork updatedSingleton = networkInterface.getNetwork(netUUID);
        if (instances != null) {
            for (Object instance : instances) {
                INeutronNetworkAware service = (INeutronNetworkAware)instance;
                service.neutronNetworkUpdated(updatedSingleton);
            }
        }
        return Response.status((int)200).entity((Object)new NeutronNetworkRequest(networkInterface.getNetwork(netUUID))).build();
    }

    @Path(value="{netUUID}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Network In Use")})
    public Response deleteNetwork(@PathParam(value="netUUID") String netUUID) {
        INeutronNetworkAware service;
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!networkInterface.networkExists(netUUID)) {
            return Response.status((int)404).build();
        }
        if (networkInterface.networkInUse(netUUID)) {
            return Response.status((int)409).build();
        }
        NeutronNetwork singleton = networkInterface.getNetwork(netUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronNetworkAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronNetworkAware)instance;
                int status = service.canDeleteNetwork(singleton);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        networkInterface.removeNetwork(netUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronNetworkAware)instance;
                service.neutronNetworkDeleted(singleton);
            }
        }
        return Response.status((int)204).build();
    }
}

