/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.networkconfig.neutron.northbound;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.opendaylight.controller.networkconfig.neutron.INeutronFloatingIPAware;
import org.opendaylight.controller.networkconfig.neutron.INeutronFloatingIPCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronNetworkCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronPortCRUD;
import org.opendaylight.controller.networkconfig.neutron.INeutronSubnetCRUD;
import org.opendaylight.controller.networkconfig.neutron.NeutronCRUDInterfaces;
import org.opendaylight.controller.networkconfig.neutron.NeutronFloatingIP;
import org.opendaylight.controller.networkconfig.neutron.NeutronNetwork;
import org.opendaylight.controller.networkconfig.neutron.NeutronPort;
import org.opendaylight.controller.networkconfig.neutron.NeutronSubnet;
import org.opendaylight.controller.networkconfig.neutron.Neutron_IPs;
import org.opendaylight.controller.networkconfig.neutron.northbound.NeutronFloatingIPRequest;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.sal.utils.ServiceHelper;

@Path(value="/floatingips")
public class NeutronFloatingIPsNorthbound {
    private NeutronFloatingIP extractFields(NeutronFloatingIP o, List<String> fields) {
        return o.extractFields(fields);
    }

    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response listFloatingIPs(@QueryParam(value="fields") List<String> fields, @QueryParam(value="id") String queryID, @QueryParam(value="floating_network_id") String queryFloatingNetworkId, @QueryParam(value="port_id") String queryPortId, @QueryParam(value="fixed_ip_address") String queryFixedIPAddress, @QueryParam(value="floating_ip_address") String queryFloatingIPAddress, @QueryParam(value="tenant_id") String queryTenantID, @QueryParam(value="limit") String limit, @QueryParam(value="marker") String marker, @QueryParam(value="page_reverse") String pageReverse) {
        INeutronFloatingIPCRUD floatingIPInterface = NeutronCRUDInterfaces.getINeutronFloatingIPCRUD((Object)this);
        if (floatingIPInterface == null) {
            throw new ServiceUnavailableException("Floating IP CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        List allFloatingIPs = floatingIPInterface.getAllFloatingIPs();
        ArrayList<NeutronFloatingIP> ans = new ArrayList<NeutronFloatingIP>();
        for (NeutronFloatingIP oSS : allFloatingIPs) {
            if (queryID != null && !queryID.equals(oSS.getID()) || queryFloatingNetworkId != null && !queryFloatingNetworkId.equals(oSS.getFloatingNetworkUUID()) || queryPortId != null && !queryPortId.equals(oSS.getPortUUID()) || queryFixedIPAddress != null && !queryFixedIPAddress.equals(oSS.getFixedIPAddress()) || queryFloatingIPAddress != null && !queryFloatingIPAddress.equals(oSS.getFloatingIPAddress()) || queryTenantID != null && !queryTenantID.equals(oSS.getTenantUUID())) continue;
            if (fields.size() > 0) {
                ans.add(this.extractFields(oSS, fields));
                continue;
            }
            ans.add(oSS);
        }
        return Response.status((int)200).entity((Object)new NeutronFloatingIPRequest(ans)).build();
    }

    @Path(value="{floatingipUUID}")
    @GET
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response showFloatingIP(@PathParam(value="floatingipUUID") String floatingipUUID, @QueryParam(value="fields") List<String> fields) {
        INeutronFloatingIPCRUD floatingIPInterface = NeutronCRUDInterfaces.getINeutronFloatingIPCRUD((Object)this);
        if (floatingIPInterface == null) {
            throw new ServiceUnavailableException("Floating IP CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!floatingIPInterface.floatingIPExists(floatingipUUID)) {
            return Response.status((int)404).build();
        }
        if (fields.size() > 0) {
            NeutronFloatingIP ans = floatingIPInterface.getFloatingIP(floatingipUUID);
            return Response.status((int)200).entity((Object)new NeutronFloatingIPRequest(this.extractFields(ans, fields))).build();
        }
        return Response.status((int)200).entity((Object)new NeutronFloatingIPRequest(floatingIPInterface.getFloatingIP(floatingipUUID))).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=201, condition="Created"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response createFloatingIPs(NeutronFloatingIPRequest input) {
        INeutronFloatingIPCRUD floatingIPInterface = NeutronCRUDInterfaces.getINeutronFloatingIPCRUD((Object)this);
        if (floatingIPInterface == null) {
            throw new ServiceUnavailableException("Floating IP CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (input.isSingleton()) {
            INeutronFloatingIPAware service;
            Object[] instances;
            String port_id;
            NeutronFloatingIP singleton = input.getSingleton();
            if (floatingIPInterface.floatingIPExists(singleton.getID())) {
                return Response.status((int)400).build();
            }
            String externalNetworkUUID = singleton.getFloatingNetworkUUID();
            if (externalNetworkUUID == null) {
                return Response.status((int)400).build();
            }
            if (!networkInterface.networkExists(externalNetworkUUID)) {
                return Response.status((int)400).build();
            }
            NeutronNetwork externNetwork = networkInterface.getNetwork(externalNetworkUUID);
            if (!externNetwork.isRouterExternal()) {
                return Response.status((int)400).build();
            }
            String floatingIP = singleton.getFloatingIPAddress();
            if (floatingIP != null) {
                if (externNetwork.getSubnets().size() > 1) {
                    return Response.status((int)400).build();
                }
                NeutronSubnet externSubnet = subnetInterface.getSubnet((String)externNetwork.getSubnets().get(0));
                if (!externSubnet.isValidIP(floatingIP)) {
                    return Response.status((int)400).build();
                }
                if (externSubnet.isIPInUse(floatingIP)) {
                    return Response.status((int)409).build();
                }
            }
            if ((port_id = singleton.getPortUUID()) != null) {
                String fixedIP = null;
                if (!portInterface.portExists(port_id)) {
                    return Response.status((int)404).build();
                }
                NeutronPort port = portInterface.getPort(port_id);
                if (port.getFixedIPs().size() < 1) {
                    return Response.status((int)400).build();
                }
                if (port.getFixedIPs().size() > 1) {
                    fixedIP = singleton.getFixedIPAddress();
                    if (fixedIP == null) {
                        return Response.status((int)400).build();
                    }
                    Iterator i = port.getFixedIPs().iterator();
                    boolean validFixedIP = false;
                    while (i.hasNext() && !validFixedIP) {
                        Neutron_IPs ip = (Neutron_IPs)i.next();
                        if (!ip.getIpAddress().equals(fixedIP)) continue;
                        validFixedIP = true;
                    }
                    if (!validFixedIP) {
                        return Response.status((int)400).build();
                    }
                } else {
                    fixedIP = ((Neutron_IPs)port.getFixedIPs().get(0)).getIpAddress();
                    if (singleton.getFixedIPAddress() != null && !fixedIP.equalsIgnoreCase(singleton.getFixedIPAddress())) {
                        return Response.status((int)400).build();
                    }
                }
                if (port.isBoundToFloatingIP(fixedIP)) {
                    return Response.status((int)409).build();
                }
                singleton.setFixedIPAddress(fixedIP);
            }
            if ((instances = ServiceHelper.getGlobalInstances(INeutronFloatingIPAware.class, (Object)this, null)) != null) {
                for (Object instance : instances) {
                    service = (INeutronFloatingIPAware)instance;
                    int status = service.canCreateFloatingIP(singleton);
                    if (status >= 200 && status <= 299) continue;
                    return Response.status((int)status).build();
                }
            }
            floatingIPInterface.addFloatingIP(singleton);
            if (instances != null) {
                for (Object instance : instances) {
                    service = (INeutronFloatingIPAware)instance;
                    service.neutronFloatingIPCreated(singleton);
                }
            }
        } else {
            return Response.status((int)400).build();
        }
        return Response.status((int)201).entity((Object)input).build();
    }

    @Path(value="{floatingipUUID}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Operation successful"), @ResponseCode(code=400, condition="Bad Request"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=409, condition="Conflict"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response updateFloatingIP(@PathParam(value="floatingipUUID") String floatingipUUID, NeutronFloatingIPRequest input) {
        INeutronFloatingIPAware service;
        String port_id;
        INeutronFloatingIPCRUD floatingIPInterface = NeutronCRUDInterfaces.getINeutronFloatingIPCRUD((Object)this);
        if (floatingIPInterface == null) {
            throw new ServiceUnavailableException("Floating IP CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronNetworkCRUD networkInterface = NeutronCRUDInterfaces.getINeutronNetworkCRUD((Object)this);
        if (networkInterface == null) {
            throw new ServiceUnavailableException("Network CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronSubnetCRUD subnetInterface = NeutronCRUDInterfaces.getINeutronSubnetCRUD((Object)this);
        if (subnetInterface == null) {
            throw new ServiceUnavailableException("Subnet CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        INeutronPortCRUD portInterface = NeutronCRUDInterfaces.getINeutronPortCRUD((Object)this);
        if (portInterface == null) {
            throw new ServiceUnavailableException("Port CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!floatingIPInterface.floatingIPExists(floatingipUUID)) {
            return Response.status((int)404).build();
        }
        NeutronFloatingIP sourceFloatingIP = floatingIPInterface.getFloatingIP(floatingipUUID);
        if (!input.isSingleton()) {
            return Response.status((int)400).build();
        }
        NeutronFloatingIP singleton = input.getSingleton();
        if (singleton.getID() != null) {
            return Response.status((int)400).build();
        }
        NeutronNetwork externNetwork = networkInterface.getNetwork(sourceFloatingIP.getFloatingNetworkUUID());
        String floatingIP = singleton.getFloatingIPAddress();
        if (floatingIP != null) {
            if (externNetwork.getSubnets().size() > 1) {
                return Response.status((int)400).build();
            }
            NeutronSubnet externSubnet = subnetInterface.getSubnet((String)externNetwork.getSubnets().get(0));
            if (!externSubnet.isValidIP(floatingIP)) {
                return Response.status((int)400).build();
            }
            if (externSubnet.isIPInUse(floatingIP)) {
                return Response.status((int)409).build();
            }
        }
        if ((port_id = singleton.getPortUUID()) != null) {
            String fixedIP = null;
            if (!portInterface.portExists(port_id)) {
                return Response.status((int)404).build();
            }
            NeutronPort port = portInterface.getPort(port_id);
            if (port.getFixedIPs().size() < 1) {
                return Response.status((int)400).build();
            }
            if (port.getFixedIPs().size() > 1) {
                fixedIP = singleton.getFixedIPAddress();
                if (fixedIP == null) {
                    return Response.status((int)400).build();
                }
                Iterator i = port.getFixedIPs().iterator();
                boolean validFixedIP = false;
                while (i.hasNext() && !validFixedIP) {
                    Neutron_IPs ip = (Neutron_IPs)i.next();
                    if (!ip.getIpAddress().equals(fixedIP)) continue;
                    validFixedIP = true;
                }
                if (!validFixedIP) {
                    return Response.status((int)400).build();
                }
            } else {
                fixedIP = ((Neutron_IPs)port.getFixedIPs().get(0)).getIpAddress();
                if (singleton.getFixedIPAddress() != null && !fixedIP.equalsIgnoreCase(singleton.getFixedIPAddress())) {
                    return Response.status((int)400).build();
                }
            }
            if (port.isBoundToFloatingIP(fixedIP)) {
                return Response.status((int)409).build();
            }
            singleton.setFixedIPAddress(fixedIP);
        }
        NeutronFloatingIP target = floatingIPInterface.getFloatingIP(floatingipUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronFloatingIPAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronFloatingIPAware)instance;
                int status = service.canUpdateFloatingIP(singleton, target);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        floatingIPInterface.updateFloatingIP(floatingipUUID, singleton);
        target = floatingIPInterface.getFloatingIP(floatingipUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronFloatingIPAware)instance;
                service.neutronFloatingIPUpdated(target);
            }
        }
        return Response.status((int)200).entity((Object)new NeutronFloatingIPRequest(target)).build();
    }

    @Path(value="{floatingipUUID}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="No Content"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="Not Found"), @ResponseCode(code=501, condition="Not Implemented")})
    public Response deleteFloatingIP(@PathParam(value="floatingipUUID") String floatingipUUID) {
        INeutronFloatingIPAware service;
        INeutronFloatingIPCRUD floatingIPInterface = NeutronCRUDInterfaces.getINeutronFloatingIPCRUD((Object)this);
        if (floatingIPInterface == null) {
            throw new ServiceUnavailableException("Floating IP CRUD Interface " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        if (!floatingIPInterface.floatingIPExists(floatingipUUID)) {
            return Response.status((int)404).build();
        }
        NeutronFloatingIP singleton = floatingIPInterface.getFloatingIP(floatingipUUID);
        Object[] instances = ServiceHelper.getGlobalInstances(INeutronFloatingIPAware.class, (Object)this, null);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronFloatingIPAware)instance;
                int status = service.canDeleteFloatingIP(singleton);
                if (status >= 200 && status <= 299) continue;
                return Response.status((int)status).build();
            }
        }
        floatingIPInterface.removeFloatingIP(floatingipUUID);
        if (instances != null) {
            for (Object instance : instances) {
                service = (INeutronFloatingIPAware)instance;
                service.neutronFloatingIPDeleted(singleton);
            }
        }
        return Response.status((int)204).build();
    }
}

