/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.devices.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.devices.web.DevicesJsonBean;
import org.opendaylight.controller.devices.web.NodeJsonBean;
import org.opendaylight.controller.devices.web.PortJsonBean;
import org.opendaylight.controller.devices.web.SpanPortJsonBean;
import org.opendaylight.controller.devices.web.StatusJsonBean;
import org.opendaylight.controller.devices.web.SubnetGatewayPortBean;
import org.opendaylight.controller.forwarding.staticrouting.IForwardingStaticRouting;
import org.opendaylight.controller.forwarding.staticrouting.StaticRouteConfig;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.connection.ConnectionConstants;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.ForwardingMode;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.State;
import org.opendaylight.controller.sal.core.Tier;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.HexEncode;
import org.opendaylight.controller.sal.utils.NetUtils;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.sal.utils.TierHelper;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.SpanConfig;
import org.opendaylight.controller.switchmanager.SubnetConfig;
import org.opendaylight.controller.switchmanager.Switch;
import org.opendaylight.controller.switchmanager.SwitchConfig;
import org.opendaylight.controller.web.DaylightWebUtil;
import org.opendaylight.controller.web.IDaylightWeb;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class Devices
implements IDaylightWeb {
    private static final UserLevel AUTH_LEVEL = UserLevel.CONTAINERUSER;
    private static final String WEB_NAME = "Devices";
    private static final String WEB_ID = "devices";
    private static final short WEB_ORDER = 1;

    public Devices() {
        ServiceHelper.registerGlobalService(IDaylightWeb.class, (Object)this, null);
    }

    public String getWebName() {
        return WEB_NAME;
    }

    public String getWebId() {
        return WEB_ID;
    }

    public short getWebOrder() {
        return 1;
    }

    public boolean isAuthorized(UserLevel userLevel) {
        return userLevel.ordinal() <= AUTH_LEVEL.ordinal();
    }

    @RequestMapping(value={"/nodesLearnt"}, method={RequestMethod.GET})
    @ResponseBody
    public DevicesJsonBean getNodesLearnt(HttpServletRequest request, @RequestParam(required=false) String container) {
        Gson gson = new Gson();
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        ArrayList<Map<String, String>> nodeData = new ArrayList<Map<String, String>>();
        if (switchManager != null && privilege != Privilege.NONE) {
            for (Switch device : switchManager.getNetworkDevices()) {
                HashMap<String, String> nodeDatum = new HashMap<String, String>();
                Node node = device.getNode();
                Tier tier = (Tier)switchManager.getNodeProp(node, "tier");
                nodeDatum.put("containerName", containerName);
                Description description = (Description)switchManager.getNodeProp(node, "description");
                String desc = description == null ? "" : description.getValue();
                nodeDatum.put("nodeName", desc);
                nodeDatum.put("nodeId", node.toString());
                int tierNumber = tier == null ? 0 : tier.getValue();
                nodeDatum.put("tierName", TierHelper.getTierName((int)tierNumber) + " (Tier-" + tierNumber + ")");
                nodeDatum.put("tier", tierNumber + "");
                String modeStr = "0";
                ForwardingMode mode = null;
                if (!containerName.equals(GlobalConstants.DEFAULT.toString())) {
                    ISwitchManager switchManagerDefault = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)this);
                    mode = (ForwardingMode)switchManagerDefault.getNodeProp(node, "forwarding");
                } else {
                    mode = (ForwardingMode)switchManager.getNodeProp(node, "forwarding");
                }
                if (mode != null) {
                    modeStr = String.valueOf(mode.getValue());
                }
                nodeDatum.put("mode", modeStr);
                nodeDatum.put("json", gson.toJson(nodeDatum));
                nodeDatum.put("mac", HexEncode.bytesToHexStringFormat((byte[])device.getDataLayerAddress()));
                StringBuffer sb1 = new StringBuffer();
                Set nodeConnectorSet = device.getNodeConnectors();
                if (nodeConnectorSet != null && nodeConnectorSet.size() > 0) {
                    HashMap<Short, String> portList = new HashMap<Short, String>();
                    ArrayList<String> intfList = new ArrayList<String>();
                    for (NodeConnector nodeConnector : nodeConnectorSet) {
                        Class<?> idClass;
                        String nodeConnectorNumberToStr = nodeConnector.getID().toString();
                        Name ncName = (Name)switchManager.getNodeConnectorProp(nodeConnector, "name");
                        Config portStatus = (Config)switchManager.getNodeConnectorProp(nodeConnector, "config");
                        State portState = (State)switchManager.getNodeConnectorProp(nodeConnector, "state");
                        String nodeConnectorName = ncName != null ? ncName.getValue() : "";
                        nodeConnectorName = nodeConnectorName + " (" + nodeConnector.getID() + ")";
                        if (portStatus != null) {
                            if (portStatus.getValue() == 1) {
                                if (portState.getValue() == 1) {
                                    nodeConnectorName = "<span class='admin-up'>" + nodeConnectorName + "</span>";
                                } else if (portState.getValue() == 0) {
                                    nodeConnectorName = "<span class='edge-down'>" + nodeConnectorName + "</span>";
                                }
                            } else if (portStatus.getValue() == 0) {
                                nodeConnectorName = "<span class='admin-down'>" + nodeConnectorName + "</span>";
                            }
                        }
                        if ((idClass = nodeConnector.getID().getClass()).equals(Short.class)) {
                            portList.put(Short.parseShort(nodeConnectorNumberToStr), nodeConnectorName);
                            continue;
                        }
                        intfList.add(nodeConnectorName);
                    }
                    if (portList.size() > 0) {
                        TreeMap sortedPortList = new TreeMap(portList);
                        for (Map.Entry e : sortedPortList.entrySet()) {
                            sb1.append((String)e.getValue());
                            sb1.append("<br>");
                        }
                    } else if (intfList.size() > 0) {
                        for (String intf : intfList) {
                            sb1.append(intf);
                            sb1.append("<br>");
                        }
                    }
                }
                nodeDatum.put("ports", sb1.toString());
                nodeData.add(nodeDatum);
            }
        }
        DevicesJsonBean result = new DevicesJsonBean();
        result.setNodeData(nodeData);
        result.setPrivilege(privilege);
        ArrayList<String> columnNames = new ArrayList<String>();
        columnNames.add("Node ID");
        columnNames.add("Node Name");
        columnNames.add("Tier");
        columnNames.add("Mac Address");
        columnNames.add("Ports");
        columnNames.add("Port Status");
        result.setColumnNames(columnNames);
        return result;
    }

    @RequestMapping(value={"/tiers"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getTiers() {
        return TierHelper.getTiers();
    }

    @RequestMapping(value={"/nodesLearnt/update"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean updateLearntNode(@RequestParam(value="nodeName") String nodeName, @RequestParam(value="nodeId") String nodeId, @RequestParam(value="tier") String tier, @RequestParam(value="operationMode") String operationMode, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            SwitchConfig cfg;
            Status result;
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            HashMap<String, Object> nodeProperties = new HashMap<String, Object>();
            Description desc = new Description(nodeName);
            nodeProperties.put(desc.getName(), desc);
            Tier nodeTier = new Tier(Integer.parseInt(tier));
            nodeProperties.put(nodeTier.getName(), nodeTier);
            if (containerName.equals(GlobalConstants.DEFAULT.toString())) {
                ForwardingMode mode = new ForwardingMode(Integer.parseInt(operationMode));
                nodeProperties.put(mode.getName(), mode);
            }
            if (!(result = switchManager.updateNodeConfig(cfg = new SwitchConfig(nodeId, nodeProperties))).isSuccess()) {
                resultBean.setStatus(false);
                resultBean.setMessage(result.getDescription());
            } else {
                resultBean.setStatus(true);
                resultBean.setMessage("Updated node information successfully");
                DaylightWebUtil.auditlog((String)"Property", (String)userName, (String)"updated", (String)("of Node " + DaylightWebUtil.getNodeDesc((Node)Node.fromString((String)nodeId), (ISwitchManager)switchManager)));
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage("Error updating node information. " + e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/staticRoutes"}, method={RequestMethod.GET})
    @ResponseBody
    public DevicesJsonBean getStaticRoutes(HttpServletRequest request, @RequestParam(required=false) String container) {
        Gson gson = new Gson();
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
        if (staticRouting == null) {
            return null;
        }
        ArrayList<Map<String, String>> staticRoutes = new ArrayList<Map<String, String>>();
        ConcurrentMap routeConfigs = staticRouting.getStaticRouteConfigs();
        if (routeConfigs == null) {
            return null;
        }
        if (privilege != Privilege.NONE) {
            for (StaticRouteConfig conf : routeConfigs.values()) {
                HashMap<String, String> staticRoute = new HashMap<String, String>();
                staticRoute.put("name", conf.getName());
                staticRoute.put("staticRoute", conf.getStaticRoute());
                staticRoute.put("nextHopType", conf.getNextHopType());
                staticRoute.put("nextHop", conf.getNextHop());
                staticRoute.put("json", gson.toJson((Object)conf));
                staticRoutes.add(staticRoute);
            }
        }
        DevicesJsonBean result = new DevicesJsonBean();
        result.setPrivilege(privilege);
        result.setColumnNames(StaticRouteConfig.getGuiFieldsNames());
        result.setNodeData(staticRoutes);
        return result;
    }

    @RequestMapping(value={"/staticRoute/add"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean addStaticRoute(@RequestParam(value="routeName") String routeName, @RequestParam(value="staticRoute") String staticRoute, @RequestParam(value="nextHop") String nextHop, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean result = new StatusJsonBean();
        try {
            IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
            StaticRouteConfig config = new StaticRouteConfig();
            config.setName(routeName);
            config.setStaticRoute(staticRoute);
            config.setNextHop(nextHop);
            Status addStaticRouteResult = staticRouting.addStaticRoute(config);
            if (addStaticRouteResult.isSuccess()) {
                result.setStatus(true);
                result.setMessage("Static Route saved successfully");
                DaylightWebUtil.auditlog((String)"Static Route", (String)userName, (String)"added", (String)routeName, (String)containerName);
            } else {
                result.setStatus(false);
                result.setMessage(addStaticRouteResult.getDescription());
            }
        }
        catch (Exception e) {
            result.setStatus(false);
            result.setMessage("Error - " + e.getMessage());
        }
        return result;
    }

    @RequestMapping(value={"/staticRoute/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean deleteStaticRoute(@RequestParam(value="routesToDelete") String routesToDelete, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            IForwardingStaticRouting staticRouting = (IForwardingStaticRouting)ServiceHelper.getInstance(IForwardingStaticRouting.class, (String)containerName, (Object)this);
            String[] routes = routesToDelete.split(",");
            resultBean.setStatus(true);
            resultBean.setMessage("Successfully deleted selected static routes");
            for (String route : routes) {
                Status result = staticRouting.removeStaticRoute(route);
                if (!result.isSuccess()) {
                    resultBean.setStatus(false);
                    resultBean.setMessage(result.getDescription());
                    break;
                }
                DaylightWebUtil.auditlog((String)"Static Route", (String)userName, (String)"removed", (String)route, (String)containerName);
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage("Error occurred while deleting static routes. " + e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/subnets"}, method={RequestMethod.GET})
    @ResponseBody
    public DevicesJsonBean getSubnetGateways(HttpServletRequest request, @RequestParam(required=false) String container) {
        ISwitchManager switchManager;
        Gson gson = new Gson();
        ArrayList<Map<String, String>> subnets = new ArrayList<Map<String, String>>();
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        if (privilege != Privilege.NONE && (switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this)) != null) {
            for (SubnetConfig conf : switchManager.getSubnetsConfigList()) {
                HashMap<String, String> subnet = new HashMap<String, String>();
                subnet.put("name", conf.getName());
                subnet.put("subnet", conf.getSubnet());
                ArrayList<SubnetGatewayPortBean> portsList = new ArrayList<SubnetGatewayPortBean>();
                Iterator itor = conf.getNodeConnectors().iterator();
                while (itor.hasNext()) {
                    SubnetGatewayPortBean bean = new SubnetGatewayPortBean();
                    NodeConnector nodeConnector = (NodeConnector)itor.next();
                    String nodeName = this.getNodeDesc(nodeConnector.getNode().toString(), containerName);
                    Name ncName = (Name)switchManager.getNodeConnectorProp(nodeConnector, "name");
                    String nodeConnectorName = ncName != null ? ncName.getValue() : "";
                    bean.setNodeName(nodeName);
                    bean.setNodePortName(nodeConnectorName);
                    bean.setNodeId(nodeConnector.getNode().toString());
                    bean.setNodePortId(nodeConnector.toString());
                    portsList.add(bean);
                }
                subnet.put("nodePorts", gson.toJson(portsList));
                subnets.add(subnet);
            }
        }
        DevicesJsonBean result = new DevicesJsonBean();
        result.setPrivilege(privilege);
        result.setColumnNames(SubnetConfig.getGuiFieldsNames());
        result.setNodeData(subnets);
        return result;
    }

    @RequestMapping(value={"/subnetGateway/add"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean addSubnetGateways(@RequestParam(value="gatewayName") String gatewayName, @RequestParam(value="gatewayIPAddress") String gatewayIPAddress, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            SubnetConfig cfgObject = new SubnetConfig(gatewayName, gatewayIPAddress, new ArrayList());
            Status result = switchManager.addSubnet(cfgObject);
            if (result.isSuccess()) {
                resultBean.setStatus(true);
                resultBean.setMessage("Added gateway address successfully");
                DaylightWebUtil.auditlog((String)"Subnet Gateway", (String)userName, (String)"added", (String)gatewayName, (String)containerName);
            } else {
                resultBean.setStatus(false);
                resultBean.setMessage(result.getDescription());
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage(e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/subnetGateway/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean deleteSubnetGateways(@RequestParam(value="gatewaysToDelete") String gatewaysToDelete, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)container, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            String[] subnets = gatewaysToDelete.split(",");
            resultBean.setStatus(true);
            resultBean.setMessage("Added gateway address successfully");
            for (String subnet : subnets) {
                Status result = switchManager.removeSubnet(subnet);
                if (!result.isSuccess()) {
                    resultBean.setStatus(false);
                    resultBean.setMessage(result.getDescription());
                    break;
                }
                DaylightWebUtil.auditlog((String)"Subnet Gateway", (String)userName, (String)"removed", (String)subnet, (String)containerName);
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage(e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/subnetGateway/ports/add"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean addSubnetGatewayPort(@RequestParam(value="portsName") String portsName, @RequestParam(value="ports") String ports, @RequestParam(value="nodeId") String nodeId, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            ArrayList<String> toAdd = new ArrayList<String>();
            for (String port : ports.split(",")) {
                toAdd.add(port);
            }
            Status result = switchManager.addPortsToSubnet(portsName, toAdd);
            if (result.isSuccess()) {
                resultBean.setStatus(true);
                resultBean.setMessage("Added ports to subnet gateway address successfully");
                for (String port : toAdd) {
                    DaylightWebUtil.auditlog((String)"Port", (String)userName, (String)"added", (String)(DaylightWebUtil.getPortName((NodeConnector)NodeConnector.fromString((String)port), (ISwitchManager)switchManager) + " to Subnet Gateway " + portsName), (String)containerName);
                }
            } else {
                resultBean.setStatus(false);
                resultBean.setMessage(result.getDescription());
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage(e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/subnetGateway/ports/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean deleteSubnetGatewayPort(@RequestParam(value="gatewayName") String gatewayName, @RequestParam(value="nodePort") String nodePort, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String port : nodePort.split(",")) {
                toRemove.add(port);
            }
            Status result = switchManager.removePortsFromSubnet(gatewayName, toRemove);
            if (result.isSuccess()) {
                resultBean.setStatus(true);
                resultBean.setMessage("Deleted port from subnet gateway address successfully");
                for (String port : toRemove) {
                    DaylightWebUtil.auditlog((String)"Port", (String)userName, (String)"removed", (String)(DaylightWebUtil.getPortName((NodeConnector)NodeConnector.fromString((String)port), (ISwitchManager)switchManager) + " from Subnet Gateway " + gatewayName), (String)containerName);
                }
            } else {
                resultBean.setStatus(false);
                resultBean.setMessage(result.getDescription());
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage(e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/spanPorts"}, method={RequestMethod.GET})
    @ResponseBody
    public DevicesJsonBean getSpanPorts(HttpServletRequest request, @RequestParam(required=false) String container) {
        Gson gson = new Gson();
        ArrayList<Map<String, String>> spanConfigs = new ArrayList<Map<String, String>>();
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        Privilege privilege = DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this);
        if (privilege != Privilege.NONE) {
            ArrayList<String> spanConfigs_json = new ArrayList<String>();
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            if (switchManager != null) {
                for (SpanConfig conf : switchManager.getSpanConfigList()) {
                    spanConfigs_json.add(gson.toJson((Object)conf));
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            for (String config_json : spanConfigs_json) {
                try {
                    Map config_data = (Map)mapper.readValue(config_json, HashMap.class);
                    HashMap config = new HashMap();
                    for (String name : config_data.keySet()) {
                        config.put(name, config_data.get(name));
                        config.put("nodeName", this.getNodeDesc((String)config_data.get("nodeId"), containerName));
                        NodeConnector spanPortNodeConnector = NodeConnector.fromString((String)((String)config_data.get("spanPort")));
                        Name ncName = (Name)switchManager.getNodeConnectorProp(spanPortNodeConnector, "name");
                        String spanPortName = ncName != null ? ncName.getValue() : "";
                        config.put("spanPortName", spanPortName);
                    }
                    config.put("json", config_json);
                    spanConfigs.add(config);
                }
                catch (Exception e) {}
            }
        }
        DevicesJsonBean result = new DevicesJsonBean();
        result.setPrivilege(privilege);
        result.setColumnNames(SpanConfig.getGuiFieldsNames());
        result.setNodeData(spanConfigs);
        return result;
    }

    @RequestMapping(value={"/nodeports"})
    @ResponseBody
    public String getNodePorts(HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) == Privilege.NONE) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        if (switchManager == null) {
            return null;
        }
        ArrayList<NodeJsonBean> nodeJsonBeans = new ArrayList<NodeJsonBean>();
        for (Switch node : switchManager.getNetworkDevices()) {
            NodeJsonBean nodeJsonBean = new NodeJsonBean();
            ArrayList<PortJsonBean> port = new ArrayList<PortJsonBean>();
            Set nodeConnectorSet = node.getNodeConnectors();
            if (nodeConnectorSet != null) {
                for (NodeConnector nodeConnector : nodeConnectorSet) {
                    String nodeConnectorName = ((Name)switchManager.getNodeConnectorProp(nodeConnector, "name")).getValue();
                    port.add(new PortJsonBean(nodeConnector.getID().toString(), nodeConnectorName, nodeConnector.toString()));
                }
            }
            nodeJsonBean.setNodeId(node.getNode().toString());
            nodeJsonBean.setNodeName(this.getNodeDesc(node.getNode().toString(), containerName));
            nodeJsonBean.setNodePorts(port);
            nodeJsonBeans.add(nodeJsonBean);
        }
        return new Gson().toJson(nodeJsonBeans);
    }

    @RequestMapping(value={"/spanPorts/add"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean addSpanPort(@RequestParam(value="jsonData") String jsonData, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            Gson gson = new Gson();
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            SpanConfig cfgObject = (SpanConfig)gson.fromJson(jsonData, SpanConfig.class);
            Status result = switchManager.addSpanConfig(cfgObject);
            if (result.isSuccess()) {
                resultBean.setStatus(true);
                resultBean.setMessage("SPAN Port added successfully");
                DaylightWebUtil.auditlog((String)"SPAN Port", (String)userName, (String)"added", (String)DaylightWebUtil.getPortName((NodeConnector)NodeConnector.fromString((String)cfgObject.getSpanPort()), (ISwitchManager)switchManager), (String)containerName);
            } else {
                resultBean.setStatus(false);
                resultBean.setMessage(result.getDescription());
            }
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage("Error occurred while adding span port. " + e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/spanPorts/delete"}, method={RequestMethod.GET})
    @ResponseBody
    public StatusJsonBean deleteSpanPorts(@RequestParam(value="spanPortsToDelete") String spanPortsToDelete, HttpServletRequest request, @RequestParam(required=false) String container) {
        String containerName = container == null ? GlobalConstants.DEFAULT.toString() : container;
        String userName = request.getUserPrincipal().getName();
        if (DaylightWebUtil.getContainerPrivilege((String)userName, (String)containerName, (Object)this) != Privilege.WRITE) {
            return this.unauthorizedMessage();
        }
        StatusJsonBean resultBean = new StatusJsonBean();
        try {
            Gson gson = new Gson();
            ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
            Type collectionType = new TypeToken<List<SpanPortJsonBean>>(){}.getType();
            List jsonBeanList = (List)gson.fromJson(spanPortsToDelete, collectionType);
            for (SpanPortJsonBean jsonBean : jsonBeanList) {
                SpanConfig cfgObject = (SpanConfig)gson.fromJson(gson.toJson((Object)jsonBean), SpanConfig.class);
                Status result = switchManager.removeSpanConfig(cfgObject);
                if (!result.isSuccess()) {
                    resultBean.setStatus(false);
                    resultBean.setMessage(result.getDescription());
                    break;
                }
                DaylightWebUtil.auditlog((String)"SPAN Port", (String)userName, (String)"removed", (String)DaylightWebUtil.getPortName((NodeConnector)NodeConnector.fromString((String)cfgObject.getSpanPort()), (ISwitchManager)switchManager), (String)containerName);
            }
            resultBean.setStatus(true);
            resultBean.setMessage("SPAN Port(s) deleted successfully");
        }
        catch (Exception e) {
            resultBean.setStatus(false);
            resultBean.setMessage("Error occurred while deleting span port. " + e.getMessage());
        }
        return resultBean;
    }

    @RequestMapping(value={"/connect/nodes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<NodeJsonBean> getNodes(HttpServletRequest request) {
        IConnectionManager connectionManager = (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
        if (connectionManager == null) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)this);
        if (switchManager == null) {
            return null;
        }
        Set nodes = connectionManager.getLocalNodes();
        LinkedList<NodeJsonBean> result = new LinkedList<NodeJsonBean>();
        if (nodes == null) {
            return result;
        }
        for (Node node : nodes) {
            Description descriptionProperty = (Description)switchManager.getNodeProp(node, "description");
            String description = node.toString();
            if (descriptionProperty != null) {
                description = descriptionProperty.getValue();
            }
            NodeJsonBean nodeBean = new NodeJsonBean();
            nodeBean.setNodeId(node.getNodeIDString());
            nodeBean.setNodeType(node.getType());
            if (description.equals("None")) {
                nodeBean.setNodeName(node.toString());
            } else {
                nodeBean.setNodeName(description);
            }
            result.add(nodeBean);
        }
        return result;
    }

    @RequestMapping(value={"/connect/{nodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Status addNode(HttpServletRequest request, @PathVariable(value="nodeId") String nodeId, @RequestParam(required=true) String ipAddress, @RequestParam(required=true) String port, @RequestParam(required=false) String nodeType) {
        IConnectionManager connectionManager = (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
        if (connectionManager == null) {
            return new Status(StatusCode.NOTFOUND, "Service not found");
        }
        if (!NetUtils.isIPv4AddressValid((String)ipAddress)) {
            return new Status(StatusCode.NOTACCEPTABLE, "Invalid IP Address: " + ipAddress);
        }
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            return new Status(StatusCode.NOTACCEPTABLE, "Invalid Layer 4 Port: " + port);
        }
        HashMap<ConnectionConstants, String> params = new HashMap<ConnectionConstants, String>();
        params.put(ConnectionConstants.ADDRESS, ipAddress);
        params.put(ConnectionConstants.PORT, port);
        Node node = null;
        node = nodeType != null ? connectionManager.connect(nodeType, nodeId, params) : connectionManager.connect(nodeId, params);
        if (node == null) {
            return new Status(StatusCode.NOTFOUND, "Failed to connect to Node at " + ipAddress + ":" + port);
        }
        return new Status(StatusCode.SUCCESS);
    }

    @RequestMapping(value={"/disconnect/{nodeId}"}, method={RequestMethod.POST})
    @ResponseBody
    public Status removeNode(HttpServletRequest request, @PathVariable(value="nodeId") String nodeId, @RequestParam(required=true) String nodeType) {
        IConnectionManager connectionManager = (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
        if (connectionManager == null) {
            return new Status(StatusCode.NOTFOUND, "Service not found");
        }
        try {
            Node node = new Node(nodeType, (Object)nodeId);
            return connectionManager.disconnect(node);
        }
        catch (Exception e) {
            return new Status(StatusCode.NOTFOUND, "Resource not found");
        }
    }

    private String getNodeDesc(String nodeId, String containerName) {
        Description desc;
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)this);
        String description = "";
        if (switchManager != null && (desc = (Description)switchManager.getNodeProp(Node.fromString((String)nodeId), "description")) != null) {
            description = desc.getValue();
        }
        return description.isEmpty() || description.equalsIgnoreCase("none") ? nodeId : description;
    }

    private StatusJsonBean unauthorizedMessage() {
        StatusJsonBean message = new StatusJsonBean();
        message.setStatus(false);
        message.setMessage("Operation not authorized");
        return message;
    }

    @RequestMapping(value={"login"})
    public String login(HttpServletRequest request, HttpServletResponse response) {
        return "forward:/";
    }
}

