/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.usermanager.northbound;

import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.codehaus.enunciate.jaxrs.TypeHint;
import org.opendaylight.controller.northbound.commons.RestMessages;
import org.opendaylight.controller.northbound.commons.exception.BadRequestException;
import org.opendaylight.controller.northbound.commons.exception.ResourceConflictException;
import org.opendaylight.controller.northbound.commons.exception.ServiceUnavailableException;
import org.opendaylight.controller.northbound.commons.exception.UnauthorizedException;
import org.opendaylight.controller.northbound.commons.utils.NorthboundUtils;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.usermanager.IUserManager;
import org.opendaylight.controller.usermanager.UserConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class UserManagerNorthbound {
    protected static final Logger logger = LoggerFactory.getLogger(UserManagerNorthbound.class);
    private String username;
    @Context
    UriInfo uriInfo;

    @Context
    public void setSecurityContext(SecurityContext context) {
        if (context != null && context.getUserPrincipal() != null) {
            this.username = context.getUserPrincipal().getName();
        }
    }

    protected String getUserName() {
        return this.username;
    }

    private void handleNameMismatch(String name, String nameinURL) {
        if (name == null || nameinURL == null) {
            throw new BadRequestException(RestMessages.INVALIDDATA.toString() + " : Name is null");
        }
        if (name.equals(nameinURL)) {
            return;
        }
        throw new ResourceConflictException(RestMessages.INVALIDDATA.toString() + " : Name in URL does not match the name in request body");
    }

    @Path(value="/users")
    @POST
    @StatusCodes(value={@ResponseCode(code=201, condition="User created successfully"), @ResponseCode(code=400, condition="Invalid data passed"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=409, condition="User name in url conflicts with name in request body"), @ResponseCode(code=404, condition="User config is null"), @ResponseCode(code=500, condition="Internal Server Error: Addition of user failed"), @ResponseCode(code=503, condition="Service unavailable")})
    @Consumes(value={"application/json", "application/xml"})
    public Response addLocalUser(@TypeHint(value=UserConfig.class) UserConfig userConfigData) {
        if (!this.isAdminUser()) {
            throw new UnauthorizedException("User is not authorized to perform user management operations ");
        }
        UserConfig userCfgObject = new UserConfig(userConfigData.getUser(), userConfigData.getPassword(), userConfigData.getRoles());
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status status = userManager.addLocalUser(userCfgObject);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"User", (String)this.username, (String)"added", (String)userCfgObject.getUser());
            URI uri = this.uriInfo.getAbsolutePathBuilder().path("/" + userCfgObject.getUser()).build(new Object[0]);
            return Response.created((URI)uri).build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    @Path(value="/users/{userName}")
    @DELETE
    @StatusCodes(value={@ResponseCode(code=204, condition="User Deleted Successfully"), @ResponseCode(code=401, condition="User not authorized to perform this operation"), @ResponseCode(code=404, condition="The userName passed was not found"), @ResponseCode(code=500, condition="Internal Server Error : Removal of user failed"), @ResponseCode(code=503, condition="Service unavailable")})
    public Response removeLocalUser(@PathParam(value="userName") String userToBeRemoved) {
        if (!this.isAdminUser()) {
            throw new UnauthorizedException("User is not authorized to perform user management operations ");
        }
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            throw new ServiceUnavailableException("UserManager " + RestMessages.SERVICEUNAVAILABLE.toString());
        }
        Status status = userManager.removeLocalUser(userToBeRemoved);
        if (status.isSuccess()) {
            NorthboundUtils.auditlog((String)"User", (String)this.username, (String)"removed", (String)userToBeRemoved);
            return Response.noContent().build();
        }
        return NorthboundUtils.getResponse((Status)status);
    }

    private boolean isAdminUser() {
        IUserManager auth = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        return auth.getUserLevel(this.getUserName()).ordinal() <= UserLevel.NETWORKADMIN.ordinal();
    }
}

