/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;

public abstract class OF10MatchSerializer {
    private static final byte PADDING_IN_MATCH = 1;
    private static final byte PADDING_IN_MATCH_2 = 2;
    private static final byte NW_SRC_SHIFT = 8;
    private static final byte NW_DST_SHIFT = 14;

    public static void encodeMatchV10(ByteBuf out, MatchV10 match) {
        out.writeInt(OF10MatchSerializer.encodeWildcards(match.getWildcards(), match.getNwSrcMask(), match.getNwDstMask()));
        out.writeShort(match.getInPort().intValue());
        out.writeBytes(ByteBufUtils.macAddressToBytes(match.getDlSrc().getValue()));
        out.writeBytes(ByteBufUtils.macAddressToBytes(match.getDlDst().getValue()));
        out.writeShort(match.getDlVlan().intValue());
        out.writeByte((int)match.getDlVlanPcp().shortValue());
        ByteBufUtils.padBuffer(1, out);
        out.writeShort(match.getDlType().intValue());
        out.writeByte((int)match.getNwTos().shortValue());
        out.writeByte((int)match.getNwProto().shortValue());
        ByteBufUtils.padBuffer(2, out);
        String[] srcGroups = match.getNwSrc().getValue().split("\\.");
        for (int i = 0; i < srcGroups.length; ++i) {
            out.writeByte(Integer.parseInt(srcGroups[i]));
        }
        String[] dstGroups = match.getNwDst().getValue().split("\\.");
        for (int i = 0; i < dstGroups.length; ++i) {
            out.writeByte(Integer.parseInt(dstGroups[i]));
        }
        out.writeShort(match.getTpSrc().intValue());
        out.writeShort(match.getTpDst().intValue());
    }

    private static int encodeWildcards(FlowWildcardsV10 wildcards, short srcMask, short dstMask) {
        int bitmask = 0;
        HashMap<Integer, Boolean> wildcardsMap = new HashMap<Integer, Boolean>();
        wildcardsMap.put(0, wildcards.isINPORT());
        wildcardsMap.put(1, wildcards.isDLVLAN());
        wildcardsMap.put(2, wildcards.isDLSRC());
        wildcardsMap.put(3, wildcards.isDLDST());
        wildcardsMap.put(4, wildcards.isDLTYPE());
        wildcardsMap.put(5, wildcards.isNWPROTO());
        wildcardsMap.put(6, wildcards.isTPSRC());
        wildcardsMap.put(7, wildcards.isTPDST());
        wildcardsMap.put(20, wildcards.isDLVLANPCP());
        wildcardsMap.put(21, wildcards.isNWTOS());
        bitmask = ByteBufUtils.fillBitMaskFromMap(wildcardsMap);
        bitmask |= 32 - srcMask << 8;
        return bitmask |= 32 - dstMask << 14;
    }
}

