/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import com.google.common.base.Joiner;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowWildcardsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.match.v10.grouping.MatchV10Builder;

public abstract class OF10MatchDeserializer {
    private static final byte PADDING_IN_MATCH = 1;
    private static final byte PADDING_IN_MATCH_2 = 2;
    private static final byte NW_SRC_BITS = 6;
    private static final byte NW_SRC_SHIFT = 8;
    private static final int NW_SRC_MASK = 16128;
    private static final byte NW_DST_BITS = 6;
    private static final byte NW_DST_SHIFT = 14;
    private static final int NW_DST_MASK = 1032192;

    public static MatchV10 createMatchV10(ByteBuf rawMessage) {
        MatchV10Builder builder = new MatchV10Builder();
        long wildcards = rawMessage.readUnsignedInt();
        builder.setWildcards(OF10MatchDeserializer.createWildcards(wildcards));
        builder.setNwSrcMask(Short.valueOf(OF10MatchDeserializer.decodeNwSrcMask(wildcards)));
        builder.setNwDstMask(Short.valueOf(OF10MatchDeserializer.decodeNwDstMask(wildcards)));
        builder.setInPort(Integer.valueOf(rawMessage.readUnsignedShort()));
        byte[] dlSrc = new byte[6];
        rawMessage.readBytes(dlSrc);
        builder.setDlSrc(new MacAddress(ByteBufUtils.macAddressToString(dlSrc)));
        byte[] dlDst = new byte[6];
        rawMessage.readBytes(dlDst);
        builder.setDlDst(new MacAddress(ByteBufUtils.macAddressToString(dlDst)));
        builder.setDlVlan(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setDlVlanPcp(Short.valueOf(rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        builder.setDlType(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setNwTos(Short.valueOf(rawMessage.readUnsignedByte()));
        builder.setNwProto(Short.valueOf(rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(2);
        ArrayList<String> srcGroups = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            srcGroups.add(Short.toString(rawMessage.readUnsignedByte()));
        }
        Joiner joiner = Joiner.on((String)".");
        builder.setNwSrc(new Ipv4Address(joiner.join(srcGroups)));
        ArrayList<String> dstGroups = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            dstGroups.add(Short.toString(rawMessage.readUnsignedByte()));
        }
        builder.setNwDst(new Ipv4Address(joiner.join(dstGroups)));
        builder.setTpSrc(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setTpDst(Integer.valueOf(rawMessage.readUnsignedShort()));
        return builder.build();
    }

    public static FlowWildcardsV10 createWildcards(long input) {
        boolean _iNPORT = (input & 1L) != 0L;
        boolean _dLVLAN = (input & 2L) != 0L;
        boolean _dLSRC = (input & 4L) != 0L;
        boolean _dLDST = (input & 8L) != 0L;
        boolean _dLTYPE = (input & 0x10L) != 0L;
        boolean _nWPROTO = (input & 0x20L) != 0L;
        boolean _tPSRC = (input & 0x40L) != 0L;
        boolean _tPDST = (input & 0x80L) != 0L;
        boolean _dLVLANPCP = (input & 0x100000L) != 0L;
        boolean _nWTOS = (input & 0x200000L) != 0L;
        return new FlowWildcardsV10(Boolean.valueOf(_dLDST), Boolean.valueOf(_dLSRC), Boolean.valueOf(_dLTYPE), Boolean.valueOf(_dLVLAN), Boolean.valueOf(_dLVLANPCP), Boolean.valueOf(_iNPORT), Boolean.valueOf(_nWPROTO), Boolean.valueOf(_nWTOS), Boolean.valueOf(_tPDST), Boolean.valueOf(_tPSRC));
    }

    public static short decodeNwSrcMask(long input) {
        return (short)Math.max(32L - ((input & 0x3F00L) >> 8), 0L);
    }

    public static short decodeNwDstMask(long input) {
        return (short)Math.max(32L - ((input & 0xFC000L) >> 14), 0L);
    }
}

