/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DlAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IpAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Enqueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.StripVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;

public abstract class OF10ActionsSerializer {
    private static final byte OUTPUT_CODE = 0;
    private static final byte SET_VLAN_VID_CODE = 1;
    private static final byte SET_VLAN_PCP_CODE = 2;
    private static final byte STRIP_VLAN_CODE = 3;
    private static final byte SET_DL_SRC_CODE = 4;
    private static final byte SET_DL_DST_CODE = 5;
    private static final byte SET_NW_SRC_CODE = 6;
    private static final byte SET_NW_DST_CODE = 7;
    private static final byte SET_NW_TOS_CODE = 8;
    private static final byte SET_TP_SRC_CODE = 9;
    private static final byte SET_TP_DST_CODE = 10;
    private static final byte ENQUEUE_CODE = 11;
    private static final int EXPERIMENTER_CODE = 65535;
    private static final byte GENERIC_ACTION_LENGTH = 8;
    private static final byte PADDING_IN_GENERIC_ACTION = 4;
    private static final byte OUTPUT_LENGTH = 8;
    private static final byte SET_VLAN_VID_LENGTH = 8;
    private static final byte PADDING_IN_SET_VLAN_VID_ACTION = 2;
    private static final byte SET_VLAN_PCP_LENGTH = 8;
    private static final byte PADDING_IN_SET_VLAN_PCP_ACTION = 3;
    private static final byte DL_ADDRESS_ACTION_LENGTH = 16;
    private static final byte PADDING_IN_DL_ADDRESS_ACTION = 6;
    private static final byte SET_NW_TOS_LENGTH = 8;
    private static final byte PADDING_IN_SET_NW_TOS_ACTION = 3;
    private static final byte IP_ADDRESS_ACTION_LENGTH = 8;
    private static final byte TP_PORT_ACTION_LENGTH = 8;
    private static final byte PADDING_IN_TP_PORT_ACTION = 2;
    private static final byte ENQUEUE_LENGTH = 16;
    private static final byte PADDING_IN_ENQUEUE_ACTION = 6;
    private static final byte EXPERIMENTER_LENGTH = 8;

    public static void encodeActionsV10(ByteBuf out, List<ActionsList> actionsList) {
        if (actionsList == null) {
            return;
        }
        for (ActionsList list : actionsList) {
            Action action = list.getAction();
            if (action.getType().equals(Output.class)) {
                OF10ActionsSerializer.encodeOutputAction(action, out);
                continue;
            }
            if (action.getType().equals(SetVlanVid.class)) {
                OF10ActionsSerializer.encodeSetVlanVidAction(action, out);
                continue;
            }
            if (action.getType().equals(SetVlanPcp.class)) {
                OF10ActionsSerializer.encodeSetVlanPcpAction(action, out);
                continue;
            }
            if (action.getType().equals(StripVlan.class)) {
                OF10ActionsSerializer.encodeGenericAction((byte)3, out);
                continue;
            }
            if (action.getType().equals(SetDlSrc.class)) {
                OF10ActionsSerializer.encodeDlAddressAction(action, out, (byte)4);
                continue;
            }
            if (action.getType().equals(SetDlDst.class)) {
                OF10ActionsSerializer.encodeDlAddressAction(action, out, (byte)5);
                continue;
            }
            if (action.getType().equals(SetNwSrc.class)) {
                OF10ActionsSerializer.encodeIpAddressAction(action, out, (byte)6);
                continue;
            }
            if (action.getType().equals(SetNwDst.class)) {
                OF10ActionsSerializer.encodeIpAddressAction(action, out, (byte)7);
                continue;
            }
            if (action.getType().equals(SetNwTos.class)) {
                OF10ActionsSerializer.encodeNwTosAction(action, out);
                continue;
            }
            if (action.getType().equals(SetTpSrc.class)) {
                OF10ActionsSerializer.encodeTpPortAction(action, out, (byte)9);
                continue;
            }
            if (action.getType().equals(SetTpDst.class)) {
                OF10ActionsSerializer.encodeTpPortAction(action, out, (byte)10);
                continue;
            }
            if (action.getType().equals(Enqueue.class)) {
                OF10ActionsSerializer.encodeEnqueueAction(action, out);
                continue;
            }
            if (!action.getType().equals(Experimenter.class)) continue;
            OF10ActionsSerializer.encodeExperimenterAction(action, out);
        }
    }

    private static void encodeGenericAction(byte code, ByteBuf out) {
        out.writeShort((int)code);
        out.writeShort(8);
        ByteBufUtils.padBuffer(4, out);
    }

    private static void encodeOutputAction(Action action, ByteBuf out) {
        out.writeShort(0);
        out.writeShort(8);
        PortAction port = (PortAction)action.getAugmentation(PortAction.class);
        out.writeShort(port.getPort().getValue().intValue());
        MaxLengthAction maxlength = (MaxLengthAction)action.getAugmentation(MaxLengthAction.class);
        out.writeShort(maxlength.getMaxLength().intValue());
    }

    private static void encodeSetVlanVidAction(Action action, ByteBuf out) {
        out.writeShort(1);
        out.writeShort(8);
        out.writeShort(((VlanVidAction)action.getAugmentation(VlanVidAction.class)).getVlanVid().intValue());
        ByteBufUtils.padBuffer(2, out);
    }

    private static void encodeSetVlanPcpAction(Action action, ByteBuf out) {
        out.writeShort(2);
        out.writeShort(8);
        out.writeByte((int)((VlanPcpAction)action.getAugmentation(VlanPcpAction.class)).getVlanPcp().shortValue());
        ByteBufUtils.padBuffer(3, out);
    }

    private static void encodeDlAddressAction(Action action, ByteBuf out, byte code) {
        out.writeShort((int)code);
        out.writeShort(16);
        out.writeBytes(ByteBufUtils.macAddressToBytes(((DlAddressAction)action.getAugmentation(DlAddressAction.class)).getDlAddress().getValue()));
        ByteBufUtils.padBuffer(6, out);
    }

    private static void encodeNwTosAction(Action action, ByteBuf out) {
        out.writeShort(8);
        out.writeShort(8);
        out.writeByte((int)((NwTosAction)action.getAugmentation(NwTosAction.class)).getNwTos().shortValue());
        ByteBufUtils.padBuffer(3, out);
    }

    private static void encodeIpAddressAction(Action action, ByteBuf out, byte code) {
        out.writeShort((int)code);
        out.writeShort(8);
        String[] addressGroups = ((IpAddressAction)action.getAugmentation(IpAddressAction.class)).getIpAddress().getValue().split("\\.");
        for (int i = 0; i < addressGroups.length; ++i) {
            out.writeByte(Integer.parseInt(addressGroups[i]));
        }
    }

    private static void encodeTpPortAction(Action action, ByteBuf out, byte code) {
        out.writeShort((int)code);
        out.writeShort(8);
        PortAction port = (PortAction)action.getAugmentation(PortAction.class);
        out.writeShort(port.getPort().getValue().intValue());
        ByteBufUtils.padBuffer(2, out);
    }

    private static void encodeEnqueueAction(Action action, ByteBuf out) {
        out.writeShort(11);
        out.writeShort(16);
        PortAction port = (PortAction)action.getAugmentation(PortAction.class);
        out.writeShort(port.getPort().getValue().intValue());
        ByteBufUtils.padBuffer(6, out);
        QueueIdAction queueId = (QueueIdAction)action.getAugmentation(QueueIdAction.class);
        out.writeInt(queueId.getQueueId().intValue());
    }

    private static void encodeExperimenterAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(65535);
        outBuffer.writeShort(8);
        ExperimenterAction experimenter = (ExperimenterAction)action.getAugmentation(ExperimenterAction.class);
        outBuffer.writeInt(experimenter.getExperimenter().intValue());
    }

    public static int computeActionsLength(List<ActionsList> actionsList) {
        int length = 0;
        if (actionsList != null) {
            for (ActionsList list : actionsList) {
                Action action = list.getAction();
                if (action.getType().equals(Output.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetVlanVid.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetVlanPcp.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(StripVlan.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetDlSrc.class)) {
                    length += 16;
                    continue;
                }
                if (action.getType().equals(SetDlDst.class)) {
                    length += 16;
                    continue;
                }
                if (action.getType().equals(SetNwSrc.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetNwDst.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetNwTos.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetTpSrc.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(SetTpDst.class)) {
                    length += 8;
                    continue;
                }
                if (action.getType().equals(Enqueue.class)) {
                    length += 16;
                    continue;
                }
                if (!action.getType().equals(Experimenter.class)) continue;
                length += 8;
            }
        }
        return length;
    }
}

