/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import com.google.common.base.Joiner;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DlAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DlAddressActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IpAddressAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IpAddressActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTosActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Enqueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetDlSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetTpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetVlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.StripVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public abstract class OF10ActionsDeserializer {
    private static final byte PADDING_IN_SET_VLAN_VID_ACTION = 2;
    private static final byte PADDING_IN_SET_VLAN_PCP_ACTION = 3;
    private static final byte PADDING_IN_STRIP_VLAN_ACTION = 4;
    private static final byte PADDING_IN_SET_DL_ACTION = 6;
    private static final byte PADDING_IN_NW_TOS_ACTION = 3;
    private static final byte PADDING_IN_TP_ACTION = 2;
    private static final byte PADDING_IN_ENQUEUE_ACTION = 6;

    public static List<ActionsList> createActionsList(ByteBuf input) {
        ArrayList<ActionsList> actions = new ArrayList<ActionsList>();
        while (input.readableBytes() > 0) {
            int type = input.readUnsignedShort();
            input.skipBytes(2);
            actions.add(OF10ActionsDeserializer.decodeAction(input, type));
        }
        return actions;
    }

    public static List<ActionsList> createActionsList(ByteBuf input, int actionsLength) {
        ArrayList<ActionsList> actions = new ArrayList<ActionsList>();
        for (int currentLength = 0; currentLength < actionsLength; currentLength += input.readUnsignedShort()) {
            int type = input.readUnsignedShort();
            actions.add(OF10ActionsDeserializer.decodeAction(input, type));
        }
        return actions;
    }

    private static ActionsList decodeAction(ByteBuf input, int type) {
        ActionsListBuilder actionsBuilder = new ActionsListBuilder();
        ActionsList actionsList = null;
        switch (type) {
            case 0: {
                actionsList = OF10ActionsDeserializer.createOutputAction(input, actionsBuilder);
                break;
            }
            case 1: {
                actionsList = OF10ActionsDeserializer.createSetVlanVidAction(input, actionsBuilder);
                break;
            }
            case 2: {
                actionsList = OF10ActionsDeserializer.createVlanPcpAction(input, actionsBuilder);
                break;
            }
            case 3: {
                actionsList = OF10ActionsDeserializer.createStripVlanAction(input, actionsBuilder);
                break;
            }
            case 4: {
                actionsList = OF10ActionsDeserializer.createSetDlSrcAction(input, actionsBuilder);
                break;
            }
            case 5: {
                actionsList = OF10ActionsDeserializer.createSetDlDstAction(input, actionsBuilder);
                break;
            }
            case 6: {
                actionsList = OF10ActionsDeserializer.createSetNwSrcAction(input, actionsBuilder);
                break;
            }
            case 7: {
                actionsList = OF10ActionsDeserializer.createSetNwDstAction(input, actionsBuilder);
                break;
            }
            case 8: {
                actionsList = OF10ActionsDeserializer.createSetNwTosAction(input, actionsBuilder);
                break;
            }
            case 9: {
                actionsList = OF10ActionsDeserializer.createSetTpSrcAction(input, actionsBuilder);
                break;
            }
            case 10: {
                actionsList = OF10ActionsDeserializer.createSetTpDstAction(input, actionsBuilder);
                break;
            }
            case 11: {
                actionsList = OF10ActionsDeserializer.createEnqueueAction(input, actionsBuilder);
                break;
            }
            case 65535: {
                actionsList = OF10ActionsDeserializer.createExperimenterAction(input, actionsBuilder);
                break;
            }
        }
        return actionsList;
    }

    public static ActionsList createOutputAction(ByteBuf in, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Output.class);
        OF10ActionsDeserializer.createPortAugmentation(in, actionBuilder);
        MaxLengthActionBuilder maxLen = new MaxLengthActionBuilder();
        maxLen.setMaxLength(Integer.valueOf(in.readUnsignedShort()));
        actionBuilder.addAugmentation(MaxLengthAction.class, (Augmentation)maxLen.build());
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetVlanVidAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetVlanVid.class);
        VlanVidActionBuilder vlanBuilder = new VlanVidActionBuilder();
        vlanBuilder.setVlanVid(Integer.valueOf(input.readUnsignedShort()));
        input.skipBytes(2);
        actionBuilder.addAugmentation(VlanVidAction.class, (Augmentation)vlanBuilder.build());
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createVlanPcpAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetVlanPcp.class);
        VlanPcpActionBuilder vlanBuilder = new VlanPcpActionBuilder();
        vlanBuilder.setVlanPcp(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(3);
        actionBuilder.addAugmentation(VlanPcpAction.class, (Augmentation)vlanBuilder.build());
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createStripVlanAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(StripVlan.class);
        input.skipBytes(4);
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetDlSrcAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetDlSrc.class);
        actionBuilder.addAugmentation(DlAddressAction.class, (Augmentation)OF10ActionsDeserializer.createDlAugmentationAndPad(input));
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetDlDstAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetDlDst.class);
        actionBuilder.addAugmentation(DlAddressAction.class, (Augmentation)OF10ActionsDeserializer.createDlAugmentationAndPad(input));
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static DlAddressAction createDlAugmentationAndPad(ByteBuf input) {
        DlAddressActionBuilder dlBuilder = new DlAddressActionBuilder();
        byte[] address = new byte[6];
        input.readBytes(address);
        dlBuilder.setDlAddress(new MacAddress(ByteBufUtils.macAddressToString(address)));
        input.skipBytes(6);
        return dlBuilder.build();
    }

    private static ActionsList createSetNwSrcAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetNwSrc.class);
        actionBuilder.addAugmentation(IpAddressAction.class, OF10ActionsDeserializer.createNwAddressAugmentationAndPad(input));
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetNwDstAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetNwDst.class);
        actionBuilder.addAugmentation(IpAddressAction.class, OF10ActionsDeserializer.createNwAddressAugmentationAndPad(input));
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static Augmentation<Action> createNwAddressAugmentationAndPad(ByteBuf input) {
        IpAddressActionBuilder ipBuilder = new IpAddressActionBuilder();
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            groups.add(Short.toString(input.readUnsignedByte()));
        }
        Joiner joiner = Joiner.on((String)".");
        ipBuilder.setIpAddress(new Ipv4Address(joiner.join(groups)));
        return ipBuilder.build();
    }

    private static ActionsList createSetNwTosAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetNwTos.class);
        NwTosActionBuilder tosBuilder = new NwTosActionBuilder();
        tosBuilder.setNwTos(Short.valueOf(input.readUnsignedByte()));
        actionBuilder.addAugmentation(NwTosAction.class, (Augmentation)tosBuilder.build());
        input.skipBytes(3);
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetTpSrcAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetTpSrc.class);
        OF10ActionsDeserializer.createPortAugmentation(input, actionBuilder);
        input.skipBytes(2);
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createSetTpDstAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetTpDst.class);
        OF10ActionsDeserializer.createPortAugmentation(input, actionBuilder);
        input.skipBytes(2);
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static void createPortAugmentation(ByteBuf input, ActionBuilder actionBuilder) {
        PortActionBuilder portBuilder = new PortActionBuilder();
        portBuilder.setPort(new PortNumber(Long.valueOf(input.readUnsignedShort())));
        actionBuilder.addAugmentation(PortAction.class, (Augmentation)portBuilder.build());
    }

    private static ActionsList createEnqueueAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Enqueue.class);
        OF10ActionsDeserializer.createPortAugmentation(input, actionBuilder);
        input.skipBytes(6);
        QueueIdActionBuilder queueBuilder = new QueueIdActionBuilder();
        queueBuilder.setQueueId(Long.valueOf(input.readUnsignedInt()));
        actionBuilder.addAugmentation(QueueIdAction.class, (Augmentation)queueBuilder.build());
        builder.setAction(actionBuilder.build());
        return builder.build();
    }

    private static ActionsList createExperimenterAction(ByteBuf input, ActionsListBuilder builder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Experimenter.class);
        ExperimenterActionBuilder expBuilder = new ExperimenterActionBuilder();
        expBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
        actionBuilder.addAugmentation(ExperimenterAction.class, (Augmentation)expBuilder.build());
        builder.setAction(actionBuilder.build());
        return builder.build();
    }
}

