/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.MatchIdsSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Clazz;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MatchSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MatchSerializer.class);
    private static final byte STANDARD_MATCH_TYPE_CODE = 0;
    private static final byte OXM_MATCH_TYPE_CODE = 1;
    private static final int NXM0_CLASS_CODE = 0;
    private static final int NXM1_CLASS_CODE = 1;
    private static final int OPENFLOW_BASIC_CLASS_CODE = 32768;
    private static final int EXPERIMENTER_CLASS_CODE = 65535;
    private static final byte MATCH_TYPE_AND_LENGTH_SIZE = 4;
    private static final byte MATCH_ENTRY_HEADER_LENGTH = 4;

    public static void encodeMatch(Match match, ByteBuf out) {
        if (match == null) {
            LOGGER.debug("Match is null");
            return;
        }
        MatchSerializer.encodeType(match, out);
        int length = MatchSerializer.computeMatchLengthInternal(match);
        out.writeShort(length);
        MatchSerializer.encodeMatchEntries(match.getMatchEntries(), out);
        int paddingRemainder = length % 8;
        if (paddingRemainder != 0) {
            ByteBufUtils.padBuffer(8 - paddingRemainder, out);
        }
    }

    private static void encodeType(Match match, ByteBuf out) {
        if (match.getType().isAssignableFrom(StandardMatchType.class)) {
            out.writeShort(0);
        } else if (match.getType().isAssignableFrom(OxmMatchType.class)) {
            out.writeShort(1);
        }
    }

    public static void encodeMatchEntries(List<MatchEntries> matchEntries, ByteBuf out) {
        if (matchEntries == null) {
            LOGGER.debug("Match entries are null");
            return;
        }
        for (MatchEntries entry : matchEntries) {
            MatchSerializer.encodeClass(entry.getOxmClass(), out);
            MatchSerializer.encodeRest(entry, out);
        }
    }

    public static void encodeMatchIds(List<MatchEntries> matchEntries, ByteBuf out) {
        if (matchEntries == null) {
            LOGGER.debug("Match entries are null");
            return;
        }
        for (MatchEntries entry : matchEntries) {
            MatchSerializer.encodeClass(entry.getOxmClass(), out);
            MatchIdsSerializer.encodeIdsRest(entry, out);
        }
    }

    private static void encodeClass(Class<? extends Clazz> clazz, ByteBuf out) {
        if (clazz.isAssignableFrom(Nxm0Class.class)) {
            out.writeShort(0);
        } else if (clazz.isAssignableFrom(Nxm1Class.class)) {
            out.writeShort(1);
        } else if (clazz.isAssignableFrom(OpenflowBasicClass.class)) {
            out.writeShort(32768);
        } else if (clazz.isAssignableFrom(ExperimenterClass.class)) {
            out.writeShort(65535);
        }
    }

    private static void encodeRest(MatchEntries entry, ByteBuf out) {
        int fieldValue = 0;
        Class field = entry.getOxmMatchField();
        if (field.isAssignableFrom(InPort.class)) {
            fieldValue = 0;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 4);
            out.writeInt(((PortNumberMatchEntry)entry.getAugmentation(PortNumberMatchEntry.class)).getPortNumber().getValue().intValue());
        } else if (field.isAssignableFrom(InPhyPort.class)) {
            fieldValue = 1;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 4);
            out.writeInt(((PortNumberMatchEntry)entry.getAugmentation(PortNumberMatchEntry.class)).getPortNumber().getValue().intValue());
        } else if (field.isAssignableFrom(Metadata.class)) {
            fieldValue = 2;
            MatchSerializer.writeMetadataRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(EthDst.class)) {
            fieldValue = 3;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(EthSrc.class)) {
            fieldValue = 4;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(EthType.class)) {
            fieldValue = 5;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort((int)((EthTypeMatchEntry)entry.getAugmentation(EthTypeMatchEntry.class)).getEthType().getValue().shortValue());
        } else if (field.isAssignableFrom(VlanVid.class)) {
            fieldValue = 6;
            VlanVidMatchEntry vlanVid = (VlanVidMatchEntry)entry.getAugmentation(VlanVidMatchEntry.class);
            int vlanVidValue = vlanVid.getVlanVid();
            if (vlanVid.isCfiBit().booleanValue()) {
                int cfi = 4096;
                vlanVidValue |= cfi;
            }
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 2);
            out.writeShort(vlanVidValue);
            MatchSerializer.writeMask(entry, out, 2);
        } else if (field.isAssignableFrom(VlanPcp.class)) {
            fieldValue = 7;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((VlanPcpMatchEntry)entry.getAugmentation(VlanPcpMatchEntry.class)).getVlanPcp().byteValue());
        } else if (field.isAssignableFrom(IpDscp.class)) {
            fieldValue = 8;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((DscpMatchEntry)entry.getAugmentation(DscpMatchEntry.class)).getDscp().getValue().shortValue());
        } else if (field.isAssignableFrom(IpEcn.class)) {
            fieldValue = 9;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((EcnMatchEntry)entry.getAugmentation(EcnMatchEntry.class)).getEcn().shortValue());
        } else if (field.isAssignableFrom(IpProto.class)) {
            fieldValue = 10;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((ProtocolNumberMatchEntry)entry.getAugmentation(ProtocolNumberMatchEntry.class)).getProtocolNumber().shortValue());
        } else if (field.isAssignableFrom(Ipv4Src.class)) {
            fieldValue = 11;
            MatchSerializer.writeIpv4AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv4Dst.class)) {
            fieldValue = 12;
            MatchSerializer.writeIpv4AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(TcpSrc.class)) {
            fieldValue = 13;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(TcpDst.class)) {
            fieldValue = 14;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(UdpSrc.class)) {
            fieldValue = 15;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(UdpDst.class)) {
            fieldValue = 16;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(SctpSrc.class)) {
            fieldValue = 17;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(SctpDst.class)) {
            fieldValue = 18;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((PortMatchEntry)entry.getAugmentation(PortMatchEntry.class)).getPort().getValue().intValue());
        } else if (field.isAssignableFrom(Icmpv4Type.class)) {
            fieldValue = 19;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((Icmpv4TypeMatchEntry)entry.getAugmentation(Icmpv4TypeMatchEntry.class)).getIcmpv4Type().shortValue());
        } else if (field.isAssignableFrom(Icmpv4Code.class)) {
            fieldValue = 20;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((Icmpv4CodeMatchEntry)entry.getAugmentation(Icmpv4CodeMatchEntry.class)).getIcmpv4Code().shortValue());
        } else if (field.isAssignableFrom(ArpOp.class)) {
            fieldValue = 21;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 2);
            out.writeShort(((OpCodeMatchEntry)entry.getAugmentation(OpCodeMatchEntry.class)).getOpCode().intValue());
        } else if (field.isAssignableFrom(ArpSpa.class)) {
            fieldValue = 22;
            MatchSerializer.writeIpv4AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(ArpTpa.class)) {
            fieldValue = 23;
            MatchSerializer.writeIpv4AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(ArpSha.class)) {
            fieldValue = 24;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(ArpTha.class)) {
            fieldValue = 25;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6Src.class)) {
            fieldValue = 26;
            MatchSerializer.writeIpv6AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6Dst.class)) {
            fieldValue = 27;
            MatchSerializer.writeIpv6AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6Flabel.class)) {
            fieldValue = 28;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 4);
            out.writeInt(((Ipv6FlabelMatchEntry)entry.getAugmentation(Ipv6FlabelMatchEntry.class)).getIpv6Flabel().getValue().intValue());
            MatchSerializer.writeMask(entry, out, 4);
        } else if (field.isAssignableFrom(Icmpv6Type.class)) {
            fieldValue = 29;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((Icmpv6TypeMatchEntry)entry.getAugmentation(Icmpv6TypeMatchEntry.class)).getIcmpv6Type().shortValue());
        } else if (field.isAssignableFrom(Icmpv6Code.class)) {
            fieldValue = 30;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((Icmpv6CodeMatchEntry)entry.getAugmentation(Icmpv6CodeMatchEntry.class)).getIcmpv6Code().shortValue());
        } else if (field.isAssignableFrom(Ipv6NdTarget.class)) {
            fieldValue = 31;
            MatchSerializer.writeIpv6AddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6NdSll.class)) {
            fieldValue = 32;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6NdTll.class)) {
            fieldValue = 33;
            MatchSerializer.writeMacAddressRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(MplsLabel.class)) {
            fieldValue = 34;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 4);
            out.writeInt(((MplsLabelMatchEntry)entry.getAugmentation(MplsLabelMatchEntry.class)).getMplsLabel().intValue());
        } else if (field.isAssignableFrom(MplsTc.class)) {
            fieldValue = 35;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeByte((int)((TcMatchEntry)entry.getAugmentation(TcMatchEntry.class)).getTc().shortValue());
        } else if (field.isAssignableFrom(MplsBos.class)) {
            fieldValue = 36;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, false, 1);
            out.writeBoolean(((BosMatchEntry)entry.getAugmentation(BosMatchEntry.class)).isBos().booleanValue());
        } else if (field.isAssignableFrom(PbbIsid.class)) {
            fieldValue = 37;
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 3);
            out.writeMedium(((IsidMatchEntry)entry.getAugmentation(IsidMatchEntry.class)).getIsid().intValue());
            MatchSerializer.writeMask(entry, out, 3);
        } else if (field.isAssignableFrom(TunnelId.class)) {
            fieldValue = 38;
            MatchSerializer.writeMetadataRelatedEntry(entry, out, fieldValue);
        } else if (field.isAssignableFrom(Ipv6Exthdr.class)) {
            fieldValue = 39;
            Ipv6ExthdrFlags pseudoField = ((PseudoFieldMatchEntry)entry.getAugmentation(PseudoFieldMatchEntry.class)).getPseudoField();
            HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
            map.put(0, pseudoField.isNonext());
            map.put(1, pseudoField.isEsp());
            map.put(2, pseudoField.isAuth());
            map.put(3, pseudoField.isDest());
            map.put(4, pseudoField.isFrag());
            map.put(5, pseudoField.isRouter());
            map.put(6, pseudoField.isHop());
            map.put(7, pseudoField.isUnrep());
            map.put(8, pseudoField.isUnseq());
            int bitmap = ByteBufUtils.fillBitMaskFromMap(map);
            MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 2);
            out.writeShort(bitmap);
            MatchSerializer.writeMask(entry, out, 2);
        }
    }

    private static void writeMask(MatchEntries entry, ByteBuf out, int length) {
        if (entry.isHasMask().booleanValue()) {
            byte[] mask = ((MaskMatchEntry)entry.getAugmentation(MaskMatchEntry.class)).getMask();
            if (mask != null && mask.length != length) {
                throw new IllegalArgumentException("incorrect length of mask: " + mask.length + ", expected: " + length);
            }
            out.writeBytes(mask);
        }
    }

    protected static void writeOxmFieldAndLength(ByteBuf out, int fieldValue, boolean hasMask, int lengthArg) {
        int fieldAndMask = fieldValue << 1;
        int length = lengthArg;
        if (hasMask) {
            fieldAndMask |= 1;
            length *= 2;
        }
        out.writeByte(fieldAndMask);
        out.writeByte(length);
    }

    private static void writeMetadataRelatedEntry(MatchEntries entry, ByteBuf out, int value) {
        int fieldValue = value;
        MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 8);
        out.writeBytes(((MetadataMatchEntry)entry.getAugmentation(MetadataMatchEntry.class)).getMetadata());
        MatchSerializer.writeMask(entry, out, 8);
    }

    private static void writeMacAddressRelatedEntry(MatchEntries entry, ByteBuf out, int value) {
        int fieldValue = value;
        MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 6);
        String macAddress = ((MacAddressMatchEntry)entry.getAugmentation(MacAddressMatchEntry.class)).getMacAddress().getValue();
        out.writeBytes(ByteBufUtils.macAddressToBytes(macAddress));
        MatchSerializer.writeMask(entry, out, 6);
    }

    private static void writeIpv4AddressRelatedEntry(MatchEntries entry, ByteBuf out, int value) {
        int fieldValue = value;
        MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 4);
        MatchSerializer.writeIpv4Address(entry, out);
        MatchSerializer.writeMask(entry, out, 4);
    }

    private static void writeIpv4Address(MatchEntries entry, ByteBuf out) {
        String[] addressGroups = ((Ipv4AddressMatchEntry)entry.getAugmentation(Ipv4AddressMatchEntry.class)).getIpv4Address().getValue().split("\\.");
        for (int i = 0; i < addressGroups.length; ++i) {
            out.writeByte(Integer.parseInt(addressGroups[i]));
        }
    }

    private static void writeIpv6AddressRelatedEntry(MatchEntries entry, ByteBuf out, int value) {
        Object[] address;
        int fieldValue = value;
        String textAddress = ((Ipv6AddressMatchEntry)entry.getAugmentation(Ipv6AddressMatchEntry.class)).getIpv6Address().getValue();
        if (textAddress.equals("::")) {
            address = new String[8];
            Arrays.fill(address, "0");
        } else {
            address = MatchSerializer.parseIpv6Address(textAddress.split(":"));
        }
        MatchSerializer.writeOxmFieldAndLength(out, fieldValue, entry.isHasMask(), 16);
        for (int i = 0; i < address.length; ++i) {
            out.writeShort(Integer.parseInt((String)address[i], 16));
        }
        MatchSerializer.writeMask(entry, out, 16);
    }

    private static String[] parseIpv6Address(String[] addressGroups) {
        int countEmpty = 0;
        for (int i = 0; i < addressGroups.length; ++i) {
            if (!addressGroups[i].equals("")) continue;
            ++countEmpty;
        }
        Object[] ready = new String[8];
        switch (countEmpty) {
            case 0: {
                ready = addressGroups;
                break;
            }
            case 1: {
                int zerosToBePushed = 8 - addressGroups.length + 1;
                int index = 0;
                for (int i = 0; i < addressGroups.length; ++i) {
                    if (addressGroups[i].equals("")) {
                        for (int j = 0; j < zerosToBePushed; ++j) {
                            ready[index] = "0";
                            ++index;
                        }
                        continue;
                    }
                    ready[index] = addressGroups[i];
                    ++index;
                }
                break;
            }
            case 2: {
                Arrays.fill(ready, "0");
                ready[ready.length - 1] = addressGroups[addressGroups.length - 1];
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect ipv6 address");
            }
        }
        return ready;
    }

    public static int computeMatchLengthInternal(Match match) {
        int length = 0;
        if (match != null) {
            length += 4 + MatchSerializer.computeMatchEntriesLength(match.getMatchEntries());
        }
        return length;
    }

    public static int computeMatchLength(Match match) {
        int length = MatchSerializer.computeMatchLengthInternal(match);
        int paddingRemainder = length % 8;
        if (paddingRemainder != 0) {
            length += 8 - paddingRemainder;
        }
        return length;
    }

    public static int computeMatchEntriesLength(List<MatchEntries> matchEntries) {
        int length = 0;
        if (matchEntries != null) {
            for (MatchEntries entry : matchEntries) {
                length += 4;
                Class field = entry.getOxmMatchField();
                if (field.isAssignableFrom(InPort.class)) {
                    length += 4;
                    continue;
                }
                if (field.isAssignableFrom(InPhyPort.class)) {
                    length += 4;
                    continue;
                }
                if (field.isAssignableFrom(Metadata.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 8);
                    continue;
                }
                if (field.isAssignableFrom(EthDst.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(EthSrc.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(EthType.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(VlanVid.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 2);
                    continue;
                }
                if (field.isAssignableFrom(VlanPcp.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(IpDscp.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(IpEcn.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(IpProto.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(Ipv4Src.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 4);
                    continue;
                }
                if (field.isAssignableFrom(Ipv4Dst.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 4);
                    continue;
                }
                if (field.isAssignableFrom(TcpSrc.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(TcpDst.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(UdpSrc.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(UdpDst.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(SctpSrc.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(SctpDst.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(Icmpv4Type.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(Icmpv4Code.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(ArpOp.class)) {
                    length += 2;
                    continue;
                }
                if (field.isAssignableFrom(ArpSpa.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 4);
                    continue;
                }
                if (field.isAssignableFrom(ArpTpa.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 4);
                    continue;
                }
                if (field.isAssignableFrom(ArpSha.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(ArpTha.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(Ipv6Src.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 16);
                    continue;
                }
                if (field.isAssignableFrom(Ipv6Dst.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 16);
                    continue;
                }
                if (field.isAssignableFrom(Ipv6Flabel.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 4);
                    continue;
                }
                if (field.isAssignableFrom(Icmpv6Type.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(Icmpv6Code.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(Ipv6NdTarget.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 16);
                    continue;
                }
                if (field.isAssignableFrom(Ipv6NdSll.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(Ipv6NdTll.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 6);
                    continue;
                }
                if (field.isAssignableFrom(MplsLabel.class)) {
                    length += 4;
                    continue;
                }
                if (field.isAssignableFrom(MplsTc.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(MplsBos.class)) {
                    ++length;
                    continue;
                }
                if (field.isAssignableFrom(PbbIsid.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 3);
                    continue;
                }
                if (field.isAssignableFrom(TunnelId.class)) {
                    length += MatchSerializer.computePossibleMaskEntryLength(entry, 8);
                    continue;
                }
                if (!field.isAssignableFrom(Ipv6Exthdr.class)) continue;
                length += MatchSerializer.computePossibleMaskEntryLength(entry, 2);
            }
        }
        return length;
    }

    private static int computePossibleMaskEntryLength(MatchEntries entry, int length) {
        int entryLength = length;
        if (entry.isHasMask().booleanValue()) {
            entryLength *= 2;
        }
        return entryLength;
    }
}

