/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import com.google.common.base.Joiner;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.MatchIdsDeserializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev100924.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.BosMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.DscpMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EcnMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthTypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4CodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv4TypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6CodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Icmpv6TypeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv4AddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6AddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.Ipv6FlabelMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.IsidMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MacAddressMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaskMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsLabelMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OpCodeMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortNumberMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ProtocolNumberMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PseudoFieldMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TcMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanPcpMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.VlanVidMatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Nxm0Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.Nxm1Class;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntries;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev130731.oxm.fields.MatchEntriesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.match.grouping.MatchBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public abstract class MatchDeserializer {
    public static Match createMatch(ByteBuf in) {
        if (in.readableBytes() > 0) {
            MatchBuilder builder = new MatchBuilder();
            int type = in.readUnsignedShort();
            int length = in.readUnsignedShort();
            switch (type) {
                case 0: {
                    builder.setType(StandardMatchType.class);
                    break;
                }
                case 1: {
                    builder.setType(OxmMatchType.class);
                    break;
                }
            }
            builder.setMatchEntries(MatchDeserializer.createMatchEntries(in, length - 4));
            int paddingRemainder = length % 8;
            if (paddingRemainder != 0) {
                in.skipBytes(8 - paddingRemainder);
            }
            return builder.build();
        }
        return null;
    }

    public static List<MatchEntries> createMatchEntry(ByteBuf in, int matchLength) {
        return MatchDeserializer.createMatchEntriesInternal(in, matchLength, true);
    }

    public static List<MatchEntries> createMatchEntries(ByteBuf in, int matchLength) {
        return MatchDeserializer.createMatchEntriesInternal(in, matchLength, false);
    }

    private static List<MatchEntries> createMatchEntriesInternal(ByteBuf in, int matchLength, boolean oneEntry) {
        ArrayList<MatchEntries> matchEntriesList = new ArrayList<MatchEntries>();
        int currLength = 0;
        while (currLength < matchLength) {
            MatchEntriesBuilder matchEntriesBuilder = new MatchEntriesBuilder();
            switch (in.readUnsignedShort()) {
                case 0: {
                    matchEntriesBuilder.setOxmClass(Nxm0Class.class);
                    break;
                }
                case 1: {
                    matchEntriesBuilder.setOxmClass(Nxm1Class.class);
                    break;
                }
                case 32768: {
                    matchEntriesBuilder.setOxmClass(OpenflowBasicClass.class);
                    break;
                }
                case 65535: {
                    matchEntriesBuilder.setOxmClass(ExperimenterClass.class);
                    break;
                }
            }
            short fieldAndMask = in.readUnsignedByte();
            boolean hasMask = (fieldAndMask & 1) != 0;
            matchEntriesBuilder.setHasMask(Boolean.valueOf(hasMask));
            int matchField = fieldAndMask >> 1;
            short matchEntryLength = in.readUnsignedByte();
            currLength += 4 + matchEntryLength;
            switch (matchField) {
                case 0: {
                    matchEntriesBuilder.setOxmMatchField(InPort.class);
                    PortNumberMatchEntryBuilder port = new PortNumberMatchEntryBuilder();
                    port.setPortNumber(new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber(Long.valueOf(in.readUnsignedInt())));
                    matchEntriesBuilder.addAugmentation(PortNumberMatchEntry.class, (Augmentation)port.build());
                    break;
                }
                case 1: {
                    matchEntriesBuilder.setOxmMatchField(InPhyPort.class);
                    PortNumberMatchEntryBuilder phyPort = new PortNumberMatchEntryBuilder();
                    phyPort.setPortNumber(new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber(Long.valueOf(in.readUnsignedInt())));
                    matchEntriesBuilder.addAugmentation(PortNumberMatchEntry.class, (Augmentation)phyPort.build());
                    break;
                }
                case 2: {
                    matchEntriesBuilder.setOxmMatchField(Metadata.class);
                    MatchDeserializer.addMetadataAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 8);
                    break;
                }
                case 3: {
                    matchEntriesBuilder.setOxmMatchField(EthDst.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 6);
                    break;
                }
                case 4: {
                    matchEntriesBuilder.setOxmMatchField(EthSrc.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 6);
                    break;
                }
                case 5: {
                    matchEntriesBuilder.setOxmMatchField(EthType.class);
                    EthTypeMatchEntryBuilder ethertypeBuilder = new EthTypeMatchEntryBuilder();
                    ethertypeBuilder.setEthType(new EtherType(Integer.valueOf(in.readUnsignedShort())));
                    matchEntriesBuilder.addAugmentation(EthTypeMatchEntry.class, (Augmentation)ethertypeBuilder.build());
                    break;
                }
                case 6: {
                    matchEntriesBuilder.setOxmMatchField(VlanVid.class);
                    VlanVidMatchEntryBuilder vlanVidBuilder = new VlanVidMatchEntryBuilder();
                    int vidEntryValue = in.readUnsignedShort();
                    vlanVidBuilder.setCfiBit(Boolean.valueOf((vidEntryValue & 0x1000) != 0));
                    vlanVidBuilder.setVlanVid(Integer.valueOf(vidEntryValue & 0xFFF));
                    matchEntriesBuilder.addAugmentation(VlanVidMatchEntry.class, (Augmentation)vlanVidBuilder.build());
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 2);
                    break;
                }
                case 7: {
                    matchEntriesBuilder.setOxmMatchField(VlanPcp.class);
                    VlanPcpMatchEntryBuilder vlanPcpBuilder = new VlanPcpMatchEntryBuilder();
                    vlanPcpBuilder.setVlanPcp(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(VlanPcpMatchEntry.class, (Augmentation)vlanPcpBuilder.build());
                    break;
                }
                case 8: {
                    matchEntriesBuilder.setOxmMatchField(IpDscp.class);
                    DscpMatchEntryBuilder dscpBuilder = new DscpMatchEntryBuilder();
                    dscpBuilder.setDscp(new Dscp(Short.valueOf(in.readUnsignedByte())));
                    matchEntriesBuilder.addAugmentation(DscpMatchEntry.class, (Augmentation)dscpBuilder.build());
                    break;
                }
                case 9: {
                    matchEntriesBuilder.setOxmMatchField(IpEcn.class);
                    EcnMatchEntryBuilder ecnBuilder = new EcnMatchEntryBuilder();
                    ecnBuilder.setEcn(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(EcnMatchEntry.class, (Augmentation)ecnBuilder.build());
                    break;
                }
                case 10: {
                    matchEntriesBuilder.setOxmMatchField(IpProto.class);
                    ProtocolNumberMatchEntryBuilder protoNumberBuilder = new ProtocolNumberMatchEntryBuilder();
                    protoNumberBuilder.setProtocolNumber(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(ProtocolNumberMatchEntry.class, (Augmentation)protoNumberBuilder.build());
                    break;
                }
                case 11: {
                    matchEntriesBuilder.setOxmMatchField(Ipv4Src.class);
                    MatchDeserializer.addIpv4AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 4);
                    break;
                }
                case 12: {
                    matchEntriesBuilder.setOxmMatchField(Ipv4Dst.class);
                    MatchDeserializer.addIpv4AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 4);
                    break;
                }
                case 13: {
                    matchEntriesBuilder.setOxmMatchField(TcpSrc.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 14: {
                    matchEntriesBuilder.setOxmMatchField(TcpDst.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 15: {
                    matchEntriesBuilder.setOxmMatchField(UdpSrc.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 16: {
                    matchEntriesBuilder.setOxmMatchField(UdpDst.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 17: {
                    matchEntriesBuilder.setOxmMatchField(SctpSrc.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 18: {
                    matchEntriesBuilder.setOxmMatchField(SctpDst.class);
                    MatchDeserializer.addPortAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 19: {
                    matchEntriesBuilder.setOxmMatchField(Icmpv4Type.class);
                    Icmpv4TypeMatchEntryBuilder icmpv4TypeBuilder = new Icmpv4TypeMatchEntryBuilder();
                    icmpv4TypeBuilder.setIcmpv4Type(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(Icmpv4TypeMatchEntry.class, (Augmentation)icmpv4TypeBuilder.build());
                    break;
                }
                case 20: {
                    matchEntriesBuilder.setOxmMatchField(Icmpv4Code.class);
                    Icmpv4CodeMatchEntryBuilder icmpv4CodeBuilder = new Icmpv4CodeMatchEntryBuilder();
                    icmpv4CodeBuilder.setIcmpv4Code(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(Icmpv4CodeMatchEntry.class, (Augmentation)icmpv4CodeBuilder.build());
                    break;
                }
                case 21: {
                    matchEntriesBuilder.setOxmMatchField(ArpOp.class);
                    OpCodeMatchEntryBuilder opcodeBuilder = new OpCodeMatchEntryBuilder();
                    opcodeBuilder.setOpCode(Integer.valueOf(in.readUnsignedShort()));
                    matchEntriesBuilder.addAugmentation(OpCodeMatchEntry.class, (Augmentation)opcodeBuilder.build());
                    break;
                }
                case 22: {
                    matchEntriesBuilder.setOxmMatchField(ArpSpa.class);
                    MatchDeserializer.addIpv4AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 4);
                    break;
                }
                case 23: {
                    matchEntriesBuilder.setOxmMatchField(ArpTpa.class);
                    MatchDeserializer.addIpv4AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 4);
                    break;
                }
                case 24: {
                    matchEntriesBuilder.setOxmMatchField(ArpSha.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 6);
                    break;
                }
                case 25: {
                    matchEntriesBuilder.setOxmMatchField(ArpTha.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 6);
                    break;
                }
                case 26: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6Src.class);
                    MatchDeserializer.addIpv6AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 16);
                    break;
                }
                case 27: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6Dst.class);
                    MatchDeserializer.addIpv6AddressAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 16);
                    break;
                }
                case 28: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6Flabel.class);
                    Ipv6FlabelMatchEntryBuilder ipv6FlabelBuilder = new Ipv6FlabelMatchEntryBuilder();
                    ipv6FlabelBuilder.setIpv6Flabel(new Ipv6FlowLabel(Long.valueOf(in.readUnsignedInt())));
                    matchEntriesBuilder.addAugmentation(Ipv6FlabelMatchEntry.class, (Augmentation)ipv6FlabelBuilder.build());
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 4);
                    break;
                }
                case 29: {
                    matchEntriesBuilder.setOxmMatchField(Icmpv6Type.class);
                    Icmpv6TypeMatchEntryBuilder icmpv6TypeBuilder = new Icmpv6TypeMatchEntryBuilder();
                    icmpv6TypeBuilder.setIcmpv6Type(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(Icmpv6TypeMatchEntry.class, (Augmentation)icmpv6TypeBuilder.build());
                    break;
                }
                case 30: {
                    matchEntriesBuilder.setOxmMatchField(Icmpv6Code.class);
                    Icmpv6CodeMatchEntryBuilder icmpv6CodeBuilder = new Icmpv6CodeMatchEntryBuilder();
                    icmpv6CodeBuilder.setIcmpv6Code(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(Icmpv6CodeMatchEntry.class, (Augmentation)icmpv6CodeBuilder.build());
                    break;
                }
                case 31: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6NdTarget.class);
                    MatchDeserializer.addIpv6AddressAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 32: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6NdSll.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 33: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6NdTll.class);
                    MatchDeserializer.addMacAddressAugmentation(matchEntriesBuilder, in);
                    break;
                }
                case 34: {
                    matchEntriesBuilder.setOxmMatchField(MplsLabel.class);
                    MplsLabelMatchEntryBuilder mplsLabelBuilder = new MplsLabelMatchEntryBuilder();
                    mplsLabelBuilder.setMplsLabel(Long.valueOf(in.readUnsignedInt()));
                    matchEntriesBuilder.addAugmentation(MplsLabelMatchEntry.class, (Augmentation)mplsLabelBuilder.build());
                    break;
                }
                case 35: {
                    matchEntriesBuilder.setOxmMatchField(MplsTc.class);
                    TcMatchEntryBuilder tcBuilder = new TcMatchEntryBuilder();
                    tcBuilder.setTc(Short.valueOf(in.readUnsignedByte()));
                    matchEntriesBuilder.addAugmentation(TcMatchEntry.class, (Augmentation)tcBuilder.build());
                    break;
                }
                case 36: {
                    matchEntriesBuilder.setOxmMatchField(MplsBos.class);
                    BosMatchEntryBuilder bosBuilder = new BosMatchEntryBuilder();
                    if (in.readUnsignedByte() != 0) {
                        bosBuilder.setBos(Boolean.valueOf(true));
                    } else {
                        bosBuilder.setBos(Boolean.valueOf(false));
                    }
                    matchEntriesBuilder.addAugmentation(BosMatchEntry.class, (Augmentation)bosBuilder.build());
                    break;
                }
                case 37: {
                    matchEntriesBuilder.setOxmMatchField(PbbIsid.class);
                    IsidMatchEntryBuilder isidBuilder = new IsidMatchEntryBuilder();
                    Integer isid = in.readUnsignedMedium();
                    isidBuilder.setIsid(Long.valueOf(isid.longValue()));
                    matchEntriesBuilder.addAugmentation(IsidMatchEntry.class, (Augmentation)isidBuilder.build());
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 3);
                    break;
                }
                case 38: {
                    matchEntriesBuilder.setOxmMatchField(TunnelId.class);
                    MatchDeserializer.addMetadataAugmentation(matchEntriesBuilder, in);
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 8);
                    break;
                }
                case 39: {
                    matchEntriesBuilder.setOxmMatchField(Ipv6Exthdr.class);
                    PseudoFieldMatchEntryBuilder pseudoBuilder = new PseudoFieldMatchEntryBuilder();
                    int bitmap = in.readUnsignedShort();
                    Boolean NONEXT = (bitmap & 1) != 0;
                    Boolean ESP = (bitmap & 2) != 0;
                    Boolean AUTH = (bitmap & 4) != 0;
                    Boolean DEST = (bitmap & 8) != 0;
                    Boolean FRAG = (bitmap & 0x10) != 0;
                    Boolean ROUTER = (bitmap & 0x20) != 0;
                    Boolean HOP = (bitmap & 0x40) != 0;
                    Boolean UNREP = (bitmap & 0x80) != 0;
                    Boolean UNSEQ = (bitmap & 0x100) != 0;
                    pseudoBuilder.setPseudoField(new Ipv6ExthdrFlags(AUTH, DEST, ESP, FRAG, HOP, NONEXT, ROUTER, UNREP, UNSEQ));
                    matchEntriesBuilder.addAugmentation(PseudoFieldMatchEntry.class, (Augmentation)pseudoBuilder.build());
                    if (!hasMask) break;
                    MatchDeserializer.addMaskAugmentation(matchEntriesBuilder, in, 2);
                    break;
                }
            }
            matchEntriesList.add(matchEntriesBuilder.build());
            if (!oneEntry) continue;
            break;
        }
        if (matchLength - currLength > 0) {
            in.skipBytes(matchLength - currLength);
        }
        return matchEntriesList;
    }

    public static List<MatchEntries> createMatchIds(ByteBuf in, int matchLength) {
        return MatchIdsDeserializer.createOxmIds(in, matchLength);
    }

    private static void addMaskAugmentation(MatchEntriesBuilder builder, ByteBuf in, int matchEntryLength) {
        MaskMatchEntryBuilder maskBuilder = new MaskMatchEntryBuilder();
        byte[] mask = new byte[matchEntryLength];
        in.readBytes(mask);
        maskBuilder.setMask(mask);
        builder.addAugmentation(MaskMatchEntry.class, (Augmentation)maskBuilder.build());
    }

    private static void addIpv6AddressAugmentation(MatchEntriesBuilder builder, ByteBuf in) {
        Ipv6AddressMatchEntryBuilder ipv6AddressBuilder = new Ipv6AddressMatchEntryBuilder();
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            groups.add(String.format("%04X", in.readUnsignedShort()));
        }
        Joiner joiner = Joiner.on((String)":");
        ipv6AddressBuilder.setIpv6Address(new Ipv6Address(joiner.join(groups)));
        builder.addAugmentation(Ipv6AddressMatchEntry.class, (Augmentation)ipv6AddressBuilder.build());
    }

    private static void addMetadataAugmentation(MatchEntriesBuilder builder, ByteBuf in) {
        MetadataMatchEntryBuilder metadata = new MetadataMatchEntryBuilder();
        byte[] metadataBytes = new byte[8];
        in.readBytes(metadataBytes);
        metadata.setMetadata(metadataBytes);
        builder.addAugmentation(MetadataMatchEntry.class, (Augmentation)metadata.build());
    }

    private static void addIpv4AddressAugmentation(MatchEntriesBuilder builder, ByteBuf in) {
        Ipv4AddressMatchEntryBuilder ipv4AddressBuilder = new Ipv4AddressMatchEntryBuilder();
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            groups.add(Short.toString(in.readUnsignedByte()));
        }
        Joiner joiner = Joiner.on((String)".");
        ipv4AddressBuilder.setIpv4Address(new Ipv4Address(joiner.join(groups)));
        builder.addAugmentation(Ipv4AddressMatchEntry.class, (Augmentation)ipv4AddressBuilder.build());
    }

    private static void addMacAddressAugmentation(MatchEntriesBuilder builder, ByteBuf in) {
        MacAddressMatchEntryBuilder macAddress = new MacAddressMatchEntryBuilder();
        byte[] address = new byte[6];
        in.readBytes(address);
        macAddress.setMacAddress(new MacAddress(ByteBufUtils.macAddressToString(address)));
        builder.addAugmentation(MacAddressMatchEntry.class, (Augmentation)macAddress.build());
    }

    private static void addPortAugmentation(MatchEntriesBuilder builder, ByteBuf in) {
        PortMatchEntryBuilder portBuilder = new PortMatchEntryBuilder();
        portBuilder.setPort(new PortNumber(Integer.valueOf(in.readUnsignedShort())));
        builder.addAugmentation(PortMatchEntry.class, (Augmentation)portBuilder.build());
    }
}

