/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionsInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ApplyActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ClearActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.GotoTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;

public abstract class InstructionsSerializer {
    private static final byte GOTO_TABLE_TYPE = 1;
    private static final byte WRITE_METADATA_TYPE = 2;
    private static final byte WRITE_ACTIONS_TYPE = 3;
    private static final byte APPLY_ACTIONS_TYPE = 4;
    private static final byte CLEAR_ACTIONS_TYPE = 5;
    private static final byte METER_TYPE = 6;
    private static final byte EXPERIMENTER_TYPE = 7;
    private static final byte GOTO_TABLE_LENGTH = 8;
    private static final byte WRITE_METADATA_LENGTH = 24;
    private static final byte METER_LENGTH = 8;
    private static final byte EXPERIMENTER_LENGTH = 8;
    private static final byte ACTIONS_INSTRUCTION_LENGTH = 8;
    private static final byte PADDING_IN_GOTO_TABLE = 3;
    private static final byte PADDING_IN_WRITE_METADATA = 4;
    private static final byte PADDING_IN_CLEAR_ACTIONS = 4;
    private static final byte INSTRUCTION_IDS_LENGTH = 4;
    private static final byte PADDING_IN_ACTIONS_INSTRUCTION = 4;

    public static void encodeInstructions(List<Instructions> instructions, ByteBuf out) {
        if (instructions != null) {
            for (Instructions instruction : instructions) {
                Class type = instruction.getType();
                if (type.isAssignableFrom(GotoTable.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 1, 8);
                    out.writeByte((int)((TableIdInstruction)instruction.getAugmentation(TableIdInstruction.class)).getTableId().shortValue());
                    ByteBufUtils.padBuffer(3, out);
                    continue;
                }
                if (type.isAssignableFrom(WriteMetadata.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 2, 24);
                    ByteBufUtils.padBuffer(4, out);
                    MetadataInstruction metadata = (MetadataInstruction)instruction.getAugmentation(MetadataInstruction.class);
                    out.writeBytes(metadata.getMetadata());
                    out.writeBytes(metadata.getMetadataMask());
                    continue;
                }
                if (type.isAssignableFrom(WriteActions.class)) {
                    InstructionsSerializer.writeActionsInstruction(out, instruction, 3);
                    continue;
                }
                if (type.isAssignableFrom(ApplyActions.class)) {
                    InstructionsSerializer.writeActionsInstruction(out, instruction, 4);
                    continue;
                }
                if (type.isAssignableFrom(ClearActions.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 5, 8);
                    ByteBufUtils.padBuffer(4, out);
                    continue;
                }
                if (type.isAssignableFrom(Meter.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 6, 8);
                    out.writeInt(((MeterIdInstruction)instruction.getAugmentation(MeterIdInstruction.class)).getMeterId().intValue());
                    continue;
                }
                if (!type.isAssignableFrom(Experimenter.class)) continue;
                ExperimenterInstruction experimenter = (ExperimenterInstruction)instruction.getAugmentation(ExperimenterInstruction.class);
                byte[] data = experimenter.getData();
                InstructionsSerializer.writeTypeAndLength(out, 7, 8 + data.length);
                out.writeInt(experimenter.getExperimenter().intValue());
                out.writeBytes(data);
            }
        }
    }

    public static void encodeInstructionIds(List<Instructions> instructions, ByteBuf out) {
        if (instructions != null) {
            for (Instructions instruction : instructions) {
                Class type = instruction.getType();
                if (type.isAssignableFrom(GotoTable.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 1, 4);
                    continue;
                }
                if (type.isAssignableFrom(WriteMetadata.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 2, 4);
                    continue;
                }
                if (type.isAssignableFrom(WriteActions.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 3, 4);
                    continue;
                }
                if (type.isAssignableFrom(ApplyActions.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 4, 4);
                    continue;
                }
                if (type.isAssignableFrom(ClearActions.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 5, 4);
                    continue;
                }
                if (type.isAssignableFrom(Meter.class)) {
                    InstructionsSerializer.writeTypeAndLength(out, 6, 4);
                    continue;
                }
                if (!type.isAssignableFrom(Experimenter.class)) continue;
                ExperimenterInstruction experimenter = (ExperimenterInstruction)instruction.getAugmentation(ExperimenterInstruction.class);
                InstructionsSerializer.writeTypeAndLength(out, 7, 8);
                out.writeInt(experimenter.getExperimenter().intValue());
            }
        }
    }

    private static void writeTypeAndLength(ByteBuf out, int type, int length) {
        out.writeShort(type);
        out.writeShort(length);
    }

    private static void writeActionsInstruction(ByteBuf out, Instructions instruction, int type) {
        out.writeShort(type);
        if (instruction.getAugmentation(ActionsInstruction.class) != null) {
            List actions = ((ActionsInstruction)instruction.getAugmentation(ActionsInstruction.class)).getActionsList();
            out.writeShort(8 + ActionsSerializer.computeLengthOfActions(actions));
            ByteBufUtils.padBuffer(4, out);
            ActionsSerializer.encodeActions(actions, out);
        } else {
            out.writeShort(8);
            ByteBufUtils.padBuffer(4, out);
        }
    }

    public static int computeInstructionsLength(List<Instructions> instructions) {
        int length = 0;
        if (instructions != null) {
            for (Instructions instruction : instructions) {
                Class type = instruction.getType();
                if (type.isAssignableFrom(GotoTable.class)) {
                    length += 8;
                    continue;
                }
                if (type.isAssignableFrom(WriteMetadata.class)) {
                    length += 24;
                    continue;
                }
                if (type.isAssignableFrom(WriteActions.class)) {
                    length += 8;
                    if (instruction.getAugmentation(ActionsInstruction.class) == null) continue;
                    length += ActionsSerializer.computeLengthOfActions(((ActionsInstruction)instruction.getAugmentation(ActionsInstruction.class)).getActionsList());
                    continue;
                }
                if (type.isAssignableFrom(ApplyActions.class)) {
                    length += 8;
                    if (instruction.getAugmentation(ActionsInstruction.class) == null) continue;
                    length += ActionsSerializer.computeLengthOfActions(((ActionsInstruction)instruction.getAugmentation(ActionsInstruction.class)).getActionsList());
                    continue;
                }
                if (type.isAssignableFrom(ClearActions.class)) {
                    length += 8;
                    continue;
                }
                if (type.isAssignableFrom(Meter.class)) {
                    length += 8;
                    continue;
                }
                if (!type.isAssignableFrom(Experimenter.class)) continue;
                ExperimenterInstruction experimenter = (ExperimenterInstruction)instruction.getAugmentation(ExperimenterInstruction.class);
                byte[] data = experimenter.getData();
                length += 8 + data.length;
            }
        }
        return length;
    }
}

