/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionsInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionsInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MetadataInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MeterIdInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.TableIdInstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ApplyActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.ClearActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.GotoTable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Meter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteActions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.WriteMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.InstructionsBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public abstract class InstructionsDeserializer {
    private static final byte WRITE_APPLY_CLEAR_ACTION_LENGTH = 8;
    private static final byte EXPERIMENTER_HEADER_LENGTH = 8;
    private static final byte GOTO_TABLE_PADDING = 3;
    private static final byte WRITE_METADATA_PADDING = 4;
    private static final byte ACTIONS_RELATED_INSTRUCTION_PADDING = 4;

    public static List<Instructions> createInstructions(ByteBuf input, int length) {
        ArrayList<Instructions> instructions = new ArrayList<Instructions>();
        if (input.readableBytes() != 0) {
            int lengthOfInstructions = length;
            while (lengthOfInstructions > 0) {
                InstructionsBuilder builder = new InstructionsBuilder();
                int type = input.readUnsignedShort();
                int instructionLength = input.readUnsignedShort();
                lengthOfInstructions -= instructionLength;
                switch (type) {
                    case 1: {
                        InstructionsDeserializer.createGotoTableInstruction(builder, input);
                        break;
                    }
                    case 2: {
                        InstructionsDeserializer.createMetadataInstruction(builder, input);
                        break;
                    }
                    case 3: {
                        builder.setType(WriteActions.class);
                        InstructionsDeserializer.createActionRelatedInstruction(input, builder, instructionLength - 8);
                        break;
                    }
                    case 4: {
                        builder.setType(ApplyActions.class);
                        InstructionsDeserializer.createActionRelatedInstruction(input, builder, instructionLength - 8);
                        break;
                    }
                    case 5: {
                        builder.setType(ClearActions.class);
                        InstructionsDeserializer.createActionRelatedInstruction(input, builder, instructionLength - 8);
                        break;
                    }
                    case 6: {
                        builder.setType(Meter.class);
                        MeterIdInstructionBuilder meterBuilder = new MeterIdInstructionBuilder();
                        meterBuilder.setMeterId(Long.valueOf(input.readUnsignedInt()));
                        builder.addAugmentation(MeterIdInstruction.class, (Augmentation)meterBuilder.build());
                        break;
                    }
                    case 65535: {
                        builder.setType(Experimenter.class);
                        ExperimenterInstructionBuilder expBuilder = new ExperimenterInstructionBuilder();
                        expBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                        int dataLength = instructionLength - 8;
                        if (dataLength > 0) {
                            byte[] data = new byte[dataLength];
                            input.readBytes(data);
                            expBuilder.setData(data);
                        }
                        builder.addAugmentation(ExperimenterInstruction.class, (Augmentation)expBuilder.build());
                        break;
                    }
                }
                instructions.add(builder.build());
            }
        }
        return instructions;
    }

    public static List<Instructions> createInstructionIds(ByteBuf input, int length) {
        ArrayList<Instructions> instructions = new ArrayList<Instructions>();
        if (input.readableBytes() != 0) {
            int lengthOfInstructions = length;
            while (lengthOfInstructions > 0) {
                InstructionsBuilder builder = new InstructionsBuilder();
                int type = input.readUnsignedShort();
                int instructionLength = input.readUnsignedShort();
                lengthOfInstructions -= instructionLength;
                switch (type) {
                    case 1: {
                        builder.setType(GotoTable.class);
                        break;
                    }
                    case 2: {
                        builder.setType(WriteMetadata.class);
                        break;
                    }
                    case 3: {
                        builder.setType(WriteActions.class);
                        break;
                    }
                    case 4: {
                        builder.setType(ApplyActions.class);
                        break;
                    }
                    case 5: {
                        builder.setType(ClearActions.class);
                        break;
                    }
                    case 6: {
                        builder.setType(Meter.class);
                        break;
                    }
                    case 65535: {
                        builder.setType(Experimenter.class);
                        ExperimenterInstructionBuilder expBuilder = new ExperimenterInstructionBuilder();
                        expBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                        builder.addAugmentation(ExperimenterInstruction.class, (Augmentation)expBuilder.build());
                        break;
                    }
                }
                instructions.add(builder.build());
            }
        }
        return instructions;
    }

    private static void createGotoTableInstruction(InstructionsBuilder builder, ByteBuf input) {
        builder.setType(GotoTable.class);
        TableIdInstructionBuilder tableBuilder = new TableIdInstructionBuilder();
        tableBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
        builder.addAugmentation(TableIdInstruction.class, (Augmentation)tableBuilder.build());
        input.skipBytes(3);
    }

    private static void createMetadataInstruction(InstructionsBuilder builder, ByteBuf input) {
        input.skipBytes(4);
        builder.setType(WriteMetadata.class);
        MetadataInstructionBuilder metadataBuilder = new MetadataInstructionBuilder();
        byte[] metadata = new byte[8];
        input.readBytes(metadata);
        metadataBuilder.setMetadata(metadata);
        byte[] metadata_mask = new byte[8];
        input.readBytes(metadata_mask);
        metadataBuilder.setMetadataMask(metadata_mask);
        builder.addAugmentation(MetadataInstruction.class, (Augmentation)metadataBuilder.build());
    }

    private static void createActionRelatedInstruction(ByteBuf input, InstructionsBuilder builder, int actionsLength) {
        input.skipBytes(4);
        ActionsInstructionBuilder actionsBuilder = new ActionsInstructionBuilder();
        actionsBuilder.setActionsList(ActionsDeserializer.createActionsList(input, actionsLength));
        builder.addAugmentation(ActionsInstruction.class, (Augmentation)actionsBuilder.build());
    }
}

