/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import com.google.common.base.Joiner;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.OfHeader;

public abstract class ByteBufUtils {
    public static String byteBufToHexString(ByteBuf bb) {
        StringBuffer sb = new StringBuffer();
        for (int i = bb.readerIndex(); i < bb.readerIndex() + bb.readableBytes(); ++i) {
            sb.append(String.format(" %02x", bb.getUnsignedByte(i)));
        }
        return sb.toString().trim();
    }

    public static byte[] hexStringToBytes(String hexSrc) {
        return ByteBufUtils.hexStringToBytes(hexSrc, true);
    }

    public static byte[] hexStringToBytes(String hexSrc, boolean withSpaces) {
        String splitPattern = "\\s+";
        if (!withSpaces) {
            splitPattern = "(?<=\\G.{2})";
        }
        String[] byteChips = hexSrc.split(splitPattern);
        byte[] result = new byte[byteChips.length];
        for (int i = 0; i < byteChips.length; ++i) {
            result[i] = (byte)Short.parseShort(byteChips[i], 16);
        }
        return result;
    }

    public static ByteBuf hexStringToByteBuf(String hexSrc) {
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ByteBufUtils.hexStringToByteBuf(hexSrc, out);
        return out;
    }

    public static void hexStringToByteBuf(String hexSrc, ByteBuf out) {
        out.writeBytes(ByteBufUtils.hexStringToBytes(hexSrc));
    }

    public static void padBuffer(int length, ByteBuf out) {
        for (int i = 0; i < length; ++i) {
            out.writeByte(0);
        }
    }

    public static <E extends OfHeader> void writeOFHeader(OFSerializer<E> factory, E message, ByteBuf out) {
        out.writeByte((int)message.getVersion().shortValue());
        out.writeByte((int)factory.getMessageType());
        out.writeShort(factory.computeLength(message));
        out.writeInt(message.getXid().intValue());
    }

    public static int fillBitMaskFromMap(Map<Integer, Boolean> booleanMap) {
        int bitmask = 0;
        for (Map.Entry<Integer, Boolean> iterator : booleanMap.entrySet()) {
            if (iterator.getValue() == null || !iterator.getValue().booleanValue()) continue;
            bitmask |= 1 << iterator.getKey();
        }
        return bitmask;
    }

    public static int[] fillBitMaskFromList(List<Boolean> booleanList) {
        int index = 0;
        int arrayIndex = 0;
        int[] bitmask = booleanList.size() % 32 != 0 ? new int[booleanList.size() / 32 + 1] : new int[booleanList.size() / 32];
        for (Boolean currElement : booleanList) {
            if (currElement != null && currElement.booleanValue()) {
                int n = arrayIndex;
                bitmask[n] = bitmask[n] | 1 << index;
            }
            arrayIndex = ++index / 32;
        }
        return bitmask;
    }

    public static String bytesToHexString(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            sb.append(String.format(" %02x", array[i]));
        }
        return sb.toString().trim();
    }

    public static byte[] macAddressToBytes(String macAddress) {
        String[] sequences = macAddress.split(":");
        byte[] result = new byte[6];
        for (int i = 0; i < sequences.length; ++i) {
            result[i] = (byte)Short.parseShort(sequences[i], 16);
        }
        return result;
    }

    public static String macAddressToString(byte[] address) {
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < 6; ++i) {
            groups.add(String.format("%02X", address[i]));
        }
        Joiner joiner = Joiner.on((String)":");
        return joiner.join(groups);
    }

    public static String decodeNullTerminatedString(ByteBuf rawMessage, int length) {
        byte[] name = new byte[length];
        rawMessage.readBytes(name);
        return new String(name).trim();
    }
}

