/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.MatchSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthertypeAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.Action;

public abstract class ActionsSerializer {
    private static final byte OUTPUT_CODE = 0;
    private static final byte COPY_TTL_OUT_CODE = 11;
    private static final byte COPY_TTL_IN_CODE = 12;
    private static final byte SET_MPLS_TTL_CODE = 15;
    private static final byte DEC_MPLS_TTL_CODE = 16;
    private static final byte PUSH_VLAN_CODE = 17;
    private static final byte POP_VLAN_CODE = 18;
    private static final byte PUSH_MPLS_CODE = 19;
    private static final byte POP_MPLS_CODE = 20;
    private static final byte SET_QUEUE_CODE = 21;
    private static final byte GROUP_CODE = 22;
    private static final byte SET_NW_TTL_CODE = 23;
    private static final byte DEC_NW_TTL_CODE = 24;
    private static final int SET_FIELD_CODE = 25;
    private static final byte PUSH_PBB_CODE = 26;
    private static final byte POP_PBB_CODE = 27;
    private static final int EXPERIMENTER_CODE = 65535;
    private static final byte OUTPUT_LENGTH = 16;
    private static final byte SET_MPLS_TTL_LENGTH = 8;
    private static final byte SET_QUEUE_LENGTH = 8;
    private static final byte GROUP_LENGTH = 8;
    private static final byte SET_NW_TTL_LENGTH = 8;
    private static final byte EXPERIMENTER_LENGTH = 8;
    private static final byte ACTION_HEADER_LENGTH = 8;
    private static final byte LENGTH_OF_ETHERTYPE_ACTION = 8;
    private static final byte LENGTH_OF_OTHER_ACTIONS = 8;
    private static final byte SET_FIELD_HEADER_LENGTH = 4;
    private static final byte OUTPUT_PADDING = 6;
    private static final byte SET_MPLS_TTL_PADDING = 3;
    private static final byte SET_NW_TTL_PADDING = 3;
    private static final byte PADDING_IN_ACTION_HEADER = 4;
    private static final byte ETHERTYPE_ACTION_PADDING = 2;
    private static final byte ACTION_IDS_LENGTH = 4;

    public static void encodeActions(List<ActionsList> actionsList, ByteBuf outBuffer) {
        if (actionsList == null) {
            return;
        }
        for (ActionsList list : actionsList) {
            Action action = list.getAction();
            if (action.getType().isAssignableFrom(Output.class)) {
                ActionsSerializer.encodeOutputAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(CopyTtlOut.class)) {
                ActionsSerializer.encodeCopyTtlOutAction(outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(CopyTtlIn.class)) {
                ActionsSerializer.encodeCopyTtlInAction(outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(SetMplsTtl.class)) {
                ActionsSerializer.encodeSetMplsTtltAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(DecMplsTtl.class)) {
                ActionsSerializer.encodeDecMplsTtlAction(outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PushVlan.class)) {
                ActionsSerializer.encodePushVlanAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PopVlan.class)) {
                ActionsSerializer.encodePopVlanAction(outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PushMpls.class)) {
                ActionsSerializer.encodePushMplsAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PopMpls.class)) {
                ActionsSerializer.encodePopMplsAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(SetQueue.class)) {
                ActionsSerializer.encodeSetQueueAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(Group.class)) {
                ActionsSerializer.encodeGroupAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(SetNwTtl.class)) {
                ActionsSerializer.encodeSetNwTtlAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(DecNwTtl.class)) {
                ActionsSerializer.encodeDecNwTtlAction(outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(SetField.class)) {
                ActionsSerializer.encodeSetFieldAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PushPbb.class)) {
                ActionsSerializer.encodePushPbbAction(action, outBuffer);
                continue;
            }
            if (action.getType().isAssignableFrom(PopPbb.class)) {
                ActionsSerializer.encodePopPbbAction(outBuffer);
                continue;
            }
            if (!action.getType().isAssignableFrom(Experimenter.class)) continue;
            ActionsSerializer.encodeExperimenterAction(action, outBuffer);
        }
    }

    public static void encodeActionIds(List<ActionsList> actionsList, ByteBuf outBuffer) {
        if (actionsList == null) {
            return;
        }
        for (ActionsList list : actionsList) {
            Action action = list.getAction();
            if (action.getType().isAssignableFrom(Output.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 0, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(CopyTtlOut.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 11, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(CopyTtlIn.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 12, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(SetMplsTtl.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 15, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(DecMplsTtl.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 16, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PushVlan.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 17, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PopVlan.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 18, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PushMpls.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 19, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PopMpls.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 20, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(SetQueue.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 21, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(Group.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 22, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(SetNwTtl.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 23, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(DecNwTtl.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 24, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(SetField.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 25, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PushPbb.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 26, 4);
                continue;
            }
            if (action.getType().isAssignableFrom(PopPbb.class)) {
                ActionsSerializer.writeTypeAndLength(outBuffer, 27, 4);
                continue;
            }
            if (!action.getType().isAssignableFrom(Experimenter.class)) continue;
            ActionsSerializer.writeTypeAndLength(outBuffer, 65535, 8);
            ExperimenterAction experimenter = (ExperimenterAction)action.getAugmentation(ExperimenterAction.class);
            outBuffer.writeInt(experimenter.getExperimenter().intValue());
        }
    }

    private static void writeTypeAndLength(ByteBuf out, int type, int length) {
        out.writeShort(type);
        out.writeShort(length);
    }

    private static void encodeOutputAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(0);
        outBuffer.writeShort(16);
        PortAction port = (PortAction)action.getAugmentation(PortAction.class);
        outBuffer.writeInt(port.getPort().getValue().intValue());
        MaxLengthAction maxlength = (MaxLengthAction)action.getAugmentation(MaxLengthAction.class);
        outBuffer.writeShort(maxlength.getMaxLength().intValue());
        ByteBufUtils.padBuffer(6, outBuffer);
    }

    private static void encodeCopyTtlOutAction(ByteBuf outBuffer) {
        outBuffer.writeShort(11);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodeCopyTtlInAction(ByteBuf outBuffer) {
        outBuffer.writeShort(12);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodeSetMplsTtltAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(15);
        outBuffer.writeShort(8);
        MplsTtlAction mplsTtl = (MplsTtlAction)action.getAugmentation(MplsTtlAction.class);
        outBuffer.writeByte((int)mplsTtl.getMplsTtl().shortValue());
        ByteBufUtils.padBuffer(3, outBuffer);
    }

    private static void encodeDecMplsTtlAction(ByteBuf outBuffer) {
        outBuffer.writeShort(16);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodePushVlanAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(17);
        ActionsSerializer.encodeCommonEthertype(action, outBuffer);
    }

    private static void encodePopVlanAction(ByteBuf outBuffer) {
        outBuffer.writeShort(18);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodePushMplsAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(19);
        ActionsSerializer.encodeCommonEthertype(action, outBuffer);
    }

    private static void encodePopMplsAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(20);
        ActionsSerializer.encodeCommonEthertype(action, outBuffer);
    }

    private static void encodeSetQueueAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(21);
        outBuffer.writeShort(8);
        QueueIdAction queueId = (QueueIdAction)action.getAugmentation(QueueIdAction.class);
        outBuffer.writeInt(queueId.getQueueId().intValue());
    }

    private static void encodeGroupAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(22);
        outBuffer.writeShort(8);
        GroupIdAction groupId = (GroupIdAction)action.getAugmentation(GroupIdAction.class);
        outBuffer.writeInt(groupId.getGroupId().intValue());
    }

    private static void encodeSetNwTtlAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(23);
        outBuffer.writeShort(8);
        NwTtlAction nwTtl = (NwTtlAction)action.getAugmentation(NwTtlAction.class);
        outBuffer.writeByte((int)nwTtl.getNwTtl().shortValue());
        ByteBufUtils.padBuffer(3, outBuffer);
    }

    private static void encodeDecNwTtlAction(ByteBuf outBuffer) {
        outBuffer.writeShort(24);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodeSetFieldAction(Action action, ByteBuf outBuffer) {
        OxmFieldsAction oxmField = (OxmFieldsAction)action.getAugmentation(OxmFieldsAction.class);
        int length = MatchSerializer.computeMatchEntriesLength(oxmField.getMatchEntries()) + 4;
        outBuffer.writeShort(25);
        int paddingRemainder = length % 8;
        if (paddingRemainder != 0) {
            length += 8 - paddingRemainder;
        }
        outBuffer.writeShort(length);
        MatchSerializer.encodeMatchEntries(oxmField.getMatchEntries(), outBuffer);
        if (paddingRemainder != 0) {
            ByteBufUtils.padBuffer(8 - paddingRemainder, outBuffer);
        }
    }

    private static void encodePushPbbAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(26);
        ActionsSerializer.encodeCommonEthertype(action, outBuffer);
    }

    private static void encodePopPbbAction(ByteBuf outBuffer) {
        outBuffer.writeShort(27);
        ActionsSerializer.encodeRestOfActionHeader(outBuffer);
    }

    private static void encodeExperimenterAction(Action action, ByteBuf outBuffer) {
        outBuffer.writeShort(65535);
        outBuffer.writeShort(8);
        ExperimenterAction experimenter = (ExperimenterAction)action.getAugmentation(ExperimenterAction.class);
        outBuffer.writeInt(experimenter.getExperimenter().intValue());
    }

    private static void encodeRestOfActionHeader(ByteBuf outBuffer) {
        outBuffer.writeShort(8);
        ByteBufUtils.padBuffer(4, outBuffer);
    }

    private static void encodeCommonEthertype(Action action, ByteBuf outBuffer) {
        EthertypeAction ethertype = (EthertypeAction)action.getAugmentation(EthertypeAction.class);
        outBuffer.writeShort(8);
        outBuffer.writeShort(ethertype.getEthertype().getValue().intValue());
        ByteBufUtils.padBuffer(2, outBuffer);
    }

    public static int computeLengthOfActions(List<ActionsList> actionsList) {
        int lengthOfActions = 0;
        if (actionsList != null) {
            for (ActionsList list : actionsList) {
                Action action = list.getAction();
                if (action.getType().isAssignableFrom(Output.class)) {
                    lengthOfActions += 16;
                    continue;
                }
                if (action.getType().isAssignableFrom(SetField.class)) {
                    List entries = ((OxmFieldsAction)action.getAugmentation(OxmFieldsAction.class)).getMatchEntries();
                    int actionLength = 4 + MatchSerializer.computeMatchEntriesLength(entries);
                    lengthOfActions += actionLength;
                    int paddingRemainder = actionLength % 8;
                    if (paddingRemainder == 0) continue;
                    lengthOfActions += 8 - paddingRemainder;
                    continue;
                }
                lengthOfActions += 8;
            }
        }
        return lengthOfActions;
    }
}

