/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthertypeAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.EthertypeActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.GroupIdActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MaxLengthActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.MplsTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTtlAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmFieldsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.PortActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdAction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.QueueIdActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlIn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.CopyTtlOut;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.DecNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Group;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.Output;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PopVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushMpls;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushPbb;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.PushVlan;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetMplsTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetNwTtl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.SetQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.actions.list.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public abstract class ActionsDeserializer {
    private static final byte ACTION_HEADER_LENGTH = 4;
    private static final byte PADDING_IN_ACTIONS_HEADER = 4;
    private static final byte PADDING_IN_OUTPUT_ACTIONS_HEADER = 6;
    private static final byte PADDING_IN_SET_MPLS_TTL_ACTIONS_HEADER = 3;
    private static final byte PADDING_IN_PUSH_VLAN_ACTIONS_HEADER = 2;
    private static final byte PADDING_IN_NW_TTL_ACTIONS_HEADER = 3;

    public static List<ActionsList> createActionsList(ByteBuf input, int actionsLength) {
        int currentActionLength;
        ActionsListBuilder actionsListBuilder = new ActionsListBuilder();
        ArrayList<ActionsList> actionsList = new ArrayList<ActionsList>();
        block19: for (int length = 0; length < actionsLength; length += currentActionLength) {
            int type = input.readUnsignedShort();
            currentActionLength = input.readUnsignedShort();
            switch (type) {
                case 0: {
                    actionsList.add(ActionsDeserializer.createOutputAction(input, actionsListBuilder));
                    continue block19;
                }
                case 11: {
                    actionsList.add(ActionsDeserializer.createCopyTtlOutAction(input, actionsListBuilder));
                    continue block19;
                }
                case 12: {
                    actionsList.add(ActionsDeserializer.createCopyTtlInAction(input, actionsListBuilder));
                    continue block19;
                }
                case 15: {
                    actionsList.add(ActionsDeserializer.createSetMplsTtlAction(input, actionsListBuilder));
                    continue block19;
                }
                case 16: {
                    actionsList.add(ActionsDeserializer.createDecMplsTtlOutAction(input, actionsListBuilder));
                    continue block19;
                }
                case 17: {
                    actionsList.add(ActionsDeserializer.createPushVlanAction(input, actionsListBuilder));
                    continue block19;
                }
                case 18: {
                    actionsList.add(ActionsDeserializer.createPopVlanAction(input, actionsListBuilder));
                    continue block19;
                }
                case 19: {
                    actionsList.add(ActionsDeserializer.createPushMplsAction(input, actionsListBuilder));
                    continue block19;
                }
                case 20: {
                    actionsList.add(ActionsDeserializer.createPopMplsAction(input, actionsListBuilder));
                    continue block19;
                }
                case 21: {
                    actionsList.add(ActionsDeserializer.createSetQueueAction(input, actionsListBuilder));
                    continue block19;
                }
                case 22: {
                    actionsList.add(ActionsDeserializer.createGroupAction(input, actionsListBuilder));
                    continue block19;
                }
                case 23: {
                    actionsList.add(ActionsDeserializer.createSetNwTtlAction(input, actionsListBuilder));
                    continue block19;
                }
                case 24: {
                    actionsList.add(ActionsDeserializer.createDecNwTtlAction(input, actionsListBuilder));
                    continue block19;
                }
                case 25: {
                    actionsList.add(ActionsDeserializer.createSetFieldAction(input, actionsListBuilder, currentActionLength));
                    continue block19;
                }
                case 26: {
                    actionsList.add(ActionsDeserializer.createPushPbbAction(input, actionsListBuilder));
                    continue block19;
                }
                case 27: {
                    actionsList.add(ActionsDeserializer.createPopPbbAction(input, actionsListBuilder));
                    continue block19;
                }
                case 65535: {
                    actionsList.add(ActionsDeserializer.createExperimenterAction(input, actionsListBuilder));
                    continue block19;
                }
            }
        }
        return actionsList;
    }

    public static List<ActionsList> createActionIds(ByteBuf input, int actionsLength) {
        int currentActionLength;
        ArrayList<ActionsList> actionsList = new ArrayList<ActionsList>();
        for (int length = 0; length < actionsLength; length += currentActionLength) {
            int type = input.readUnsignedShort();
            currentActionLength = input.readUnsignedShort();
            ActionBuilder builder = new ActionBuilder();
            ActionsListBuilder listBuilder = new ActionsListBuilder();
            switch (type) {
                case 0: {
                    builder.setType(Output.class);
                    break;
                }
                case 11: {
                    builder.setType(CopyTtlOut.class);
                    break;
                }
                case 12: {
                    builder.setType(CopyTtlIn.class);
                    break;
                }
                case 15: {
                    builder.setType(SetMplsTtl.class);
                    break;
                }
                case 16: {
                    builder.setType(DecMplsTtl.class);
                    break;
                }
                case 17: {
                    builder.setType(PushVlan.class);
                    break;
                }
                case 18: {
                    builder.setType(PopVlan.class);
                    break;
                }
                case 19: {
                    builder.setType(PushMpls.class);
                    break;
                }
                case 20: {
                    builder.setType(PopMpls.class);
                    break;
                }
                case 21: {
                    builder.setType(SetQueue.class);
                    break;
                }
                case 22: {
                    builder.setType(Group.class);
                    break;
                }
                case 23: {
                    builder.setType(SetNwTtl.class);
                    break;
                }
                case 24: {
                    builder.setType(DecNwTtl.class);
                    break;
                }
                case 25: {
                    builder.setType(SetField.class);
                    break;
                }
                case 26: {
                    builder.setType(PushPbb.class);
                    break;
                }
                case 27: {
                    builder.setType(PopPbb.class);
                    break;
                }
                case 65535: {
                    builder.setType(Experimenter.class);
                    ExperimenterActionBuilder experimenter = new ExperimenterActionBuilder();
                    experimenter.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                    builder.addAugmentation(ExperimenterAction.class, (Augmentation)experimenter.build());
                    break;
                }
            }
            listBuilder.setAction(builder.build());
            actionsList.add(listBuilder.build());
        }
        return actionsList;
    }

    private static ActionsList createEmptyHeader(Class<? extends Action> action, ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(action);
        in.skipBytes(4);
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList createCopyTtlInAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(CopyTtlIn.class, in, actionsListBuilder);
    }

    private static ActionsList createCopyTtlOutAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(CopyTtlOut.class, in, actionsListBuilder);
    }

    private static ActionsList createDecMplsTtlOutAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(DecMplsTtl.class, in, actionsListBuilder);
    }

    private static ActionsList createPopVlanAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(PopVlan.class, in, actionsListBuilder);
    }

    private static ActionsList createDecNwTtlAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(DecNwTtl.class, in, actionsListBuilder);
    }

    private static ActionsList createPopPbbAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createEmptyHeader(PopPbb.class, in, actionsListBuilder);
    }

    private static ActionsList createOutputAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Output.class);
        PortActionBuilder port = new PortActionBuilder();
        port.setPort(new PortNumber(Long.valueOf(in.readUnsignedInt())));
        actionBuilder.addAugmentation(PortAction.class, (Augmentation)port.build());
        MaxLengthActionBuilder maxLen = new MaxLengthActionBuilder();
        maxLen.setMaxLength(Integer.valueOf(in.readUnsignedShort()));
        actionBuilder.addAugmentation(MaxLengthAction.class, (Augmentation)maxLen.build());
        actionsListBuilder.setAction(actionBuilder.build());
        in.skipBytes(6);
        return actionsListBuilder.build();
    }

    private static ActionsList createSetMplsTtlAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetMplsTtl.class);
        MplsTtlActionBuilder mplsTtl = new MplsTtlActionBuilder();
        mplsTtl.setMplsTtl(Short.valueOf(in.readUnsignedByte()));
        actionBuilder.addAugmentation(MplsTtlAction.class, (Augmentation)mplsTtl.build());
        actionsListBuilder.setAction(actionBuilder.build());
        in.skipBytes(3);
        return actionsListBuilder.build();
    }

    private static ActionsList createPushAction(Class<? extends Action> action, ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(action);
        EthertypeActionBuilder etherType = new EthertypeActionBuilder();
        etherType.setEthertype(new EtherType(Integer.valueOf(in.readUnsignedShort())));
        actionBuilder.addAugmentation(EthertypeAction.class, (Augmentation)etherType.build());
        actionsListBuilder.setAction(actionBuilder.build());
        in.skipBytes(2);
        return actionsListBuilder.build();
    }

    private static ActionsList createPushVlanAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createPushAction(PushVlan.class, in, actionsListBuilder);
    }

    private static ActionsList createPushMplsAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createPushAction(PushMpls.class, in, actionsListBuilder);
    }

    private static ActionsList createPopMplsAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createPushAction(PopMpls.class, in, actionsListBuilder);
    }

    private static ActionsList createPushPbbAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        return ActionsDeserializer.createPushAction(PushPbb.class, in, actionsListBuilder);
    }

    private static ActionsList createSetQueueAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetQueue.class);
        QueueIdActionBuilder queueId = new QueueIdActionBuilder();
        queueId.setQueueId(Long.valueOf(in.readUnsignedInt()));
        actionBuilder.addAugmentation(QueueIdAction.class, (Augmentation)queueId.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList createGroupAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Group.class);
        GroupIdActionBuilder group = new GroupIdActionBuilder();
        group.setGroupId(Long.valueOf(in.readUnsignedInt()));
        actionBuilder.addAugmentation(GroupIdAction.class, (Augmentation)group.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList createExperimenterAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(Experimenter.class);
        ExperimenterActionBuilder experimenter = new ExperimenterActionBuilder();
        experimenter.setExperimenter(Long.valueOf(in.readUnsignedInt()));
        actionBuilder.addAugmentation(ExperimenterAction.class, (Augmentation)experimenter.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }

    private static ActionsList createSetNwTtlAction(ByteBuf in, ActionsListBuilder actionsListBuilder) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetNwTtl.class);
        NwTtlActionBuilder nwTtl = new NwTtlActionBuilder();
        nwTtl.setNwTtl(Short.valueOf(in.readUnsignedByte()));
        actionBuilder.addAugmentation(NwTtlAction.class, (Augmentation)nwTtl.build());
        actionsListBuilder.setAction(actionBuilder.build());
        in.skipBytes(3);
        return actionsListBuilder.build();
    }

    private static ActionsList createSetFieldAction(ByteBuf in, ActionsListBuilder actionsListBuilder, int actionLength) {
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setType(SetField.class);
        OxmFieldsActionBuilder matchEntries = new OxmFieldsActionBuilder();
        matchEntries.setMatchEntries(MatchDeserializer.createMatchEntry(in, actionLength - 4));
        actionBuilder.addAugmentation(OxmFieldsAction.class, (Augmentation)matchEntries.build());
        actionsListBuilder.setAction(actionBuilder.build());
        return actionsListBuilder.build();
    }
}

