/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;

public class TableModInputMessageFactory
implements OFSerializer<TableModInput> {
    private static final byte MESSAGE_TYPE = 17;
    private static final byte PADDING_IN_TABLE_MOD_MESSAGE = 3;
    private static final int MESSAGE_LENGTH = 16;
    private static TableModInputMessageFactory instance;

    private TableModInputMessageFactory() {
    }

    public static synchronized TableModInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new TableModInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, TableModInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        out.writeByte((int)message.getTableId().getValue().byteValue());
        ByteBufUtils.padBuffer(3, out);
        out.writeInt(TableModInputMessageFactory.createConfigBitmask(message.getConfig()));
    }

    @Override
    public int computeLength(TableModInput message) {
        return 16;
    }

    @Override
    public byte getMessageType() {
        return 17;
    }

    private static int createConfigBitmask(TableConfig tableConfig) {
        HashMap<Integer, Boolean> portConfigMap = new HashMap<Integer, Boolean>();
        portConfigMap.put(3, tableConfig.isOFPTCDEPRECATEDMASK());
        int configBitmask = ByteBufUtils.fillBitMaskFromMap(portConfigMap);
        return configBitmask;
    }
}

