/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;

public class PacketOutInputMessageFactory
implements OFSerializer<PacketOutInput> {
    public static final byte MESSAGE_TYPE = 13;
    private static final int MESSAGE_LENGTH = 24;
    private static final byte PADDING_IN_PACKET_OUT_MESSAGE = 6;
    private static PacketOutInputMessageFactory instance;

    private PacketOutInputMessageFactory() {
    }

    public static synchronized PacketOutInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new PacketOutInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, PacketOutInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        out.writeInt(message.getBufferId().intValue());
        out.writeInt(message.getInPort().getValue().intValue());
        out.writeShort(ActionsSerializer.computeLengthOfActions(message.getActionsList()));
        ByteBufUtils.padBuffer(6, out);
        ActionsSerializer.encodeActions(message.getActionsList(), out);
        byte[] data = message.getData();
        if (data != null) {
            out.writeBytes(data);
        }
    }

    @Override
    public int computeLength(PacketOutInput message) {
        int length = 24;
        length += ActionsSerializer.computeLengthOfActions(message.getActionsList());
        byte[] data = message.getData();
        if (data != null) {
            length += data.length;
        }
        return length;
    }

    @Override
    public byte getMessageType() {
        return 13;
    }
}

