/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.OF10ActionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.OF10MatchSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlagsV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;

public class OF10FlowModInputMessageFactory
implements OFSerializer<FlowModInput> {
    private static final byte MESSAGE_TYPE = 14;
    private static final int MESSAGE_LENGTH = 72;
    private static OF10FlowModInputMessageFactory instance;

    private OF10FlowModInputMessageFactory() {
    }

    public static synchronized OF10FlowModInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10FlowModInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, FlowModInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        OF10MatchSerializer.encodeMatchV10(out, message.getMatchV10());
        out.writeLong(message.getCookie().longValue());
        out.writeShort(message.getCommand().getIntValue());
        out.writeShort(message.getIdleTimeout().intValue());
        out.writeShort(message.getHardTimeout().intValue());
        out.writeShort(message.getPriority().intValue());
        out.writeInt(message.getBufferId().intValue());
        out.writeShort(message.getOutPort().getValue().intValue());
        out.writeShort(OF10FlowModInputMessageFactory.createFlowModFlagsBitmask(message.getFlagsV10()));
        OF10ActionsSerializer.encodeActionsV10(out, message.getActionsList());
    }

    @Override
    public int computeLength(FlowModInput message) {
        return 72 + OF10ActionsSerializer.computeActionsLength(message.getActionsList());
    }

    @Override
    public byte getMessageType() {
        return 14;
    }

    private static int createFlowModFlagsBitmask(FlowModFlagsV10 flags) {
        int flowModFlagBitmask = 0;
        HashMap<Integer, Boolean> flowModFlagsMap = new HashMap<Integer, Boolean>();
        flowModFlagsMap.put(0, flags.isOFPFFSENDFLOWREM());
        flowModFlagsMap.put(1, flags.isOFPFFCHECKOVERLAP());
        flowModFlagsMap.put(2, flags.isOFPFFEMERG());
        flowModFlagBitmask = ByteBufUtils.fillBitMaskFromMap(flowModFlagsMap);
        return flowModFlagBitmask;
    }
}

