/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.InstructionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.MatchSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.Experimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.Instructions;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.MultipartRequestBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.MultipartRequestTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.aggregate._case.MultipartRequestAggregate;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.experimenter._case.MultipartRequestExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.flow._case.MultipartRequestFlow;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.group._case.MultipartRequestGroup;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter._case.MultipartRequestMeter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.meter.config._case.MultipartRequestMeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.port.stats._case.MultipartRequestPortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.queue._case.MultipartRequestQueue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.MultipartRequestTableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.request.multipart.request.body.multipart.request.table.features._case.multipart.request.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties;

public class MultipartRequestInputFactory
implements OFSerializer<MultipartRequestInput> {
    private static final byte MESSAGE_TYPE = 18;
    private static final int MESSAGE_LENGTH = 16;
    private static final byte PADDING_IN_MULTIPART_REQUEST_MESSAGE = 4;
    private static final byte TABLE_FEAT_HEADER_LENGTH = 4;
    private static MultipartRequestInputFactory instance;
    private static final byte INSTRUCTIONS_CODE = 0;
    private static final byte INSTRUCTIONS_MISS_CODE = 1;
    private static final byte NEXT_TABLE_CODE = 2;
    private static final byte NEXT_TABLE_MISS_CODE = 3;
    private static final byte WRITE_ACTIONS_CODE = 4;
    private static final byte WRITE_ACTIONS_MISS_CODE = 5;
    private static final byte APPLY_ACTIONS_CODE = 6;
    private static final byte APPLY_ACTIONS_MISS_CODE = 7;
    private static final byte MATCH_CODE = 8;
    private static final byte WILDCARDS_CODE = 10;
    private static final byte WRITE_SETFIELD_CODE = 12;
    private static final byte WRITE_SETFIELD_MISS_CODE = 13;
    private static final byte APPLY_SETFIELD_CODE = 14;
    private static final byte APPLY_SETFIELD_MISS_CODE = 15;
    private static final int EXPERIMENTER_CODE = 65534;
    private static final int EXPERIMENTER_MISS_CODE = 65535;
    private static final byte FLOW_BODY_LENGTH = 32;
    private static final byte AGGREGATE_BODY_LENGTH = 32;
    private static final byte PORT_STATS_BODY_LENGTH = 8;
    private static final byte QUEUE_BODY_LENGTH = 8;
    private static final byte GROUP_BODY_LENGTH = 8;
    private static final byte METER_BODY_LENGTH = 8;
    private static final byte METER_CONFIG_BODY_LENGTH = 8;
    private static final byte EXPERIMENTER_BODY_LENGTH = 8;
    private static final byte TABLE_FEATURES_LENGTH = 64;
    private static final byte STRUCTURE_HEADER_LENGTH = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_01 = 3;
    private static final byte PADDING_IN_MULTIPART_REQUEST_FLOW_BODY_02 = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_AGREGGATE_BODY_01 = 3;
    private static final byte PADDING_IN_MULTIPART_REQUEST_AGREGGATE_BODY_02 = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_PORTSTATS_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_GROUP_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_METER_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_METER_CONFIG_BODY = 4;
    private static final byte PADDING_IN_MULTIPART_REQUEST_TABLE_FEATURES_BODY = 5;

    private MultipartRequestInputFactory() {
    }

    public static synchronized MultipartRequestInputFactory getInstance() {
        if (instance == null) {
            instance = new MultipartRequestInputFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, MultipartRequestInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        out.writeShort(message.getType().getIntValue());
        out.writeShort(MultipartRequestInputFactory.createMultipartRequestFlagsBitmask(message.getFlags()));
        ByteBufUtils.padBuffer(4, out);
        if (message.getMultipartRequestBody() instanceof MultipartRequestDescCase) {
            this.encodeDescBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestFlowCase) {
            MultipartRequestInputFactory.encodeFlowBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestAggregateCase) {
            MultipartRequestInputFactory.encodeAggregateBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestTableCase) {
            this.encodeTableBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestPortStatsCase) {
            MultipartRequestInputFactory.encodePortStatsBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestQueueCase) {
            MultipartRequestInputFactory.encodeQueueBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupCase) {
            MultipartRequestInputFactory.encodeGroupStatsBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupDescCase) {
            this.encodeGroupDescBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestGroupFeaturesCase) {
            this.encodeGroupFeaturesBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterCase) {
            MultipartRequestInputFactory.encodeMeterBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterConfigCase) {
            MultipartRequestInputFactory.encodeMeterConfigBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestMeterFeaturesCase) {
            this.encodeMeterFeaturesBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestTableFeaturesCase) {
            MultipartRequestInputFactory.encodeTableFeaturesBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestPortDescCase) {
            this.encodePortDescBody(message.getMultipartRequestBody(), out);
        } else if (message.getMultipartRequestBody() instanceof MultipartRequestExperimenterCase) {
            MultipartRequestInputFactory.encodeExperimenterBody(message.getMultipartRequestBody(), out);
        }
    }

    @Override
    public int computeLength(MultipartRequestInput message) {
        return 16 + this.computeBodyLength(message);
    }

    @Override
    public byte getMessageType() {
        return 18;
    }

    public int computeBodyLength(MultipartRequestInput message) {
        int length = 0;
        MultipartType type = message.getType();
        if (type.equals((Object)MultipartType.OFPMPFLOW)) {
            MultipartRequestFlowCase bodyCase = (MultipartRequestFlowCase)message.getMultipartRequestBody();
            MultipartRequestFlow body = bodyCase.getMultipartRequestFlow();
            length += 32 + MatchSerializer.computeMatchLength(body.getMatch());
        } else if (type.equals((Object)MultipartType.OFPMPAGGREGATE)) {
            MultipartRequestAggregateCase bodyCase = (MultipartRequestAggregateCase)message.getMultipartRequestBody();
            MultipartRequestAggregate body = bodyCase.getMultipartRequestAggregate();
            length += 32 + MatchSerializer.computeMatchLength(body.getMatch());
        } else if (type.equals((Object)MultipartType.OFPMPPORTSTATS)) {
            length += 8;
        } else if (type.equals((Object)MultipartType.OFPMPQUEUE)) {
            length += 8;
        } else if (type.equals((Object)MultipartType.OFPMPGROUP)) {
            length += 8;
        } else if (type.equals((Object)MultipartType.OFPMPMETER)) {
            length += 8;
        } else if (type.equals((Object)MultipartType.OFPMPMETERCONFIG)) {
            length += 8;
        } else if (type.equals((Object)MultipartType.OFPMPTABLEFEATURES)) {
            MultipartRequestTableFeaturesCase bodyCase = (MultipartRequestTableFeaturesCase)message.getMultipartRequestBody();
            MultipartRequestTableFeatures body = bodyCase.getMultipartRequestTableFeatures();
            length += MultipartRequestInputFactory.computeTableFeaturesLength(body);
        } else if (type.equals((Object)MultipartType.OFPMPEXPERIMENTER)) {
            MultipartRequestExperimenterCase bodyCase = (MultipartRequestExperimenterCase)message.getMultipartRequestBody();
            MultipartRequestExperimenter body = bodyCase.getMultipartRequestExperimenter();
            length += 8;
            if (body.getData() != null) {
                length += body.getData().length;
            }
        }
        return length;
    }

    private static int computeTableFeaturesLength(MultipartRequestTableFeatures body) {
        int length = 0;
        if (body != null && body.getTableFeatures() != null) {
            List tableFeatures = body.getTableFeatures();
            for (TableFeatures feature : tableFeatures) {
                length += MultipartRequestInputFactory.computeSingleTableFeatureLength(feature);
            }
        }
        return length;
    }

    private static int computeSingleTableFeatureLength(TableFeatures feature) {
        return 64 + MultipartRequestInputFactory.computeTableFeatPropsLength(feature);
    }

    private static int computeTableFeatPropsLength(TableFeatures feature) {
        int length = 0;
        List featureProperties = feature.getTableFeatureProperties();
        if (featureProperties != null) {
            for (TableFeatureProperties featProp : featureProperties) {
                InstructionRelatedTableFeatureProperty property;
                length += 4;
                if (featProp.getAugmentation(InstructionRelatedTableFeatureProperty.class) != null) {
                    property = (InstructionRelatedTableFeatureProperty)featProp.getAugmentation(InstructionRelatedTableFeatureProperty.class);
                    length += property.getInstructions().size() * 4;
                    length += MultipartRequestInputFactory.paddingNeeded(length);
                    continue;
                }
                if (featProp.getAugmentation(NextTableRelatedTableFeatureProperty.class) != null) {
                    property = (NextTableRelatedTableFeatureProperty)featProp.getAugmentation(NextTableRelatedTableFeatureProperty.class);
                    length += property.getNextTableIds().size();
                    length += MultipartRequestInputFactory.paddingNeeded(length);
                    continue;
                }
                if (featProp.getAugmentation(ActionRelatedTableFeatureProperty.class) != null) {
                    property = (ActionRelatedTableFeatureProperty)featProp.getAugmentation(ActionRelatedTableFeatureProperty.class);
                    length += property.getActionsList().size() * 4;
                    length += MultipartRequestInputFactory.paddingNeeded(length);
                    continue;
                }
                if (featProp.getAugmentation(OxmRelatedTableFeatureProperty.class) != null) {
                    property = (OxmRelatedTableFeatureProperty)featProp.getAugmentation(OxmRelatedTableFeatureProperty.class);
                    length += property.getMatchEntries().size() * 4;
                    length += MultipartRequestInputFactory.paddingNeeded(length);
                    continue;
                }
                if (featProp.getAugmentation(ExperimenterRelatedTableFeatureProperty.class) == null) continue;
                property = (ExperimenterRelatedTableFeatureProperty)featProp.getAugmentation(ExperimenterRelatedTableFeatureProperty.class);
                length += 8;
                if (property.getData() != null) {
                    length += property.getData().length;
                }
                length += MultipartRequestInputFactory.paddingNeeded(length);
            }
        }
        return length;
    }

    private static int createMultipartRequestFlagsBitmask(MultipartRequestFlags flags) {
        int multipartRequestFlagsBitmask = 0;
        HashMap<Integer, Boolean> multipartRequestFlagsMap = new HashMap<Integer, Boolean>();
        multipartRequestFlagsMap.put(0, flags.isOFPMPFREQMORE());
        multipartRequestFlagsBitmask = ByteBufUtils.fillBitMaskFromMap(multipartRequestFlagsMap);
        return multipartRequestFlagsBitmask;
    }

    private void encodeDescBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
    }

    private void encodeTableBody(MultipartRequestBody multipartRequestBody, ByteBuf out) {
    }

    private void encodeGroupDescBody(MultipartRequestBody multipartRequestBody, ByteBuf out) {
    }

    private void encodeGroupFeaturesBody(MultipartRequestBody multipartRequestBody, ByteBuf out) {
    }

    private void encodeMeterFeaturesBody(MultipartRequestBody multipartRequestBody, ByteBuf out) {
    }

    private void encodePortDescBody(MultipartRequestBody multipartRequestBody, ByteBuf out) {
    }

    private static void encodeFlowBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestFlowCase flowCase = (MultipartRequestFlowCase)multipartRequestBody;
        MultipartRequestFlow flow = flowCase.getMultipartRequestFlow();
        output.writeByte((int)flow.getTableId().byteValue());
        ByteBufUtils.padBuffer(3, output);
        output.writeInt(flow.getOutPort().intValue());
        output.writeInt(flow.getOutGroup().intValue());
        ByteBufUtils.padBuffer(4, output);
        output.writeLong(flow.getCookie().longValue());
        output.writeLong(flow.getCookieMask().longValue());
        MatchSerializer.encodeMatch(flow.getMatch(), output);
    }

    private static void encodeAggregateBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestAggregateCase aggregateCase = (MultipartRequestAggregateCase)multipartRequestBody;
        MultipartRequestAggregate aggregate = aggregateCase.getMultipartRequestAggregate();
        output.writeByte((int)aggregate.getTableId().byteValue());
        ByteBufUtils.padBuffer(3, output);
        output.writeInt(aggregate.getOutPort().intValue());
        output.writeInt(aggregate.getOutGroup().intValue());
        ByteBufUtils.padBuffer(4, output);
        output.writeLong(aggregate.getCookie().longValue());
        output.writeLong(aggregate.getCookieMask().longValue());
        MatchSerializer.encodeMatch(aggregate.getMatch(), output);
    }

    private static void encodePortStatsBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestPortStatsCase portstatsCase = (MultipartRequestPortStatsCase)multipartRequestBody;
        MultipartRequestPortStats portstats = portstatsCase.getMultipartRequestPortStats();
        output.writeInt(portstats.getPortNo().intValue());
        ByteBufUtils.padBuffer(4, output);
    }

    private static void encodeQueueBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestQueueCase queueCase = (MultipartRequestQueueCase)multipartRequestBody;
        MultipartRequestQueue queue = queueCase.getMultipartRequestQueue();
        output.writeInt(queue.getPortNo().intValue());
        output.writeInt(queue.getQueueId().intValue());
    }

    private static void encodeGroupStatsBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestGroupCase groupStatsCase = (MultipartRequestGroupCase)multipartRequestBody;
        MultipartRequestGroup groupStats = groupStatsCase.getMultipartRequestGroup();
        output.writeInt(groupStats.getGroupId().getValue().intValue());
        ByteBufUtils.padBuffer(4, output);
    }

    private static void encodeMeterBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestMeterCase meterCase = (MultipartRequestMeterCase)multipartRequestBody;
        MultipartRequestMeter meter = meterCase.getMultipartRequestMeter();
        output.writeInt(meter.getMeterId().getValue().intValue());
        ByteBufUtils.padBuffer(4, output);
    }

    private static void encodeMeterConfigBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestMeterConfigCase meterConfigCase = (MultipartRequestMeterConfigCase)multipartRequestBody;
        MultipartRequestMeterConfig meterConfig = meterConfigCase.getMultipartRequestMeterConfig();
        output.writeInt(meterConfig.getMeterId().getValue().intValue());
        ByteBufUtils.padBuffer(4, output);
    }

    private static void encodeExperimenterBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestExperimenterCase experimenterCase = (MultipartRequestExperimenterCase)multipartRequestBody;
        MultipartRequestExperimenter experimenter = experimenterCase.getMultipartRequestExperimenter();
        output.writeInt(experimenter.getExperimenter().intValue());
        output.writeInt(experimenter.getExpType().intValue());
        byte[] data = experimenter.getData();
        if (data != null) {
            output.writeBytes(data);
        }
    }

    private static void encodeTableFeaturesBody(MultipartRequestBody multipartRequestBody, ByteBuf output) {
        MultipartRequestTableFeaturesCase tableFeaturesCase;
        MultipartRequestTableFeatures tableFeatures;
        if (multipartRequestBody != null && (tableFeatures = (tableFeaturesCase = (MultipartRequestTableFeaturesCase)multipartRequestBody).getMultipartRequestTableFeatures()).getTableFeatures() != null) {
            for (TableFeatures currTableFeature : tableFeatures.getTableFeatures()) {
                int length = MultipartRequestInputFactory.computeSingleTableFeatureLength(currTableFeature);
                length += MultipartRequestInputFactory.paddingNeeded(length);
                output.writeShort(length);
                output.writeByte((int)currTableFeature.getTableId().shortValue());
                ByteBufUtils.padBuffer(5, output);
                output.writeBytes(currTableFeature.getName().getBytes());
                ByteBufUtils.padBuffer(32 - currTableFeature.getName().getBytes().length, output);
                output.writeLong(currTableFeature.getMetadataMatch().longValue());
                output.writeLong(currTableFeature.getMetadataWrite().longValue());
                output.writeInt(MultipartRequestInputFactory.createTableConfigBitmask(currTableFeature.getConfig()));
                output.writeInt(currTableFeature.getMaxEntries().intValue());
                MultipartRequestInputFactory.writeTableFeatureProperties(output, currTableFeature.getTableFeatureProperties());
            }
        }
    }

    private static void writeTableFeatureProperties(ByteBuf output, List<TableFeatureProperties> props) {
        if (props != null) {
            for (TableFeatureProperties property : props) {
                TableFeaturesPropType type = property.getType();
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS)) {
                    MultipartRequestInputFactory.writeInstructionRelatedTableProperty(output, property, (byte)0);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS)) {
                    MultipartRequestInputFactory.writeInstructionRelatedTableProperty(output, property, (byte)1);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLES)) {
                    MultipartRequestInputFactory.writeNextTableRelatedTableProperty(output, property, (byte)2);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS)) {
                    MultipartRequestInputFactory.writeNextTableRelatedTableProperty(output, property, (byte)3);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS)) {
                    MultipartRequestInputFactory.writeActionsRelatedTableProperty(output, property, (byte)4);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS)) {
                    MultipartRequestInputFactory.writeActionsRelatedTableProperty(output, property, (byte)5);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS)) {
                    MultipartRequestInputFactory.writeActionsRelatedTableProperty(output, property, (byte)6);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS)) {
                    MultipartRequestInputFactory.writeActionsRelatedTableProperty(output, property, (byte)7);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTMATCH)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)8);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWILDCARDS)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)10);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)12);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)13);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)14);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS)) {
                    MultipartRequestInputFactory.writeOxmRelatedTableProperty(output, property, (byte)15);
                    continue;
                }
                if (type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTER)) {
                    MultipartRequestInputFactory.writeExperimenterRelatedTableProperty(output, property, 65534);
                    continue;
                }
                if (!type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS)) continue;
                MultipartRequestInputFactory.writeExperimenterRelatedTableProperty(output, property, 65535);
            }
        }
    }

    private static void writeInstructionRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        output.writeShort((int)code);
        List instructions = ((InstructionRelatedTableFeatureProperty)property.getAugmentation(InstructionRelatedTableFeatureProperty.class)).getInstructions();
        int length = 4;
        int padding = 0;
        if (instructions != null) {
            for (Instructions instruction : instructions) {
                if (instruction.getType().isAssignableFrom(Experimenter.class)) {
                    length += 8;
                    continue;
                }
                length += 4;
            }
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeShort(length);
            InstructionsSerializer.encodeInstructionIds(instructions, output);
        } else {
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeShort(length);
        }
        ByteBufUtils.padBuffer(padding, output);
    }

    private static void writeNextTableRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        output.writeShort((int)code);
        List nextTableIds = ((NextTableRelatedTableFeatureProperty)property.getAugmentation(NextTableRelatedTableFeatureProperty.class)).getNextTableIds();
        int length = 4;
        int padding = 0;
        if (nextTableIds != null) {
            padding = MultipartRequestInputFactory.paddingNeeded(length += nextTableIds.size());
            output.writeShort(length);
            for (NextTableIds next : nextTableIds) {
                output.writeByte((int)next.getTableId().shortValue());
            }
        } else {
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeShort(length + padding);
        }
        ByteBufUtils.padBuffer(padding, output);
    }

    private static int paddingNeeded(int length) {
        int paddingRemainder = length % 8;
        int result = 0;
        if (paddingRemainder != 0) {
            result = 8 - paddingRemainder;
        }
        return result;
    }

    private static void writeActionsRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        output.writeShort((int)code);
        List actions = ((ActionRelatedTableFeatureProperty)property.getAugmentation(ActionRelatedTableFeatureProperty.class)).getActionsList();
        int length = 4;
        int padding = 0;
        if (actions != null) {
            for (ActionsList action : actions) {
                if (action.getAction().getType().isAssignableFrom(Experimenter.class)) {
                    length += 8;
                    continue;
                }
                length += 4;
            }
            padding += MultipartRequestInputFactory.paddingNeeded(length += actions.size() * 4);
            output.writeShort(length);
            ActionsSerializer.encodeActionIds(actions, output);
        } else {
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeShort(length);
        }
        ByteBufUtils.padBuffer(padding, output);
    }

    private static void writeOxmRelatedTableProperty(ByteBuf output, TableFeatureProperties property, byte code) {
        output.writeShort((int)code);
        List entries = ((OxmRelatedTableFeatureProperty)property.getAugmentation(OxmRelatedTableFeatureProperty.class)).getMatchEntries();
        int length = 4;
        int padding = 0;
        if (entries != null) {
            padding = MultipartRequestInputFactory.paddingNeeded(length += entries.size() * 4);
            output.writeShort(length);
            MatchSerializer.encodeMatchIds(entries, output);
        } else {
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeShort(length);
        }
        ByteBufUtils.padBuffer(padding, output);
    }

    private static void writeExperimenterRelatedTableProperty(ByteBuf output, TableFeatureProperties property, int code) {
        output.writeShort(code);
        ExperimenterRelatedTableFeatureProperty exp = (ExperimenterRelatedTableFeatureProperty)property.getAugmentation(ExperimenterRelatedTableFeatureProperty.class);
        byte[] data = exp.getData();
        int length = 12;
        int padding = 0;
        if (data != null) {
            output.writeShort(length + data.length);
            padding = MultipartRequestInputFactory.paddingNeeded(length + data.length);
            output.writeInt(exp.getExperimenter().intValue());
            output.writeInt(exp.getExpType().intValue());
            output.writeBytes(data);
        } else {
            output.writeShort(length);
            padding = MultipartRequestInputFactory.paddingNeeded(length);
            output.writeInt(exp.getExperimenter().intValue());
            output.writeInt(exp.getExpType().intValue());
        }
        ByteBufUtils.padBuffer(padding, output);
    }

    private static int createTableConfigBitmask(TableConfig tableConfig) {
        int tableConfigBitmask = 0;
        HashMap<Integer, Boolean> tableConfigMap = new HashMap<Integer, Boolean>();
        tableConfigMap.put(3, tableConfig.isOFPTCDEPRECATEDMASK());
        tableConfigBitmask = ByteBufUtils.fillBitMaskFromMap(tableConfigMap);
        return tableConfigBitmask;
    }
}

