/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterBandCommons;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDrop;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemark;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.experimenter._case.MeterBandExperimenter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.mod.Bands;

public class MeterModInputMessageFactory
implements OFSerializer<MeterModInput> {
    private static final byte MESSAGE_TYPE = 29;
    private static final int MESSAGE_LENGTH = 16;
    private static final short LENGTH_OF_METER_BANDS = 16;
    private static final short PADDING_IN_METER_BAND_DROP = 4;
    private static final short PADDING_IN_METER_BAND_DSCP_REMARK = 3;
    private static MeterModInputMessageFactory instance;

    private MeterModInputMessageFactory() {
    }

    public static synchronized MeterModInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new MeterModInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, MeterModInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        out.writeShort(message.getCommand().getIntValue());
        out.writeShort(MeterModInputMessageFactory.createMeterFlagsBitmask(message.getFlags()));
        out.writeInt(message.getMeterId().getValue().intValue());
        MeterModInputMessageFactory.encodeBands(message.getBands(), out);
    }

    @Override
    public int computeLength(MeterModInput message) {
        int length = 16;
        if (message.getBands() != null) {
            length += message.getBands().size() * 16;
        }
        return length;
    }

    @Override
    public byte getMessageType() {
        return 29;
    }

    private static int createMeterFlagsBitmask(MeterFlags flags) {
        int meterFlagBitmask = 0;
        HashMap<Integer, Boolean> meterModFlagsMap = new HashMap<Integer, Boolean>();
        meterModFlagsMap.put(0, flags.isOFPMFKBPS());
        meterModFlagsMap.put(1, flags.isOFPMFPKTPS());
        meterModFlagsMap.put(2, flags.isOFPMFBURST());
        meterModFlagsMap.put(3, flags.isOFPMFSTATS());
        meterFlagBitmask = ByteBufUtils.fillBitMaskFromMap(meterModFlagsMap);
        return meterFlagBitmask;
    }

    private static void encodeBands(List<Bands> bands, ByteBuf outBuffer) {
        if (bands != null) {
            for (Bands currentBand : bands) {
                MeterBand meterBand = currentBand.getMeterBand();
                if (meterBand instanceof MeterBandDropCase) {
                    MeterBandDropCase dropBandCase = (MeterBandDropCase)meterBand;
                    MeterBandDrop dropBand = dropBandCase.getMeterBandDrop();
                    MeterModInputMessageFactory.writeBandCommonFields((MeterBandCommons)dropBand, outBuffer);
                    ByteBufUtils.padBuffer(4, outBuffer);
                    continue;
                }
                if (meterBand instanceof MeterBandDscpRemarkCase) {
                    MeterBandDscpRemarkCase dscpRemarkBandCase = (MeterBandDscpRemarkCase)meterBand;
                    MeterBandDscpRemark dscpRemarkBand = dscpRemarkBandCase.getMeterBandDscpRemark();
                    MeterModInputMessageFactory.writeBandCommonFields((MeterBandCommons)dscpRemarkBand, outBuffer);
                    outBuffer.writeByte((int)dscpRemarkBand.getPrecLevel().shortValue());
                    ByteBufUtils.padBuffer(3, outBuffer);
                    continue;
                }
                if (!(meterBand instanceof MeterBandExperimenterCase)) continue;
                MeterBandExperimenterCase experimenterBandCase = (MeterBandExperimenterCase)meterBand;
                MeterBandExperimenter experimenterBand = experimenterBandCase.getMeterBandExperimenter();
                MeterModInputMessageFactory.writeBandCommonFields((MeterBandCommons)experimenterBand, outBuffer);
                outBuffer.writeInt(experimenterBand.getExperimenter().intValue());
            }
        }
    }

    private static void writeBandCommonFields(MeterBandCommons meterBand, ByteBuf outBuffer) {
        outBuffer.writeShort(meterBand.getType().getIntValue());
        outBuffer.writeShort(16);
        outBuffer.writeInt(meterBand.getRate().intValue());
        outBuffer.writeInt(meterBand.getBurstSize().intValue());
    }
}

