/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloElementType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.hello.Elements;

public class HelloInputMessageFactory
implements OFSerializer<HelloInput> {
    private static final byte MESSAGE_TYPE = 0;
    private static int MESSAGE_LENGTH = 8;
    public static final byte HELLO_ELEMENT_HEADER_SIZE = 4;
    private static HelloInputMessageFactory instance;

    private HelloInputMessageFactory() {
    }

    public static synchronized HelloInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new HelloInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, HelloInput message) {
        int startWriterIndex = out.writerIndex();
        ByteBufUtils.writeOFHeader(instance, message, out);
        HelloInputMessageFactory.encodeElementsList(message, out);
        int endWriterIndex = out.writerIndex();
        int writtenBytesDiff = this.computeLength(message) - (endWriterIndex - startWriterIndex);
        ByteBufUtils.padBuffer(writtenBytesDiff, out);
    }

    @Override
    public int computeLength(HelloInput message) {
        int length = MESSAGE_LENGTH;
        List elements = message.getElements();
        if (elements != null) {
            for (Elements element : elements) {
                if (!HelloElementType.VERSIONBITMAP.equals((Object)element.getType())) continue;
                int bitmapLength = HelloInputMessageFactory.computeVersionBitmapLength(element);
                int paddingRemainder = bitmapLength % 8;
                if (paddingRemainder != 0) {
                    bitmapLength += 8 - paddingRemainder;
                }
                length += bitmapLength;
            }
        }
        return length;
    }

    @Override
    public byte getMessageType() {
        return 0;
    }

    private static void encodeElementsList(HelloInput message, ByteBuf output) {
        if (message.getElements() != null) {
            for (Elements currElement : message.getElements()) {
                output.writeShort(currElement.getType().getIntValue());
                if (!currElement.getType().equals((Object)HelloElementType.VERSIONBITMAP)) continue;
                short bitmapLength = HelloInputMessageFactory.computeVersionBitmapLength(currElement);
                output.writeShort((int)bitmapLength);
                int[] versionBitmap = ByteBufUtils.fillBitMaskFromList(currElement.getVersionBitmap());
                for (int i = 0; i < versionBitmap.length; ++i) {
                    output.writeInt(versionBitmap[i]);
                }
                int padding = bitmapLength - versionBitmap.length * 4 - 4;
                ByteBufUtils.padBuffer(padding, output);
            }
        }
    }

    private static short computeVersionBitmapLength(Elements element) {
        short elementlength = 4;
        if (!element.getVersionBitmap().isEmpty()) {
            elementlength = (short)(elementlength + ((element.getVersionBitmap().size() - 1) / 32 + 1) * 4);
        }
        return elementlength;
    }
}

