/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;

public class GroupModInputMessageFactory
implements OFSerializer<GroupModInput> {
    private static final byte MESSAGE_TYPE = 15;
    private static final int MESSAGE_LENGTH = 16;
    private static final byte PADDING_IN_GROUP_MOD_MESSAGE = 1;
    private static final byte LENGTH_OF_BUCKET_STRUCTURE = 16;
    private static final byte PADDING_IN_BUCKET = 4;
    private static GroupModInputMessageFactory instance;

    private GroupModInputMessageFactory() {
    }

    public static synchronized GroupModInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new GroupModInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, GroupModInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        out.writeShort(message.getCommand().getIntValue());
        out.writeByte(message.getType().getIntValue());
        ByteBufUtils.padBuffer(1, out);
        out.writeInt(message.getGroupId().getValue().intValue());
        GroupModInputMessageFactory.encodeBuckets(message.getBucketsList(), out);
    }

    @Override
    public int computeLength(GroupModInput message) {
        return 16 + GroupModInputMessageFactory.computeLengthOfBuckets(message.getBucketsList());
    }

    @Override
    public byte getMessageType() {
        return 15;
    }

    private static void encodeBuckets(List<BucketsList> buckets, ByteBuf outBuffer) {
        if (buckets != null) {
            for (BucketsList currentBucket : buckets) {
                outBuffer.writeShort(GroupModInputMessageFactory.computeLengthOfBucket(currentBucket));
                outBuffer.writeShort((int)currentBucket.getWeight().shortValue());
                outBuffer.writeInt(currentBucket.getWatchPort().getValue().intValue());
                outBuffer.writeInt(currentBucket.getWatchGroup().intValue());
                ByteBufUtils.padBuffer(4, outBuffer);
                ActionsSerializer.encodeActions(currentBucket.getActionsList(), outBuffer);
            }
        }
    }

    private static int computeLengthOfBucket(BucketsList bucket) {
        int lengthOfBuckets = 0;
        if (bucket != null) {
            lengthOfBuckets = 16 + ActionsSerializer.computeLengthOfActions(bucket.getActionsList());
        }
        return lengthOfBuckets;
    }

    private static int computeLengthOfBuckets(List<BucketsList> buckets) {
        int lengthOfBuckets = 0;
        if (buckets != null) {
            for (BucketsList currentBucket : buckets) {
                lengthOfBuckets += 16 + ActionsSerializer.computeLengthOfActions(currentBucket.getActionsList());
            }
        }
        return lengthOfBuckets;
    }
}

