/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;

public class EchoInputMessageFactory
implements OFSerializer<EchoInput> {
    public static final byte MESSAGE_TYPE = 2;
    private static EchoInputMessageFactory instance;
    private static final int MESSAGE_LENGTH = 8;

    private EchoInputMessageFactory() {
    }

    public static synchronized EchoInputMessageFactory getInstance() {
        if (instance == null) {
            instance = new EchoInputMessageFactory();
        }
        return instance;
    }

    @Override
    public void messageToBuffer(short version, ByteBuf out, EchoInput message) {
        ByteBufUtils.writeOFHeader(instance, message, out);
        byte[] data = message.getData();
        if (data != null) {
            out.writeBytes(data);
        }
    }

    @Override
    public int computeLength(EchoInput message) {
        int length = 8;
        byte[] data = message.getData();
        if (data != null) {
            length += data.length;
        }
        return length;
    }

    @Override
    public byte getMessageType() {
        return 2;
    }
}

