/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.serialization.EncoderTable;
import org.opendaylight.openflowjava.protocol.impl.serialization.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(SerializationFactory.class);

    public static <E extends DataObject> void messageToBuffer(short version, ByteBuf out, E message) {
        MessageTypeKey msgTypeKey = new MessageTypeKey(version, message.getClass());
        OFSerializer<?> encoder = EncoderTable.getInstance().getEncoder(msgTypeKey);
        if (encoder != null) {
            encoder.messageToBuffer(version, out, message);
        } else {
            LOGGER.warn("No correct encoder found in EncoderTable for arguments: " + msgTypeKey.toString());
        }
    }
}

