/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import org.opendaylight.yangtools.yang.binding.DataObject;

public class MessageTypeKey<E extends DataObject> {
    private final Class<E> msgType;
    private final short msgVersion;

    public MessageTypeKey(short msgVersion, Class<E> msgType) {
        this.msgType = msgType;
        this.msgVersion = msgVersion;
    }

    public short getMsgVersion() {
        return this.msgVersion;
    }

    public Class<E> getMsgType() {
        return this.msgType;
    }

    public String toString() {
        return "msgVersion: " + this.msgVersion + " msgType: " + this.msgType.getName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.msgVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessageTypeKey other = (MessageTypeKey)obj;
        if (this.msgType == null ? other.msgType != null : !other.msgType.isAssignableFrom(this.msgType)) {
            return false;
        }
        return this.msgVersion == other.msgVersion;
    }
}

