/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.serialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.impl.serialization.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.OFSerializer;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.BarrierInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.EchoInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.EchoReplyInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.ExperimenterInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.FlowModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.GetAsyncRequestMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.GetConfigInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.GetFeaturesInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.GetQueueConfigInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.GroupModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.HelloInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.MeterModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.MultipartRequestInputFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10BarrierInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10FlowModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10HelloInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10PacketOutInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10PortModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10QueueGetConfigInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10StatsRequestInputFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.OF10VendorInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.PacketOutInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.PortModInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.RoleRequestInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.SetAsyncInputMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.SetConfigMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.serialization.factories.TableModInputMessageFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.BarrierInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.EchoReplyInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ExperimenterInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GroupModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.HelloInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MeterModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketOutInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortModInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.RoleRequestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetAsyncInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.SetConfigInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.TableModInput;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EncoderTable {
    private static final short OF10 = 1;
    private static final short OF13 = 4;
    private static EncoderTable instance;
    private Map<MessageTypeKey<?>, OFSerializer<?>> table;

    private EncoderTable() {
    }

    public static synchronized EncoderTable getInstance() {
        if (instance == null) {
            instance = new EncoderTable();
            instance.init();
        }
        return instance;
    }

    public void init() {
        this.table = new HashMap();
        this.table.put(new MessageTypeKey<BarrierInput>(1, BarrierInput.class), OF10BarrierInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<EchoInput>(1, EchoInput.class), EchoInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<EchoReplyInput>(1, EchoReplyInput.class), EchoReplyInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<ExperimenterInput>(1, ExperimenterInput.class), OF10VendorInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<FlowModInput>(1, FlowModInput.class), OF10FlowModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetConfigInput>(1, GetConfigInput.class), GetConfigInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetFeaturesInput>(1, GetFeaturesInput.class), GetFeaturesInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetQueueConfigInput>(1, GetQueueConfigInput.class), OF10QueueGetConfigInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<HelloInput>(1, HelloInput.class), OF10HelloInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<MultipartRequestInput>(1, MultipartRequestInput.class), OF10StatsRequestInputFactory.getInstance());
        this.table.put(new MessageTypeKey<PacketOutInput>(1, PacketOutInput.class), OF10PacketOutInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<PortModInput>(1, PortModInput.class), OF10PortModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<SetConfigInput>(1, SetConfigInput.class), SetConfigMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<BarrierInput>(4, BarrierInput.class), BarrierInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<EchoInput>(4, EchoInput.class), EchoInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<EchoReplyInput>(4, EchoReplyInput.class), EchoReplyInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<ExperimenterInput>(4, ExperimenterInput.class), ExperimenterInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<FlowModInput>(4, FlowModInput.class), FlowModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetAsyncInput>(4, GetAsyncInput.class), GetAsyncRequestMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetConfigInput>(4, GetConfigInput.class), GetConfigInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetFeaturesInput>(4, GetFeaturesInput.class), GetFeaturesInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GetQueueConfigInput>(4, GetQueueConfigInput.class), GetQueueConfigInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<GroupModInput>(4, GroupModInput.class), GroupModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<HelloInput>(4, HelloInput.class), HelloInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<MeterModInput>(4, MeterModInput.class), MeterModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<MultipartRequestInput>(4, MultipartRequestInput.class), MultipartRequestInputFactory.getInstance());
        this.table.put(new MessageTypeKey<PacketOutInput>(4, PacketOutInput.class), PacketOutInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<PortModInput>(4, PortModInput.class), PortModInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<RoleRequestInput>(4, RoleRequestInput.class), RoleRequestInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<SetAsyncInput>(4, SetAsyncInput.class), SetAsyncInputMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<SetConfigInput>(4, SetConfigInput.class), SetConfigMessageFactory.getInstance());
        this.table.put(new MessageTypeKey<TableModInput>(4, TableModInput.class), TableModInputMessageFactory.getInstance());
    }

    public <E extends DataObject> OFSerializer<E> getEncoder(MessageTypeKey<E> msgTypeKey) {
        return this.table.get(msgTypeKey);
    }
}

