/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterQueuePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.RateQueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.RateQueuePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetQueueConfigOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.Queues;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.get.config.reply.QueuesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueueProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.queue.property.header.QueuePropertyBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class QueueGetConfigReplyMessageFactory
implements OFDeserializer<GetQueueConfigOutput> {
    private static final byte PADDING_IN_QUEUE_GET_CONFIG_REPLY_HEADER = 4;
    private static final byte PADDING_IN_PACKET_QUEUE_HEADER = 6;
    private static final byte PADDING_IN_QUEUE_PROPERTY_HEADER = 4;
    private static final int PADDING_IN_RATE_QUEUE_PROPERTY = 6;
    private static final int PADDING_IN_EXPERIMENTER_QUEUE_PROPERTY = 4;
    private static final byte PACKET_QUEUE_LENGTH = 16;
    private static QueueGetConfigReplyMessageFactory instance;

    private QueueGetConfigReplyMessageFactory() {
    }

    public static synchronized QueueGetConfigReplyMessageFactory getInstance() {
        if (instance == null) {
            instance = new QueueGetConfigReplyMessageFactory();
        }
        return instance;
    }

    @Override
    public GetQueueConfigOutput bufferToMessage(ByteBuf rawMessage, short version) {
        GetQueueConfigOutputBuilder builder = new GetQueueConfigOutputBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setPort(new PortNumber(Long.valueOf(rawMessage.readUnsignedInt())));
        rawMessage.skipBytes(4);
        builder.setQueues(QueueGetConfigReplyMessageFactory.createQueuesList(rawMessage));
        return builder.build();
    }

    private static List<Queues> createQueuesList(ByteBuf input) {
        ArrayList<Queues> queuesList = new ArrayList<Queues>();
        while (input.readableBytes() > 0) {
            QueuesBuilder queueBuilder = new QueuesBuilder();
            queueBuilder.setQueueId(new QueueId(Long.valueOf(input.readUnsignedInt())));
            queueBuilder.setPort(new PortNumber(Long.valueOf(input.readUnsignedInt())));
            int length = input.readUnsignedShort();
            input.skipBytes(6);
            queueBuilder.setQueueProperty(QueueGetConfigReplyMessageFactory.createPropertiesList(input, length - 16));
            queuesList.add(queueBuilder.build());
        }
        return queuesList;
    }

    private static List<QueueProperty> createPropertiesList(ByteBuf input, int length) {
        int propertiesLength = length;
        ArrayList<QueueProperty> propertiesList = new ArrayList<QueueProperty>();
        while (propertiesLength > 0) {
            QueuePropertyBuilder propertiesBuilder = new QueuePropertyBuilder();
            QueueProperties property = QueueProperties.forValue((int)input.readUnsignedShort());
            propertiesBuilder.setProperty(property);
            int currentPropertyLength = input.readUnsignedShort();
            propertiesLength -= currentPropertyLength;
            input.skipBytes(4);
            if (property.equals((Object)QueueProperties.OFPQTMINRATE) || property.equals((Object)QueueProperties.OFPQTMAXRATE)) {
                RateQueuePropertyBuilder rateBuilder = new RateQueuePropertyBuilder();
                rateBuilder.setRate(Integer.valueOf(input.readUnsignedShort()));
                propertiesBuilder.addAugmentation(RateQueueProperty.class, (Augmentation)rateBuilder.build());
                input.skipBytes(6);
            } else if (property.equals((Object)QueueProperties.OFPQTEXPERIMENTER)) {
                ExperimenterQueuePropertyBuilder expBuilder = new ExperimenterQueuePropertyBuilder();
                expBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                input.skipBytes(4);
                expBuilder.setData(input.readBytes(currentPropertyLength - 4 - 4).array());
                propertiesBuilder.addAugmentation(RateQueueProperty.class, (Augmentation)expBuilder.build());
            }
            propertiesList.add(propertiesBuilder.build());
        }
        return propertiesList;
    }
}

