/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;

public class PortStatusMessageFactory
implements OFDeserializer<PortStatusMessage> {
    private static PortStatusMessageFactory instance;
    private static final byte PADDING_IN_PORT_STATUS_HEADER = 7;
    private static final byte PADDING_IN_OFP_PORT_HEADER_1 = 4;
    private static final byte PADDING_IN_OFP_PORT_HEADER_2 = 2;

    private PortStatusMessageFactory() {
    }

    public static synchronized PortStatusMessageFactory getInstance() {
        if (instance == null) {
            instance = new PortStatusMessageFactory();
        }
        return instance;
    }

    @Override
    public PortStatusMessage bufferToMessage(ByteBuf rawMessage, short version) {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setReason(PortReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(7);
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedInt()));
        rawMessage.skipBytes(4);
        byte[] hwAddress = new byte[6];
        rawMessage.readBytes(hwAddress);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString(hwAddress)));
        rawMessage.skipBytes(2);
        builder.setName(ByteBufUtils.decodeNullTerminatedString(rawMessage, 16));
        builder.setConfig(PortStatusMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setState(PortStatusMessageFactory.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeatures(PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setCurrSpeed(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setMaxSpeed(Long.valueOf(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) != 0L;
        Boolean _10mbFd = (input & 2L) != 0L;
        Boolean _100mbHd = (input & 4L) != 0L;
        Boolean _100mbFd = (input & 8L) != 0L;
        Boolean _1gbHd = (input & 0x10L) != 0L;
        Boolean _1gbFd = (input & 0x20L) != 0L;
        Boolean _10gbFd = (input & 0x40L) != 0L;
        Boolean _40gbFd = (input & 0x80L) != 0L;
        Boolean _100gbFd = (input & 0x100L) != 0L;
        Boolean _1tbFd = (input & 0x200L) != 0L;
        Boolean _other = (input & 0x400L) != 0L;
        Boolean _copper = (input & 0x800L) != 0L;
        Boolean _fiber = (input & 0x1000L) != 0L;
        Boolean _autoneg = (input & 0x2000L) != 0L;
        Boolean _pause = (input & 0x4000L) != 0L;
        Boolean _pauseAsym = (input & 0x8000L) != 0L;
        return new PortFeatures(_100gbFd, _100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _1tbFd, _40gbFd, _autoneg, _copper, _fiber, _other, _pause, _pauseAsym);
    }

    private static PortState createPortState(long input) {
        Boolean _linkDown = (input & 1L) != 0L;
        Boolean _blocked = (input & 2L) != 0L;
        Boolean _live = (input & 4L) != 0L;
        return new PortState(_blocked, _linkDown, _live);
    }

    private static PortConfig createPortConfig(long input) {
        Boolean _portDown = (input & 1L) != 0L;
        Boolean _noRecv = (input & 4L) != 0L;
        Boolean _noFwd = (input & 0x20L) != 0L;
        Boolean _noPacketIn = (input & 0x40L) != 0L;
        return new PortConfig(_noFwd, _noPacketIn, _noRecv, _portDown);
    }
}

