/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;

public class PacketInMessageFactory
implements OFDeserializer<PacketInMessage> {
    private static PacketInMessageFactory instance;
    private static final byte PADDING_IN_PACKET_IN_HEADER = 2;

    private PacketInMessageFactory() {
    }

    public static synchronized PacketInMessageFactory getInstance() {
        if (instance == null) {
            instance = new PacketInMessageFactory();
        }
        return instance;
    }

    @Override
    public PacketInMessage bufferToMessage(ByteBuf rawMessage, short version) {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTotalLen(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(PacketInReason.forValue((int)rawMessage.readUnsignedByte()));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setMatch(MatchDeserializer.createMatch(rawMessage));
        rawMessage.skipBytes(2);
        builder.setData(rawMessage.readBytes(rawMessage.readableBytes()).array());
        return builder.build();
    }
}

