/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PortStatusMessageBuilder;

public class OF10PortStatusMessageFactory
implements OFDeserializer<PortStatusMessage> {
    private static final byte PADDING_IN_PORT_STATUS_HEADER = 7;
    private static OF10PortStatusMessageFactory instance;

    private OF10PortStatusMessageFactory() {
    }

    public static synchronized OF10PortStatusMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10PortStatusMessageFactory();
        }
        return instance;
    }

    @Override
    public PortStatusMessage bufferToMessage(ByteBuf rawMessage, short version) {
        PortStatusMessageBuilder builder = new PortStatusMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setReason(PortReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(7);
        OF10PortStatusMessageFactory.deserializePort(rawMessage, builder);
        return builder.build();
    }

    private static PortStateV10 createPortState(long input) {
        Boolean _linkDown = (input & 1L) != 0L;
        Boolean _blocked = (input & 2L) != 0L;
        Boolean _live = (input & 4L) != 0L;
        Boolean _stpListen = (input & 0L) != 0L;
        Boolean _stpLearn = (input & 0x100L) != 0L;
        Boolean _stpForward = (input & 0x200L) != 0L;
        Boolean _stpBlock = (input & 0x200L) != 0L && (input & 0x100L) != 0L;
        Boolean _stpMask = (input & 0x400L) != 0L;
        return new PortStateV10(_blocked, _linkDown, _live, _stpBlock, _stpForward, _stpLearn, _stpListen, _stpMask);
    }

    private static PortConfigV10 createPortConfig(long input) {
        Boolean _portDown = (input & 1L) != 0L;
        Boolean _noStp = (input & 2L) != 0L;
        Boolean _noRecv = (input & 4L) != 0L;
        Boolean _noRecvStp = (input & 8L) != 0L;
        Boolean _noFlood = (input & 0x10L) != 0L;
        Boolean _noFwd = (input & 0x20L) != 0L;
        Boolean _noPacketIn = (input & 0x40L) != 0L;
        return new PortConfigV10(_noFlood, _noFwd, _noPacketIn, _noRecv, _noRecvStp, _noStp, _portDown);
    }

    private static PortFeaturesV10 createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) != 0L;
        Boolean _10mbFd = (input & 2L) != 0L;
        Boolean _100mbHd = (input & 4L) != 0L;
        Boolean _100mbFd = (input & 8L) != 0L;
        Boolean _1gbHd = (input & 0x10L) != 0L;
        Boolean _1gbFd = (input & 0x20L) != 0L;
        Boolean _10gbFd = (input & 0x40L) != 0L;
        Boolean _copper = (input & 0x80L) != 0L;
        Boolean _fiber = (input & 0x100L) != 0L;
        Boolean _autoneg = (input & 0x200L) != 0L;
        Boolean _pause = (input & 0x400L) != 0L;
        Boolean _pauseAsym = (input & 0x800L) != 0L;
        return new PortFeaturesV10(_100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _autoneg, _copper, _fiber, _pause, _pauseAsym);
    }

    private static void deserializePort(ByteBuf rawMessage, PortStatusMessageBuilder builder) {
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedShort()));
        byte[] address = new byte[6];
        rawMessage.readBytes(address);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString(address)));
        builder.setName(ByteBufUtils.decodeNullTerminatedString(rawMessage, 16));
        builder.setConfigV10(OF10PortStatusMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setStateV10(OF10PortStatusMessageFactory.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeaturesV10(OF10PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeaturesV10(OF10PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeaturesV10(OF10PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeaturesV10(OF10PortStatusMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
    }
}

