/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.PacketInMessageBuilder;

public class OF10PacketInMessageFactory
implements OFDeserializer<PacketInMessage> {
    private static final byte PADDING_IN_PACKET_IN_HEADER = 1;
    private static OF10PacketInMessageFactory instance;

    private OF10PacketInMessageFactory() {
    }

    public static synchronized OF10PacketInMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10PacketInMessageFactory();
        }
        return instance;
    }

    @Override
    public PacketInMessage bufferToMessage(ByteBuf rawMessage, short version) {
        PacketInMessageBuilder builder = new PacketInMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setBufferId(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTotalLen(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setInPort(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(PacketInReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        int remainingBytes = rawMessage.readableBytes();
        if (remainingBytes > 0) {
            builder.setData(rawMessage.readBytes(remainingBytes).array());
        }
        return builder.build();
    }
}

