/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.OF10MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;

public class OF10FlowRemovedMessageFactory
implements OFDeserializer<FlowRemovedMessage> {
    private static final byte PADDING_IN_FLOW_REMOVED_MESSAGE = 1;
    private static final byte PADDING_IN_FLOW_REMOVED_MESSAGE_2 = 2;
    private static OF10FlowRemovedMessageFactory instance;

    private OF10FlowRemovedMessageFactory() {
    }

    public static synchronized OF10FlowRemovedMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10FlowRemovedMessageFactory();
        }
        return instance;
    }

    @Override
    public FlowRemovedMessage bufferToMessage(ByteBuf rawMessage, short version) {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setMatchV10(OF10MatchDeserializer.createMatchV10(rawMessage));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(FlowRemovedReason.forValue((int)rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(1);
        builder.setDurationSec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setDurationNsec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        rawMessage.skipBytes(2);
        byte[] packet_count = new byte[8];
        rawMessage.readBytes(packet_count);
        builder.setPacketCount(new BigInteger(1, packet_count));
        byte[] byte_count = new byte[8];
        rawMessage.readBytes(byte_count);
        builder.setByteCount(new BigInteger(1, byte_count));
        return builder.build();
    }
}

