/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.CapabilitiesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfigV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeaturesV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortStateV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetFeaturesOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.features.reply.PhyPortBuilder;

public class OF10FeaturesReplyMessageFactory
implements OFDeserializer<GetFeaturesOutput> {
    private static final byte PADDING_IN_FEATURES_REPLY_HEADER = 3;
    private static OF10FeaturesReplyMessageFactory instance;

    private OF10FeaturesReplyMessageFactory() {
    }

    public static synchronized OF10FeaturesReplyMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10FeaturesReplyMessageFactory();
        }
        return instance;
    }

    @Override
    public GetFeaturesOutput bufferToMessage(ByteBuf rawMessage, short version) {
        GetFeaturesOutputBuilder builder = new GetFeaturesOutputBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] datapathId = new byte[8];
        rawMessage.readBytes(datapathId);
        builder.setDatapathId(new BigInteger(1, datapathId));
        builder.setBuffers(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setTables(Short.valueOf(rawMessage.readUnsignedByte()));
        rawMessage.skipBytes(3);
        builder.setCapabilitiesV10(OF10FeaturesReplyMessageFactory.createCapabilitiesV10(rawMessage.readUnsignedInt()));
        builder.setActionsV10(OF10FeaturesReplyMessageFactory.createActionsV10(rawMessage.readUnsignedInt()));
        ArrayList<PhyPort> ports = new ArrayList<PhyPort>();
        while (rawMessage.readableBytes() > 0) {
            ports.add(OF10FeaturesReplyMessageFactory.deserializePort(rawMessage));
        }
        builder.setPhyPort(ports);
        return builder.build();
    }

    private static CapabilitiesV10 createCapabilitiesV10(long input) {
        Boolean FLOW_STATS = (input & 1L) != 0L;
        Boolean TABLE_STATS = (input & 2L) != 0L;
        Boolean PORT_STATS = (input & 4L) != 0L;
        Boolean STP = (input & 8L) != 0L;
        Boolean RESERVED = (input & 0x10L) != 0L;
        Boolean IP_REASM = (input & 0x20L) != 0L;
        Boolean QUEUE_STATS = (input & 0x40L) != 0L;
        Boolean ARP_MATCH_IP = (input & 0x80L) != 0L;
        return new CapabilitiesV10(ARP_MATCH_IP, FLOW_STATS, IP_REASM, PORT_STATS, QUEUE_STATS, RESERVED, STP, TABLE_STATS);
    }

    private static ActionTypeV10 createActionsV10(long input) {
        Boolean OUTPUT = (input & 1L) != 0L;
        Boolean SET_VLAN_VID = (input & 2L) != 0L;
        Boolean SET_VLAN_PCP = (input & 4L) != 0L;
        Boolean STRIP_VLAN = (input & 8L) != 0L;
        Boolean SET_DL_SRC = (input & 0x10L) != 0L;
        Boolean SET_DL_DST = (input & 0x20L) != 0L;
        Boolean SET_NW_SRC = (input & 0x40L) != 0L;
        Boolean SET_NW_DST = (input & 0x80L) != 0L;
        Boolean SET_NW_TOS = (input & 0x100L) != 0L;
        Boolean SET_TP_SRC = (input & 0x200L) != 0L;
        Boolean SET_TP_DST = (input & 0x400L) != 0L;
        Boolean ENQUEUE = (input & 0x800L) != 0L;
        Boolean VENDOR = (input & 0x1000L) != 0L;
        return new ActionTypeV10(ENQUEUE, OUTPUT, SET_DL_DST, SET_DL_SRC, SET_NW_DST, SET_NW_SRC, SET_NW_TOS, SET_TP_DST, SET_TP_SRC, SET_VLAN_PCP, SET_VLAN_VID, STRIP_VLAN, VENDOR);
    }

    private static PhyPort deserializePort(ByteBuf rawMessage) {
        PhyPortBuilder builder = new PhyPortBuilder();
        builder.setPortNo(Long.valueOf(rawMessage.readUnsignedShort()));
        byte[] address = new byte[6];
        rawMessage.readBytes(address);
        builder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString(address)));
        builder.setName(ByteBufUtils.decodeNullTerminatedString(rawMessage, 16));
        builder.setConfigV10(OF10FeaturesReplyMessageFactory.createPortConfig(rawMessage.readUnsignedInt()));
        builder.setStateV10(OF10FeaturesReplyMessageFactory.createPortState(rawMessage.readUnsignedInt()));
        builder.setCurrentFeaturesV10(OF10FeaturesReplyMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setAdvertisedFeaturesV10(OF10FeaturesReplyMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setSupportedFeaturesV10(OF10FeaturesReplyMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        builder.setPeerFeaturesV10(OF10FeaturesReplyMessageFactory.createPortFeatures(rawMessage.readUnsignedInt()));
        return builder.build();
    }

    private static PortStateV10 createPortState(long input) {
        Boolean _linkDown = (input & 1L) != 0L;
        Boolean _blocked = (input & 2L) != 0L;
        Boolean _live = (input & 4L) != 0L;
        Boolean _stpListen = (input & 0L) != 0L;
        Boolean _stpLearn = (input & 0x100L) != 0L;
        Boolean _stpForward = (input & 0x200L) != 0L;
        Boolean _stpBlock = (input & 0x200L) != 0L && (input & 0x100L) != 0L;
        Boolean _stpMask = (input & 0x400L) != 0L;
        return new PortStateV10(_blocked, _linkDown, _live, _stpBlock, _stpForward, _stpLearn, _stpListen, _stpMask);
    }

    private static PortConfigV10 createPortConfig(long input) {
        Boolean _portDown = (input & 1L) != 0L;
        Boolean _noStp = (input & 2L) != 0L;
        Boolean _noRecv = (input & 4L) != 0L;
        Boolean _noRecvStp = (input & 8L) != 0L;
        Boolean _noFlood = (input & 0x10L) != 0L;
        Boolean _noFwd = (input & 0x20L) != 0L;
        Boolean _noPacketIn = (input & 0x40L) != 0L;
        return new PortConfigV10(_noFlood, _noFwd, _noPacketIn, _noRecv, _noRecvStp, _noStp, _portDown);
    }

    private static PortFeaturesV10 createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) != 0L;
        Boolean _10mbFd = (input & 2L) != 0L;
        Boolean _100mbHd = (input & 4L) != 0L;
        Boolean _100mbFd = (input & 8L) != 0L;
        Boolean _1gbHd = (input & 0x10L) != 0L;
        Boolean _1gbFd = (input & 0x20L) != 0L;
        Boolean _10gbFd = (input & 0x40L) != 0L;
        Boolean _copper = (input & 0x80L) != 0L;
        Boolean _fiber = (input & 0x100L) != 0L;
        Boolean _autoneg = (input & 0x200L) != 0L;
        Boolean _pause = (input & 0x400L) != 0L;
        Boolean _pauseAsym = (input & 0x800L) != 0L;
        return new PortFeaturesV10(_100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _autoneg, _copper, _fiber, _pause, _pauseAsym);
    }
}

