/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadActionCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadRequestCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ErrorTypeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFailedCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloFailedCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortModFailedCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueOpFailedCodeV10;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessageBuilder;

public class OF10ErrorMessageFactory
implements OFDeserializer<ErrorMessage> {
    private static final String UNKNOWN_TYPE = "UNKNOWN_TYPE";
    private static final String UNKNOWN_CODE = "UNKNOWN_CODE";
    private static OF10ErrorMessageFactory instance;

    private OF10ErrorMessageFactory() {
    }

    public static synchronized OF10ErrorMessageFactory getInstance() {
        if (instance == null) {
            instance = new OF10ErrorMessageFactory();
        }
        return instance;
    }

    @Override
    public ErrorMessage bufferToMessage(ByteBuf rawMessage, short version) {
        ErrorMessageBuilder builder = new ErrorMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        ErrorTypeV10 errorType = ErrorTypeV10.forValue((int)type);
        OF10ErrorMessageFactory.decodeType(builder, errorType, type);
        OF10ErrorMessageFactory.decodeCode(rawMessage, builder, errorType);
        if (rawMessage.readableBytes() > 0) {
            builder.setData(rawMessage.readBytes(rawMessage.readableBytes()).array());
        }
        return builder.build();
    }

    private static void decodeType(ErrorMessageBuilder builder, ErrorTypeV10 type, int readValue) {
        if (type != null) {
            builder.setType(Integer.valueOf(type.getIntValue()));
            builder.setTypeString(type.name());
        } else {
            builder.setType(Integer.valueOf(readValue));
            builder.setTypeString(UNKNOWN_TYPE);
        }
    }

    private static void decodeCode(ByteBuf rawMessage, ErrorMessageBuilder builder, ErrorTypeV10 type) {
        int code = rawMessage.readUnsignedShort();
        if (type != null) {
            switch (type) {
                case HELLOFAILED: {
                    HelloFailedCodeV10 errorCode = HelloFailedCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADREQUEST: {
                    BadRequestCodeV10 errorCode = BadRequestCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADACTION: {
                    BadActionCodeV10 errorCode = BadActionCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case FLOWMODFAILED: {
                    FlowModFailedCodeV10 errorCode = FlowModFailedCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case PORTMODFAILED: {
                    PortModFailedCodeV10 errorCode = PortModFailedCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case QUEUEOPFAILED: {
                    QueueOpFailedCodeV10 errorCode = QueueOpFailedCodeV10.forValue((int)code);
                    if (errorCode != null) {
                        OF10ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                default: {
                    OF10ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
            }
        } else {
            OF10ErrorMessageFactory.setUnknownCode(builder, code);
        }
    }

    private static void setUnknownCode(ErrorMessageBuilder builder, int readValue) {
        builder.setCode(Integer.valueOf(readValue));
        builder.setCodeString(UNKNOWN_CODE);
    }

    private static void setCode(ErrorMessageBuilder builder, int code, String codeString) {
        builder.setCode(Integer.valueOf(code));
        builder.setCodeString(codeString);
    }
}

