/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.ActionsDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.opendaylight.openflowjava.protocol.impl.util.InstructionsDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev100924.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ActionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.InstructionRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.InstructionRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NextTableRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.NextTableRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmRelatedTableFeatureProperty;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.OxmRelatedTableFeaturePropertyBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.table.features.properties.container.table.feature.properties.NextTableIds;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.table.features.properties.container.table.feature.properties.NextTableIdsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev130731.actions.ActionsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ActionType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupTypes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterBandTypeBitmap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartRequestFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MultipartType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesPropType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.MultipartReplyMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.buckets.BucketsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.MeterBand;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDropCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandDscpRemarkCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.MeterBandExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.drop._case.MeterBandDropBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.dscp.remark._case.MeterBandDscpRemarkBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.meter.band.header.meter.band.meter.band.experimenter._case.MeterBandExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.MultipartReplyBody;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyAggregateCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyExperimenterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyFlowCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyGroupFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterConfigCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyMeterFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortDescCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyPortStatsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.MultipartReplyTableFeaturesCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.aggregate._case.MultipartReplyAggregateBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.desc._case.MultipartReplyDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.experimenter._case.MultipartReplyExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.MultipartReplyFlowBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.flow._case.multipart.reply.flow.FlowStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.MultipartReplyGroupBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.GroupStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group._case.multipart.reply.group.group.stats.BucketStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.MultipartReplyGroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDesc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.desc._case.multipart.reply.group.desc.GroupDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.group.features._case.MultipartReplyGroupFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.MultipartReplyMeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.MeterStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter._case.multipart.reply.meter.meter.stats.MeterBandStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.MultipartReplyMeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.MeterConfigBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.Bands;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.config._case.multipart.reply.meter.config.meter.config.BandsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.meter.features._case.MultipartReplyMeterFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.MultipartReplyPortDescBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.Ports;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.desc._case.multipart.reply.port.desc.PortsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.MultipartReplyPortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.port.stats._case.multipart.reply.port.stats.PortStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.MultipartReplyQueueBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.queue._case.multipart.reply.queue.QueueStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.MultipartReplyTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStats;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table._case.multipart.reply.table.TableStatsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.MultipartReplyTableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeatures;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.multipart.reply.multipart.reply.body.multipart.reply.table.features._case.multipart.reply.table.features.TableFeaturesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeatureProperties;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.table.features.properties.TableFeaturePropertiesBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class MultipartReplyMessageFactory
implements OFDeserializer<MultipartReplyMessage> {
    private static final byte PADDING_IN_MULTIPART_REPLY_HEADER = 4;
    private static final int DESC_STR_LEN = 256;
    private static final int SERIAL_NUM_LEN = 32;
    private static final byte PADDING_IN_FLOW_STATS_HEADER_01 = 1;
    private static final byte PADDING_IN_FLOW_STATS_HEADER_02 = 4;
    private static final byte PADDING_IN_AGGREGATE_HEADER = 4;
    private static final byte PADDING_IN_TABLE_HEADER = 3;
    private static final byte PADDING_IN_MULTIPART_REPLY_TABLE_FEATURES = 5;
    private static final byte MAX_TABLE_NAME_LENGTH = 32;
    private static final byte MULTIPART_REPLY_TABLE_FEATURES_STRUCTURE_LENGTH = 64;
    private static final byte COMMON_PROPERTY_LENGTH = 4;
    private static final byte PADDING_IN_PORT_STATS_HEADER = 4;
    private static final byte PADDING_IN_GROUP_HEADER_01 = 2;
    private static final byte PADDING_IN_GROUP_HEADER_02 = 4;
    private static final byte BUCKET_COUNTER_LENGTH = 16;
    private static final byte GROUP_BODY_LENGTH = 40;
    private static final byte PADDING_IN_METER_FEATURES_HEADER = 2;
    private static final byte PADDING_IN_METER_STATS_HEADER = 6;
    private static final byte METER_BAND_STATS_LENGTH = 16;
    private static final byte METER_BODY_LENGTH = 40;
    private static final byte METER_CONFIG_LENGTH = 8;
    private static final byte PADDING_IN_METER_BAND_DROP_HEADER = 4;
    private static final byte PADDING_IN_METER_BAND_DSCP_HEADER = 3;
    private static final byte PADDING_IN_PORT_DESC_HEADER_01 = 4;
    private static final byte PADDING_IN_PORT_DESC_HEADER_02 = 2;
    private static final int GROUP_TYPES = 4;
    private static final byte PADDING_IN_GROUP_DESC_HEADER = 1;
    private static final byte PADDING_IN_BUCKETS_HEADER = 4;
    private static final byte GROUP_DESC_HEADER_LENGTH = 8;
    private static final byte BUCKETS_HEADER_LENGTH = 16;
    private static MultipartReplyMessageFactory instance;

    private MultipartReplyMessageFactory() {
    }

    public static synchronized MultipartReplyMessageFactory getInstance() {
        if (instance == null) {
            instance = new MultipartReplyMessageFactory();
        }
        return instance;
    }

    @Override
    public MultipartReplyMessage bufferToMessage(ByteBuf rawMessage, short version) {
        MultipartReplyMessageBuilder builder = new MultipartReplyMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        builder.setType(MultipartType.forValue((int)type));
        builder.setFlags(new MultipartRequestFlags(Boolean.valueOf((rawMessage.readUnsignedShort() & 1) != 0)));
        rawMessage.skipBytes(4);
        switch (type) {
            case 0: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setDesc(rawMessage));
                break;
            }
            case 1: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setFlow(rawMessage));
                break;
            }
            case 2: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setAggregate(rawMessage));
                break;
            }
            case 3: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setTable(rawMessage));
                break;
            }
            case 4: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setPortStats(rawMessage));
                break;
            }
            case 5: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setQueue(rawMessage));
                break;
            }
            case 6: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setGroup(rawMessage));
                break;
            }
            case 7: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setGroupDesc(rawMessage));
                break;
            }
            case 8: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setGroupFeatures(rawMessage));
                break;
            }
            case 9: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setMeter(rawMessage));
                break;
            }
            case 10: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setMeterConfig(rawMessage));
                break;
            }
            case 11: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setMeterFeatures(rawMessage));
                break;
            }
            case 12: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setTableFeatures(rawMessage));
                break;
            }
            case 13: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setPortDesc(rawMessage));
                break;
            }
            case 65535: {
                builder.setMultipartReplyBody((MultipartReplyBody)MultipartReplyMessageFactory.setExperimenter(rawMessage));
                break;
            }
        }
        return builder.build();
    }

    private static MultipartReplyDescCase setDesc(ByteBuf input) {
        MultipartReplyDescCaseBuilder caseBuilder = new MultipartReplyDescCaseBuilder();
        MultipartReplyDescBuilder descBuilder = new MultipartReplyDescBuilder();
        byte[] mfrDescBytes = new byte[256];
        input.readBytes(mfrDescBytes);
        String mfrDesc = new String(mfrDescBytes);
        descBuilder.setMfrDesc(mfrDesc.trim());
        byte[] hwDescBytes = new byte[256];
        input.readBytes(hwDescBytes);
        String hwDesc = new String(hwDescBytes);
        descBuilder.setHwDesc(hwDesc.trim());
        byte[] swDescBytes = new byte[256];
        input.readBytes(swDescBytes);
        String swDesc = new String(swDescBytes);
        descBuilder.setSwDesc(swDesc.trim());
        byte[] serialNumBytes = new byte[32];
        input.readBytes(serialNumBytes);
        String serialNum = new String(serialNumBytes);
        descBuilder.setSerialNum(serialNum.trim());
        byte[] dpDescBytes = new byte[256];
        input.readBytes(dpDescBytes);
        String dpDesc = new String(dpDescBytes);
        descBuilder.setDpDesc(dpDesc.trim());
        caseBuilder.setMultipartReplyDesc(descBuilder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyFlowCase setFlow(ByteBuf input) {
        MultipartReplyFlowCaseBuilder caseBuilder = new MultipartReplyFlowCaseBuilder();
        MultipartReplyFlowBuilder flowBuilder = new MultipartReplyFlowBuilder();
        ArrayList<FlowStats> flowStatsList = new ArrayList<FlowStats>();
        while (input.readableBytes() > 0) {
            FlowStatsBuilder flowStatsBuilder = new FlowStatsBuilder();
            int flowRecordLength = input.readUnsignedShort();
            ByteBuf subInput = input.readSlice(flowRecordLength - 2);
            flowStatsBuilder.setTableId(Short.valueOf(subInput.readUnsignedByte()));
            subInput.skipBytes(1);
            flowStatsBuilder.setDurationSec(Long.valueOf(subInput.readUnsignedInt()));
            flowStatsBuilder.setDurationNsec(Long.valueOf(subInput.readUnsignedInt()));
            flowStatsBuilder.setPriority(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setIdleTimeout(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setHardTimeout(Integer.valueOf(subInput.readUnsignedShort()));
            flowStatsBuilder.setFlags(MultipartReplyMessageFactory.createFlowModFlagsFromBitmap(subInput.readUnsignedShort()));
            subInput.skipBytes(4);
            byte[] cookie = new byte[8];
            subInput.readBytes(cookie);
            flowStatsBuilder.setCookie(new BigInteger(1, cookie));
            byte[] packetCount = new byte[8];
            subInput.readBytes(packetCount);
            flowStatsBuilder.setPacketCount(new BigInteger(1, packetCount));
            byte[] byteCount = new byte[8];
            subInput.readBytes(byteCount);
            flowStatsBuilder.setByteCount(new BigInteger(1, byteCount));
            flowStatsBuilder.setMatch(MatchDeserializer.createMatch(subInput));
            flowStatsBuilder.setInstructions(InstructionsDeserializer.createInstructions(subInput, subInput.readableBytes()));
            flowStatsList.add(flowStatsBuilder.build());
        }
        flowBuilder.setFlowStats(flowStatsList);
        caseBuilder.setMultipartReplyFlow(flowBuilder.build());
        return caseBuilder.build();
    }

    private static FlowModFlags createFlowModFlagsFromBitmap(int input) {
        Boolean _oFPFFSENDFLOWREM = (input & 1) != 0;
        Boolean _oFPFFCHECKOVERLAP = (input & 2) != 0;
        Boolean _oFPFFRESETCOUNTS = (input & 4) != 0;
        Boolean _oFPFFNOPKTCOUNTS = (input & 8) != 0;
        Boolean _oFPFFNOBYTCOUNTS = (input & 0x10) != 0;
        return new FlowModFlags(_oFPFFCHECKOVERLAP, _oFPFFNOBYTCOUNTS, _oFPFFNOPKTCOUNTS, _oFPFFRESETCOUNTS, _oFPFFSENDFLOWREM);
    }

    private static MultipartReplyAggregateCase setAggregate(ByteBuf input) {
        MultipartReplyAggregateCaseBuilder caseBuilder = new MultipartReplyAggregateCaseBuilder();
        MultipartReplyAggregateBuilder builder = new MultipartReplyAggregateBuilder();
        byte[] packetCount = new byte[8];
        input.readBytes(packetCount);
        builder.setPacketCount(new BigInteger(1, packetCount));
        byte[] byteCount = new byte[8];
        input.readBytes(byteCount);
        builder.setByteCount(new BigInteger(1, byteCount));
        builder.setFlowCount(Long.valueOf(input.readUnsignedInt()));
        input.skipBytes(4);
        caseBuilder.setMultipartReplyAggregate(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyTableCase setTable(ByteBuf input) {
        MultipartReplyTableCaseBuilder caseBuilder = new MultipartReplyTableCaseBuilder();
        MultipartReplyTableBuilder builder = new MultipartReplyTableBuilder();
        ArrayList<TableStats> tableStatsList = new ArrayList<TableStats>();
        while (input.readableBytes() > 0) {
            TableStatsBuilder tableStatsBuilder = new TableStatsBuilder();
            tableStatsBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
            input.skipBytes(3);
            tableStatsBuilder.setActiveCount(Long.valueOf(input.readUnsignedInt()));
            byte[] lookupCount = new byte[8];
            input.readBytes(lookupCount);
            tableStatsBuilder.setLookupCount(new BigInteger(1, lookupCount));
            byte[] matchedCount = new byte[8];
            input.readBytes(matchedCount);
            tableStatsBuilder.setMatchedCount(new BigInteger(1, matchedCount));
            tableStatsList.add(tableStatsBuilder.build());
        }
        builder.setTableStats(tableStatsList);
        caseBuilder.setMultipartReplyTable(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyTableFeaturesCase setTableFeatures(ByteBuf input) {
        MultipartReplyTableFeaturesCaseBuilder caseBuilder = new MultipartReplyTableFeaturesCaseBuilder();
        MultipartReplyTableFeaturesBuilder builder = new MultipartReplyTableFeaturesBuilder();
        ArrayList<TableFeatures> features = new ArrayList<TableFeatures>();
        while (input.readableBytes() > 0) {
            TableFeaturesBuilder featuresBuilder = new TableFeaturesBuilder();
            int length = input.readUnsignedShort();
            featuresBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
            input.skipBytes(5);
            featuresBuilder.setName(input.readBytes(32).toString());
            byte[] metadataMatch = new byte[8];
            input.readBytes(metadataMatch);
            featuresBuilder.setMetadataMatch(metadataMatch);
            byte[] metadataWrite = new byte[8];
            input.readBytes(metadataWrite);
            featuresBuilder.setMetadataWrite(metadataWrite);
            featuresBuilder.setConfig(MultipartReplyMessageFactory.createTableConfig(input.readUnsignedInt()));
            featuresBuilder.setMaxEntries(Long.valueOf(input.readUnsignedInt()));
            featuresBuilder.setTableFeatureProperties(MultipartReplyMessageFactory.createTableFeaturesProperties(input, length - 64));
            features.add(featuresBuilder.build());
        }
        builder.setTableFeatures(features);
        caseBuilder.setMultipartReplyTableFeatures(builder.build());
        return caseBuilder.build();
    }

    private static TableConfig createTableConfig(long input) {
        boolean deprecated = (input & 3L) != 0L;
        return new TableConfig(Boolean.valueOf(deprecated));
    }

    private static List<TableFeatureProperties> createTableFeaturesProperties(ByteBuf input, int length) {
        ArrayList<TableFeatureProperties> properties = new ArrayList<TableFeatureProperties>();
        int tableFeaturesLength = length;
        while (tableFeaturesLength > 0) {
            TableFeaturePropertiesBuilder builder = new TableFeaturePropertiesBuilder();
            TableFeaturesPropType type = TableFeaturesPropType.forValue((int)input.readUnsignedShort());
            builder.setType(type);
            int propertyLength = input.readUnsignedShort();
            int paddingRemainder = propertyLength % 8;
            tableFeaturesLength -= propertyLength;
            if (type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTINSTRUCTIONSMISS)) {
                InstructionRelatedTableFeaturePropertyBuilder insBuilder = new InstructionRelatedTableFeaturePropertyBuilder();
                insBuilder.setInstructions(InstructionsDeserializer.createInstructionIds(input, propertyLength - 4));
                builder.addAugmentation(InstructionRelatedTableFeatureProperty.class, (Augmentation)insBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLES) || type.equals((Object)TableFeaturesPropType.OFPTFPTNEXTTABLESMISS)) {
                propertyLength -= 4;
                NextTableRelatedTableFeaturePropertyBuilder tableBuilder = new NextTableRelatedTableFeaturePropertyBuilder();
                ArrayList<NextTableIds> ids = new ArrayList<NextTableIds>();
                while (propertyLength > 0) {
                    NextTableIdsBuilder nextTableIdsBuilder = new NextTableIdsBuilder();
                    nextTableIdsBuilder.setTableId(Short.valueOf(input.readUnsignedByte()));
                    ids.add(nextTableIdsBuilder.build());
                    --propertyLength;
                }
                tableBuilder.setNextTableIds(ids);
                builder.addAugmentation(NextTableRelatedTableFeatureProperty.class, (Augmentation)tableBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITEACTIONSMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYACTIONSMISS)) {
                ActionRelatedTableFeaturePropertyBuilder actionBuilder = new ActionRelatedTableFeaturePropertyBuilder();
                actionBuilder.setActionsList(ActionsDeserializer.createActionIds(input, propertyLength - 4));
                builder.addAugmentation(ActionRelatedTableFeatureProperty.class, (Augmentation)actionBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTMATCH) || type.equals((Object)TableFeaturesPropType.OFPTFPTWILDCARDS) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTWRITESETFIELDMISS) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELD) || type.equals((Object)TableFeaturesPropType.OFPTFPTAPPLYSETFIELDMISS)) {
                OxmRelatedTableFeaturePropertyBuilder oxmBuilder = new OxmRelatedTableFeaturePropertyBuilder();
                oxmBuilder.setMatchEntries(MatchDeserializer.createMatchIds(input, propertyLength - 4));
                builder.addAugmentation(OxmRelatedTableFeatureProperty.class, (Augmentation)oxmBuilder.build());
            } else if (type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTER) || type.equals((Object)TableFeaturesPropType.OFPTFPTEXPERIMENTERMISS)) {
                ExperimenterRelatedTableFeaturePropertyBuilder expBuilder = new ExperimenterRelatedTableFeaturePropertyBuilder();
                expBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                expBuilder.setExpType(Long.valueOf(input.readUnsignedInt()));
                int dataLength = propertyLength - 4 - 8;
                if (dataLength > 0) {
                    byte[] data = new byte[dataLength];
                    input.readBytes(data);
                    expBuilder.setData(data);
                }
                builder.addAugmentation(ExperimenterRelatedTableFeatureProperty.class, (Augmentation)expBuilder.build());
            }
            if (paddingRemainder != 0) {
                input.skipBytes(8 - paddingRemainder);
                tableFeaturesLength -= 8 - paddingRemainder;
            }
            properties.add(builder.build());
        }
        return properties;
    }

    private static MultipartReplyPortStatsCase setPortStats(ByteBuf input) {
        MultipartReplyPortStatsCaseBuilder caseBuilder = new MultipartReplyPortStatsCaseBuilder();
        MultipartReplyPortStatsBuilder builder = new MultipartReplyPortStatsBuilder();
        ArrayList<PortStats> portStatsList = new ArrayList<PortStats>();
        while (input.readableBytes() > 0) {
            PortStatsBuilder portStatsBuilder = new PortStatsBuilder();
            portStatsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] rxPackets = new byte[8];
            input.readBytes(rxPackets);
            portStatsBuilder.setRxPackets(new BigInteger(1, rxPackets));
            byte[] txPackets = new byte[8];
            input.readBytes(txPackets);
            portStatsBuilder.setTxPackets(new BigInteger(1, txPackets));
            byte[] rxBytes = new byte[8];
            input.readBytes(rxBytes);
            portStatsBuilder.setRxBytes(new BigInteger(1, rxBytes));
            byte[] txBytes = new byte[8];
            input.readBytes(txBytes);
            portStatsBuilder.setTxBytes(new BigInteger(1, txBytes));
            byte[] rxDropped = new byte[8];
            input.readBytes(rxDropped);
            portStatsBuilder.setRxDropped(new BigInteger(1, rxDropped));
            byte[] txDropped = new byte[8];
            input.readBytes(txDropped);
            portStatsBuilder.setTxDropped(new BigInteger(1, txDropped));
            byte[] rxErrors = new byte[8];
            input.readBytes(rxErrors);
            portStatsBuilder.setRxErrors(new BigInteger(1, rxErrors));
            byte[] txErrors = new byte[8];
            input.readBytes(txErrors);
            portStatsBuilder.setTxErrors(new BigInteger(1, txErrors));
            byte[] rxFrameErr = new byte[8];
            input.readBytes(rxFrameErr);
            portStatsBuilder.setRxFrameErr(new BigInteger(1, rxFrameErr));
            byte[] rxOverErr = new byte[8];
            input.readBytes(rxOverErr);
            portStatsBuilder.setRxOverErr(new BigInteger(1, rxOverErr));
            byte[] rxCrcErr = new byte[8];
            input.readBytes(rxCrcErr);
            portStatsBuilder.setRxCrcErr(new BigInteger(1, rxCrcErr));
            byte[] collisions = new byte[8];
            input.readBytes(collisions);
            portStatsBuilder.setCollisions(new BigInteger(1, collisions));
            portStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            portStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            portStatsList.add(portStatsBuilder.build());
        }
        builder.setPortStats(portStatsList);
        caseBuilder.setMultipartReplyPortStats(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyQueueCase setQueue(ByteBuf input) {
        MultipartReplyQueueCaseBuilder caseBuilder = new MultipartReplyQueueCaseBuilder();
        MultipartReplyQueueBuilder builder = new MultipartReplyQueueBuilder();
        ArrayList<QueueStats> queueStatsList = new ArrayList<QueueStats>();
        while (input.readableBytes() > 0) {
            QueueStatsBuilder queueStatsBuilder = new QueueStatsBuilder();
            queueStatsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            queueStatsBuilder.setQueueId(Long.valueOf(input.readUnsignedInt()));
            byte[] txBytes = new byte[8];
            input.readBytes(txBytes);
            queueStatsBuilder.setTxBytes(new BigInteger(1, txBytes));
            byte[] txPackets = new byte[8];
            input.readBytes(txPackets);
            queueStatsBuilder.setTxPackets(new BigInteger(1, txPackets));
            byte[] txErrors = new byte[8];
            input.readBytes(txErrors);
            queueStatsBuilder.setTxErrors(new BigInteger(1, txErrors));
            queueStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            queueStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            queueStatsList.add(queueStatsBuilder.build());
        }
        builder.setQueueStats(queueStatsList);
        caseBuilder.setMultipartReplyQueue(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyGroupCase setGroup(ByteBuf input) {
        MultipartReplyGroupCaseBuilder caseBuilder = new MultipartReplyGroupCaseBuilder();
        MultipartReplyGroupBuilder builder = new MultipartReplyGroupBuilder();
        ArrayList<GroupStats> groupStatsList = new ArrayList<GroupStats>();
        while (input.readableBytes() > 0) {
            GroupStatsBuilder groupStatsBuilder = new GroupStatsBuilder();
            int bodyLength = input.readUnsignedShort();
            input.skipBytes(2);
            groupStatsBuilder.setGroupId(new GroupId(Long.valueOf(input.readUnsignedInt())));
            groupStatsBuilder.setRefCount(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] packetCount = new byte[8];
            input.readBytes(packetCount);
            groupStatsBuilder.setPacketCount(new BigInteger(1, packetCount));
            byte[] byteCount = new byte[8];
            input.readBytes(byteCount);
            groupStatsBuilder.setByteCount(new BigInteger(1, byteCount));
            groupStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            groupStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            ArrayList<BucketStats> bucketStatsList = new ArrayList<BucketStats>();
            for (int actualLength = 40; actualLength < bodyLength; actualLength += 16) {
                BucketStatsBuilder bucketStatsBuilder = new BucketStatsBuilder();
                byte[] packetCountBucket = new byte[8];
                input.readBytes(packetCountBucket);
                bucketStatsBuilder.setPacketCount(new BigInteger(1, packetCountBucket));
                byte[] byteCountBucket = new byte[8];
                input.readBytes(byteCountBucket);
                bucketStatsBuilder.setByteCount(new BigInteger(1, byteCountBucket));
                bucketStatsList.add(bucketStatsBuilder.build());
            }
            groupStatsBuilder.setBucketStats(bucketStatsList);
            groupStatsList.add(groupStatsBuilder.build());
        }
        builder.setGroupStats(groupStatsList);
        caseBuilder.setMultipartReplyGroup(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyMeterFeaturesCase setMeterFeatures(ByteBuf input) {
        MultipartReplyMeterFeaturesCaseBuilder caseBuilder = new MultipartReplyMeterFeaturesCaseBuilder();
        MultipartReplyMeterFeaturesBuilder builder = new MultipartReplyMeterFeaturesBuilder();
        builder.setMaxMeter(Long.valueOf(input.readUnsignedInt()));
        builder.setBandTypes(MultipartReplyMessageFactory.createMeterBandsBitmap(input.readUnsignedInt()));
        builder.setCapabilities(MultipartReplyMessageFactory.createMeterFlags(input.readUnsignedInt()));
        builder.setMaxBands(Short.valueOf(input.readUnsignedByte()));
        builder.setMaxColor(Short.valueOf(input.readUnsignedByte()));
        input.skipBytes(2);
        caseBuilder.setMultipartReplyMeterFeatures(builder.build());
        return caseBuilder.build();
    }

    private static MeterFlags createMeterFlags(long input) {
        Boolean _oFPMFKBPS = (input & 1L) != 0L;
        Boolean _oFPMFPKTPS = (input & 2L) != 0L;
        Boolean _oFPMFBURST = (input & 4L) != 0L;
        Boolean _oFPMFSTATS = (input & 8L) != 0L;
        return new MeterFlags(_oFPMFBURST, _oFPMFKBPS, _oFPMFPKTPS, _oFPMFSTATS);
    }

    private static MeterBandTypeBitmap createMeterBandsBitmap(long input) {
        Boolean _oFPMBTDROP = (input & 1L) != 0L;
        Boolean _oFPMBTDSCPREMARK = (input & 2L) != 0L;
        return new MeterBandTypeBitmap(_oFPMBTDROP, _oFPMBTDSCPREMARK);
    }

    private static MultipartReplyMeterCase setMeter(ByteBuf input) {
        MultipartReplyMeterCaseBuilder caseBuilder = new MultipartReplyMeterCaseBuilder();
        MultipartReplyMeterBuilder builder = new MultipartReplyMeterBuilder();
        ArrayList<MeterStats> meterStatsList = new ArrayList<MeterStats>();
        while (input.readableBytes() > 0) {
            MeterStatsBuilder meterStatsBuilder = new MeterStatsBuilder();
            meterStatsBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
            int meterStatsBodyLength = input.readUnsignedShort();
            input.skipBytes(6);
            meterStatsBuilder.setFlowCount(Long.valueOf(input.readUnsignedInt()));
            byte[] packetInCount = new byte[8];
            input.readBytes(packetInCount);
            meterStatsBuilder.setPacketInCount(new BigInteger(1, packetInCount));
            byte[] byteInCount = new byte[8];
            input.readBytes(byteInCount);
            meterStatsBuilder.setByteInCount(new BigInteger(1, byteInCount));
            meterStatsBuilder.setDurationSec(Long.valueOf(input.readUnsignedInt()));
            meterStatsBuilder.setDurationNsec(Long.valueOf(input.readUnsignedInt()));
            ArrayList<MeterBandStats> meterBandStatsList = new ArrayList<MeterBandStats>();
            for (int actualLength = 40; actualLength < meterStatsBodyLength; actualLength += 16) {
                MeterBandStatsBuilder meterBandStatsBuilder = new MeterBandStatsBuilder();
                byte[] packetBandCount = new byte[8];
                input.readBytes(packetBandCount);
                meterBandStatsBuilder.setPacketBandCount(new BigInteger(1, packetBandCount));
                byte[] byteBandCount = new byte[8];
                input.readBytes(byteBandCount);
                meterBandStatsBuilder.setByteBandCount(new BigInteger(1, byteBandCount));
                meterBandStatsList.add(meterBandStatsBuilder.build());
            }
            meterStatsBuilder.setMeterBandStats(meterBandStatsList);
            meterStatsList.add(meterStatsBuilder.build());
        }
        builder.setMeterStats(meterStatsList);
        caseBuilder.setMultipartReplyMeter(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyMeterConfigCase setMeterConfig(ByteBuf input) {
        MultipartReplyMeterConfigCaseBuilder caseBuilder = new MultipartReplyMeterConfigCaseBuilder();
        MultipartReplyMeterConfigBuilder builder = new MultipartReplyMeterConfigBuilder();
        ArrayList<MeterConfig> meterConfigList = new ArrayList<MeterConfig>();
        while (input.readableBytes() > 0) {
            MeterConfigBuilder meterConfigBuilder = new MeterConfigBuilder();
            int meterConfigBodyLength = input.readUnsignedShort();
            meterConfigBuilder.setFlags(MultipartReplyMessageFactory.createMeterFlags(input.readUnsignedShort()));
            meterConfigBuilder.setMeterId(new MeterId(Long.valueOf(input.readUnsignedInt())));
            int actualLength = 8;
            ArrayList<Bands> bandsList = new ArrayList<Bands>();
            while (actualLength < meterConfigBodyLength) {
                BandsBuilder bandsBuilder = new BandsBuilder();
                int bandType = input.readUnsignedShort();
                switch (bandType) {
                    case 1: {
                        MeterBandDropCaseBuilder bandDropCaseBuilder = new MeterBandDropCaseBuilder();
                        MeterBandDropBuilder bandDropBuilder = new MeterBandDropBuilder();
                        bandDropBuilder.setType(MeterBandType.forValue((int)bandType));
                        actualLength += input.readUnsignedShort();
                        bandDropBuilder.setRate(Long.valueOf(input.readUnsignedInt()));
                        bandDropBuilder.setBurstSize(Long.valueOf(input.readUnsignedInt()));
                        input.skipBytes(4);
                        bandDropCaseBuilder.setMeterBandDrop(bandDropBuilder.build());
                        bandsBuilder.setMeterBand((MeterBand)bandDropCaseBuilder.build());
                        break;
                    }
                    case 2: {
                        MeterBandDscpRemarkCaseBuilder bandDscpRemarkCaseBuilder = new MeterBandDscpRemarkCaseBuilder();
                        MeterBandDscpRemarkBuilder bandDscpRemarkBuilder = new MeterBandDscpRemarkBuilder();
                        bandDscpRemarkBuilder.setType(MeterBandType.forValue((int)bandType));
                        actualLength += input.readUnsignedShort();
                        bandDscpRemarkBuilder.setRate(Long.valueOf(input.readUnsignedInt()));
                        bandDscpRemarkBuilder.setBurstSize(Long.valueOf(input.readUnsignedInt()));
                        bandDscpRemarkBuilder.setPrecLevel(Short.valueOf(input.readUnsignedByte()));
                        input.skipBytes(3);
                        bandDscpRemarkCaseBuilder.setMeterBandDscpRemark(bandDscpRemarkBuilder.build());
                        bandsBuilder.setMeterBand((MeterBand)bandDscpRemarkCaseBuilder.build());
                        break;
                    }
                    case 65535: {
                        MeterBandExperimenterCaseBuilder bandExperimenterCaseBuilder = new MeterBandExperimenterCaseBuilder();
                        MeterBandExperimenterBuilder bandExperimenterBuilder = new MeterBandExperimenterBuilder();
                        bandExperimenterBuilder.setType(MeterBandType.forValue((int)bandType));
                        actualLength += input.readUnsignedShort();
                        bandExperimenterBuilder.setRate(Long.valueOf(input.readUnsignedInt()));
                        bandExperimenterBuilder.setBurstSize(Long.valueOf(input.readUnsignedInt()));
                        bandExperimenterBuilder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
                        bandExperimenterCaseBuilder.setMeterBandExperimenter(bandExperimenterBuilder.build());
                        bandsBuilder.setMeterBand((MeterBand)bandExperimenterCaseBuilder.build());
                        break;
                    }
                }
                bandsList.add(bandsBuilder.build());
            }
            meterConfigBuilder.setBands(bandsList);
            meterConfigList.add(meterConfigBuilder.build());
        }
        builder.setMeterConfig(meterConfigList);
        caseBuilder.setMultipartReplyMeterConfig(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyExperimenterCase setExperimenter(ByteBuf input) {
        MultipartReplyExperimenterCaseBuilder caseBuilder = new MultipartReplyExperimenterCaseBuilder();
        MultipartReplyExperimenterBuilder builder = new MultipartReplyExperimenterBuilder();
        builder.setExperimenter(Long.valueOf(input.readUnsignedInt()));
        builder.setExpType(Long.valueOf(input.readUnsignedInt()));
        byte[] data = new byte[input.readableBytes()];
        input.readBytes(data);
        builder.setData(data);
        caseBuilder.setMultipartReplyExperimenter(builder.build());
        return caseBuilder.build();
    }

    private static MultipartReplyPortDescCase setPortDesc(ByteBuf input) {
        MultipartReplyPortDescCaseBuilder caseBuilder = new MultipartReplyPortDescCaseBuilder();
        MultipartReplyPortDescBuilder builder = new MultipartReplyPortDescBuilder();
        ArrayList<Ports> portsList = new ArrayList<Ports>();
        while (input.readableBytes() > 0) {
            PortsBuilder portsBuilder = new PortsBuilder();
            portsBuilder.setPortNo(Long.valueOf(input.readUnsignedInt()));
            input.skipBytes(4);
            byte[] hwAddress = new byte[6];
            input.readBytes(hwAddress);
            portsBuilder.setHwAddr(new MacAddress(ByteBufUtils.macAddressToString(hwAddress)));
            input.skipBytes(2);
            portsBuilder.setName(ByteBufUtils.decodeNullTerminatedString(input, 16));
            portsBuilder.setConfig(MultipartReplyMessageFactory.createPortConfig(input.readUnsignedInt()));
            portsBuilder.setState(MultipartReplyMessageFactory.createPortState(input.readUnsignedInt()));
            portsBuilder.setCurrentFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setAdvertisedFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setSupportedFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setPeerFeatures(MultipartReplyMessageFactory.createPortFeatures(input.readUnsignedInt()));
            portsBuilder.setCurrSpeed(Long.valueOf(input.readUnsignedInt()));
            portsBuilder.setMaxSpeed(Long.valueOf(input.readUnsignedInt()));
            portsList.add(portsBuilder.build());
        }
        builder.setPorts(portsList);
        caseBuilder.setMultipartReplyPortDesc(builder.build());
        return caseBuilder.build();
    }

    private static PortConfig createPortConfig(long input) {
        Boolean _portDown = (input & 1L) != 0L;
        Boolean _noRecv = (input & 4L) != 0L;
        Boolean _noFwd = (input & 0x20L) != 0L;
        Boolean _noPacketIn = (input & 0x40L) != 0L;
        return new PortConfig(_noFwd, _noPacketIn, _noRecv, _portDown);
    }

    private static PortState createPortState(long input) {
        Boolean _linkDown = (input & 1L) != 0L;
        Boolean _blocked = (input & 2L) != 0L;
        Boolean _live = (input & 4L) != 0L;
        return new PortState(_blocked, _linkDown, _live);
    }

    private static PortFeatures createPortFeatures(long input) {
        Boolean _10mbHd = (input & 1L) != 0L;
        Boolean _10mbFd = (input & 2L) != 0L;
        Boolean _100mbHd = (input & 4L) != 0L;
        Boolean _100mbFd = (input & 8L) != 0L;
        Boolean _1gbHd = (input & 0x10L) != 0L;
        Boolean _1gbFd = (input & 0x20L) != 0L;
        Boolean _10gbFd = (input & 0x40L) != 0L;
        Boolean _40gbFd = (input & 0x80L) != 0L;
        Boolean _100gbFd = (input & 0x100L) != 0L;
        Boolean _1tbFd = (input & 0x200L) != 0L;
        Boolean _other = (input & 0x400L) != 0L;
        Boolean _copper = (input & 0x800L) != 0L;
        Boolean _fiber = (input & 0x1000L) != 0L;
        Boolean _autoneg = (input & 0x2000L) != 0L;
        Boolean _pause = (input & 0x4000L) != 0L;
        Boolean _pauseAsym = (input & 0x8000L) != 0L;
        return new PortFeatures(_100gbFd, _100mbFd, _100mbHd, _10gbFd, _10mbFd, _10mbHd, _1gbFd, _1gbHd, _1tbFd, _40gbFd, _autoneg, _copper, _fiber, _other, _pause, _pauseAsym);
    }

    private static MultipartReplyGroupFeaturesCase setGroupFeatures(ByteBuf rawMessage) {
        MultipartReplyGroupFeaturesCaseBuilder caseBuilder = new MultipartReplyGroupFeaturesCaseBuilder();
        MultipartReplyGroupFeaturesBuilder featuresBuilder = new MultipartReplyGroupFeaturesBuilder();
        featuresBuilder.setTypes(MultipartReplyMessageFactory.createGroupType(rawMessage.readUnsignedInt()));
        featuresBuilder.setCapabilities(MultipartReplyMessageFactory.createCapabilities(rawMessage.readUnsignedInt()));
        ArrayList<Long> maxGroupsList = new ArrayList<Long>();
        for (int i = 0; i < 4; ++i) {
            maxGroupsList.add(rawMessage.readUnsignedInt());
        }
        featuresBuilder.setMaxGroups(maxGroupsList);
        ArrayList<ActionType> actionBitmaps = new ArrayList<ActionType>();
        for (int i = 0; i < 4; ++i) {
            actionBitmaps.add(MultipartReplyMessageFactory.createActionBitmap(rawMessage.readUnsignedInt()));
        }
        featuresBuilder.setActionsBitmap(actionBitmaps);
        caseBuilder.setMultipartReplyGroupFeatures(featuresBuilder.build());
        return caseBuilder.build();
    }

    private static ActionType createActionBitmap(long input) {
        Boolean OFPAT_OUTPUT = (input & 1L) != 0L;
        Boolean OFPAT_COPY_TTL_OUT = (input & 2L) != 0L;
        Boolean OFPAT_COPY_TTL_IN = (input & 4L) != 0L;
        Boolean OFPAT_SET_MPLS_TTL = (input & 8L) != 0L;
        Boolean OFPAT_DEC_MPLS_TTL = (input & 0x10L) != 0L;
        Boolean OFPAT_PUSH_VLAN = (input & 0x20L) != 0L;
        Boolean OFPAT_POP_VLAN = (input & 0x40L) != 0L;
        Boolean OFPAT_PUSH_MPLS = (input & 0x80L) != 0L;
        Boolean OFPAT_POP_MPLS = (input & 0x100L) != 0L;
        Boolean OFPAT_SET_QUEUE = (input & 0x200L) != 0L;
        Boolean OFPAT_GROUP = (input & 0x400L) != 0L;
        Boolean OFPAT_SET_NW_TTL = (input & 0x800L) != 0L;
        Boolean OFPAT_DEC_NW_TTL = (input & 0x1000L) != 0L;
        Boolean OFPAT_SET_FIELD = (input & 0x2000L) != 0L;
        Boolean OFPAT_PUSH_PBB = (input & 0x4000L) != 0L;
        Boolean OFPAT_POP_PBB = (input & 0x8000L) != 0L;
        Boolean OFPAT_EXPERIMENTER = (input & 0x10000L) != 0L;
        return new ActionType(OFPAT_COPY_TTL_IN, OFPAT_COPY_TTL_OUT, OFPAT_DEC_MPLS_TTL, OFPAT_DEC_NW_TTL, OFPAT_EXPERIMENTER, OFPAT_GROUP, OFPAT_OUTPUT, OFPAT_POP_MPLS, OFPAT_POP_PBB, OFPAT_POP_VLAN, OFPAT_PUSH_MPLS, OFPAT_PUSH_PBB, OFPAT_PUSH_VLAN, OFPAT_SET_FIELD, OFPAT_SET_MPLS_TTL, OFPAT_SET_NW_TTL, OFPAT_SET_QUEUE);
    }

    private static GroupCapabilities createCapabilities(long input) {
        Boolean OFOFPGFC_SELECT_WEIGHT = (input & 1L) != 0L;
        Boolean OFPGFC_SELECT_LIVENESS = (input & 2L) != 0L;
        Boolean OFPGFC_CHAINING = (input & 4L) != 0L;
        Boolean OFPGFC_CHAINING_CHECKS = (input & 8L) != 0L;
        return new GroupCapabilities(OFPGFC_CHAINING, OFPGFC_CHAINING_CHECKS, OFPGFC_SELECT_LIVENESS, OFOFPGFC_SELECT_WEIGHT);
    }

    private static GroupTypes createGroupType(long input) {
        Boolean OFPGT_ALL = (input & 1L) != 0L;
        Boolean OFPGT_SELECT = (input & 2L) != 0L;
        Boolean OFPGT_INDIRECT = (input & 4L) != 0L;
        Boolean OFPGT_FF = (input & 8L) != 0L;
        return new GroupTypes(OFPGT_ALL, OFPGT_FF, OFPGT_INDIRECT, OFPGT_SELECT);
    }

    private static MultipartReplyGroupDescCase setGroupDesc(ByteBuf input) {
        MultipartReplyGroupDescCaseBuilder caseBuilder = new MultipartReplyGroupDescCaseBuilder();
        MultipartReplyGroupDescBuilder builder = new MultipartReplyGroupDescBuilder();
        ArrayList<GroupDesc> groupDescsList = new ArrayList<GroupDesc>();
        while (input.readableBytes() > 0) {
            int bucketsLength;
            GroupDescBuilder groupDescBuilder = new GroupDescBuilder();
            int bodyLength = input.readUnsignedShort();
            groupDescBuilder.setType(GroupType.forValue((int)input.readUnsignedByte()));
            input.skipBytes(1);
            groupDescBuilder.setGroupId(new GroupId(Long.valueOf(input.readUnsignedInt())));
            ArrayList<BucketsList> bucketsList = new ArrayList<BucketsList>();
            for (int actualLength = 8; actualLength < bodyLength; actualLength += bucketsLength) {
                BucketsListBuilder bucketsBuilder = new BucketsListBuilder();
                bucketsLength = input.readUnsignedShort();
                bucketsBuilder.setWeight(Integer.valueOf(input.readUnsignedShort()));
                bucketsBuilder.setWatchPort(new PortNumber(Long.valueOf(input.readUnsignedInt())));
                bucketsBuilder.setWatchGroup(Long.valueOf(input.readUnsignedInt()));
                input.skipBytes(4);
                List<ActionsList> actionsList = ActionsDeserializer.createActionsList(input, bucketsLength - 16);
                bucketsBuilder.setActionsList(actionsList);
                bucketsList.add(bucketsBuilder.build());
            }
            groupDescBuilder.setBucketsList(bucketsList);
            groupDescsList.add(groupDescBuilder.build());
        }
        builder.setGroupDesc(groupDescsList);
        caseBuilder.setMultipartReplyGroupDesc(builder.build());
        return caseBuilder.build();
    }
}

