/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PacketInReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.GetAsyncOutputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.FlowRemovedMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PacketInMaskBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMask;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.async.body.grouping.PortStatusMaskBuilder;

public class GetAsyncReplyMessageFactory
implements OFDeserializer<GetAsyncOutput> {
    private static GetAsyncReplyMessageFactory instance;
    private static final byte SEPARATE_ROLES = 2;

    private GetAsyncReplyMessageFactory() {
    }

    public static synchronized GetAsyncReplyMessageFactory getInstance() {
        if (instance == null) {
            instance = new GetAsyncReplyMessageFactory();
        }
        return instance;
    }

    @Override
    public GetAsyncOutput bufferToMessage(ByteBuf rawMessage, short version) {
        GetAsyncOutputBuilder builder = new GetAsyncOutputBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setPacketInMask(GetAsyncReplyMessageFactory.decodePacketInMask(rawMessage));
        builder.setPortStatusMask(GetAsyncReplyMessageFactory.decodePortStatusMask(rawMessage));
        builder.setFlowRemovedMask(GetAsyncReplyMessageFactory.decodeFlowRemovedMask(rawMessage));
        return builder.build();
    }

    private static List<PacketInMask> decodePacketInMask(ByteBuf input) {
        ArrayList<PacketInMask> inMasks = new ArrayList<PacketInMask>();
        for (int i = 0; i < 2; ++i) {
            PacketInMaskBuilder maskBuilder = new PacketInMaskBuilder();
            maskBuilder.setMask(GetAsyncReplyMessageFactory.decodePacketInReasons(input.readUnsignedInt()));
            inMasks.add(maskBuilder.build());
        }
        return inMasks;
    }

    private static List<PortStatusMask> decodePortStatusMask(ByteBuf input) {
        ArrayList<PortStatusMask> inMasks = new ArrayList<PortStatusMask>();
        for (int i = 0; i < 2; ++i) {
            PortStatusMaskBuilder maskBuilder = new PortStatusMaskBuilder();
            maskBuilder.setMask(GetAsyncReplyMessageFactory.decodePortReasons(input.readUnsignedInt()));
            inMasks.add(maskBuilder.build());
        }
        return inMasks;
    }

    private static List<FlowRemovedMask> decodeFlowRemovedMask(ByteBuf input) {
        ArrayList<FlowRemovedMask> inMasks = new ArrayList<FlowRemovedMask>();
        for (int i = 0; i < 2; ++i) {
            FlowRemovedMaskBuilder maskBuilder = new FlowRemovedMaskBuilder();
            maskBuilder.setMask(GetAsyncReplyMessageFactory.decodeFlowRemovedReasons(input.readUnsignedInt()));
            inMasks.add(maskBuilder.build());
        }
        return inMasks;
    }

    private static List<PacketInReason> decodePacketInReasons(long input) {
        ArrayList<PacketInReason> reasons = new ArrayList<PacketInReason>();
        if ((input & 1L) != 0L) {
            reasons.add(PacketInReason.OFPRNOMATCH);
        }
        if ((input & 2L) != 0L) {
            reasons.add(PacketInReason.OFPRACTION);
        }
        if ((input & 4L) != 0L) {
            reasons.add(PacketInReason.OFPRINVALIDTTL);
        }
        return reasons;
    }

    private static List<PortReason> decodePortReasons(long input) {
        ArrayList<PortReason> reasons = new ArrayList<PortReason>();
        if ((input & 1L) != 0L) {
            reasons.add(PortReason.OFPPRADD);
        }
        if ((input & 2L) != 0L) {
            reasons.add(PortReason.OFPPRDELETE);
        }
        if ((input & 4L) != 0L) {
            reasons.add(PortReason.OFPPRMODIFY);
        }
        return reasons;
    }

    private static List<FlowRemovedReason> decodeFlowRemovedReasons(long input) {
        ArrayList<FlowRemovedReason> reasons = new ArrayList<FlowRemovedReason>();
        if ((input & 1L) != 0L) {
            reasons.add(FlowRemovedReason.OFPRRIDLETIMEOUT);
        }
        if ((input & 2L) != 0L) {
            reasons.add(FlowRemovedReason.OFPRRHARDTIMEOUT);
        }
        if ((input & 4L) != 0L) {
            reasons.add(FlowRemovedReason.OFPRRDELETE);
        }
        if ((input & 8L) != 0L) {
            reasons.add(FlowRemovedReason.OFPRRGROUPDELETE);
        }
        return reasons;
    }
}

