/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.util.MatchDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowRemovedReason;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.FlowRemovedMessageBuilder;

public class FlowRemovedMessageFactory
implements OFDeserializer<FlowRemovedMessage> {
    private static FlowRemovedMessageFactory instance;

    private FlowRemovedMessageFactory() {
    }

    public static synchronized FlowRemovedMessageFactory getInstance() {
        if (instance == null) {
            instance = new FlowRemovedMessageFactory();
        }
        return instance;
    }

    @Override
    public FlowRemovedMessage bufferToMessage(ByteBuf rawMessage, short version) {
        FlowRemovedMessageBuilder builder = new FlowRemovedMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        byte[] cookie = new byte[8];
        rawMessage.readBytes(cookie);
        builder.setCookie(new BigInteger(1, cookie));
        builder.setPriority(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setReason(FlowRemovedReason.forValue((int)rawMessage.readUnsignedByte()));
        builder.setTableId(new TableId(Long.valueOf(rawMessage.readUnsignedByte())));
        builder.setDurationSec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setDurationNsec(Long.valueOf(rawMessage.readUnsignedInt()));
        builder.setIdleTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        builder.setHardTimeout(Integer.valueOf(rawMessage.readUnsignedShort()));
        byte[] packet_count = new byte[8];
        rawMessage.readBytes(packet_count);
        builder.setPacketCount(new BigInteger(1, packet_count));
        byte[] byte_count = new byte[8];
        rawMessage.readBytes(byte_count);
        builder.setByteCount(new BigInteger(1, byte_count));
        builder.setMatch(MatchDeserializer.createMatch(rawMessage));
        return builder.build();
    }
}

