/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization.factories;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev131002.ExperimenterErrorBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadActionCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadInstructionCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadMatchCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.BadRequestCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.FlowModFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.GroupModFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.HelloFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.MeterModFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortModFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.QueueOpFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.RoleRequestFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.SwitchConfigFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableFeaturesFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.TableModFailedCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.protocol.rev130731.ErrorMessageBuilder;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ErrorMessageFactory
implements OFDeserializer<ErrorMessage> {
    private static final String UNKNOWN_CODE = "UNKNOWN_CODE";
    private static final String UNKNOWN_TYPE = "UNKNOWN_TYPE";
    private static ErrorMessageFactory instance;

    private ErrorMessageFactory() {
    }

    public static synchronized ErrorMessageFactory getInstance() {
        if (instance == null) {
            instance = new ErrorMessageFactory();
        }
        return instance;
    }

    @Override
    public ErrorMessage bufferToMessage(ByteBuf rawMessage, short version) {
        ErrorMessageBuilder builder = new ErrorMessageBuilder();
        builder.setVersion(Short.valueOf(version));
        builder.setXid(Long.valueOf(rawMessage.readUnsignedInt()));
        int type = rawMessage.readUnsignedShort();
        ErrorType errorType = ErrorType.forValue((int)type);
        ErrorMessageFactory.decodeType(builder, errorType, type);
        ErrorMessageFactory.decodeCode(rawMessage, builder, errorType);
        if (rawMessage.readableBytes() > 0) {
            builder.setData(rawMessage.readBytes(rawMessage.readableBytes()).array());
        }
        return builder.build();
    }

    private static void decodeType(ErrorMessageBuilder builder, ErrorType type, int readValue) {
        if (type != null) {
            builder.setType(Integer.valueOf(type.getIntValue()));
            builder.setTypeString(type.name());
        } else {
            builder.setType(Integer.valueOf(readValue));
            builder.setTypeString(UNKNOWN_TYPE);
        }
    }

    private static void decodeCode(ByteBuf rawMessage, ErrorMessageBuilder builder, ErrorType type) {
        int code = rawMessage.readUnsignedShort();
        if (type != null) {
            switch (type) {
                case HELLOFAILED: {
                    HelloFailedCode errorCode = HelloFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADREQUEST: {
                    BadRequestCode errorCode = BadRequestCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADACTION: {
                    BadActionCode errorCode = BadActionCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADINSTRUCTION: {
                    BadInstructionCode errorCode = BadInstructionCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case BADMATCH: {
                    BadMatchCode errorCode = BadMatchCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case FLOWMODFAILED: {
                    FlowModFailedCode errorCode = FlowModFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case GROUPMODFAILED: {
                    GroupModFailedCode errorCode = GroupModFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case PORTMODFAILED: {
                    PortModFailedCode errorCode = PortModFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case TABLEMODFAILED: {
                    TableModFailedCode errorCode = TableModFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case QUEUEOPFAILED: {
                    QueueOpFailedCode errorCode = QueueOpFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case SWITCHCONFIGFAILED: {
                    SwitchConfigFailedCode errorCode = SwitchConfigFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case ROLEREQUESTFAILED: {
                    RoleRequestFailedCode errorCode = RoleRequestFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case METERMODFAILED: {
                    MeterModFailedCode errorCode = MeterModFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case TABLEFEATURESFAILED: {
                    TableFeaturesFailedCode errorCode = TableFeaturesFailedCode.forValue((int)code);
                    if (errorCode != null) {
                        ErrorMessageFactory.setCode(builder, errorCode.getIntValue(), errorCode.name());
                        break;
                    }
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
                case EXPERIMENTER: {
                    ExperimenterErrorBuilder expBuilder = new ExperimenterErrorBuilder();
                    expBuilder.setExpType(Integer.valueOf(code));
                    expBuilder.setExperimenter(Long.valueOf(rawMessage.readUnsignedInt()));
                    builder.addAugmentation(ExperimenterError.class, (Augmentation)expBuilder.build());
                    break;
                }
                default: {
                    ErrorMessageFactory.setUnknownCode(builder, code);
                    break;
                }
            }
        } else {
            ErrorMessageFactory.setUnknownCode(builder, code);
        }
    }

    private static void setUnknownCode(ErrorMessageBuilder builder, int readValue) {
        builder.setCode(Integer.valueOf(readValue));
        builder.setCodeString(UNKNOWN_CODE);
    }

    private static void setCode(ErrorMessageBuilder builder, int code, String codeString) {
        builder.setCode(Integer.valueOf(code));
        builder.setCodeString(codeString);
    }
}

