/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import io.netty.buffer.ByteBuf;
import org.opendaylight.openflowjava.protocol.impl.deserialization.DecoderTable;
import org.opendaylight.openflowjava.protocol.impl.deserialization.MessageTypeCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DeserializationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeserializationFactory.class);

    public static DataObject bufferToMessage(ByteBuf rawMessage, short version) {
        DataObject dataObject = null;
        short type = rawMessage.readUnsignedByte();
        rawMessage.skipBytes(2);
        MessageTypeCodeKey msgTypeCodeKey = new MessageTypeCodeKey(version, type);
        OFDeserializer<?> decoder = DecoderTable.getInstance().getDecoder(msgTypeCodeKey);
        if (decoder != null) {
            dataObject = (DataObject)decoder.bufferToMessage(rawMessage, version);
        } else {
            LOGGER.warn("No correct decoder found in DecoderTable for arguments: " + msgTypeCodeKey.toString());
        }
        return dataObject;
    }
}

