/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.deserialization;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.openflowjava.protocol.impl.deserialization.MessageTypeCodeKey;
import org.opendaylight.openflowjava.protocol.impl.deserialization.OFDeserializer;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.BarrierReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.EchoReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.EchoRequestMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.ErrorMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.ExperimenterMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.FeaturesReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.FlowRemovedMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.GetAsyncReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.GetConfigReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.HelloMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.MultipartReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10ErrorMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10FeaturesReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10FlowRemovedMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10HelloMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10PacketInMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10PortStatusMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10QueueGetConfigReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10StatsReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.OF10VendorMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.PacketInMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.PortStatusMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.QueueGetConfigReplyMessageFactory;
import org.opendaylight.openflowjava.protocol.impl.deserialization.factories.RoleReplyMessageFactory;

public class DecoderTable {
    private static final short OF10 = 1;
    private static final short OF13 = 4;
    private Map<MessageTypeCodeKey, OFDeserializer<?>> table;
    private static DecoderTable instance;

    private DecoderTable() {
    }

    public static synchronized DecoderTable getInstance() {
        if (instance == null) {
            instance = new DecoderTable();
            instance.init();
        }
        return instance;
    }

    public void init() {
        this.table = new HashMap();
        this.table.put(new MessageTypeCodeKey(1, 0), OF10HelloMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 1), OF10ErrorMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 2), EchoRequestMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 3), EchoReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 4), OF10VendorMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 6), OF10FeaturesReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 8), GetConfigReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 10), OF10PacketInMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 11), OF10FlowRemovedMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 12), OF10PortStatusMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 17), OF10StatsReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 19), BarrierReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(1, 21), OF10QueueGetConfigReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 0), HelloMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 1), ErrorMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 2), EchoRequestMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 3), EchoReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 4), ExperimenterMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 6), FeaturesReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 8), GetConfigReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 10), PacketInMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 11), FlowRemovedMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 12), PortStatusMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 19), MultipartReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 21), BarrierReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 23), QueueGetConfigReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 25), RoleReplyMessageFactory.getInstance());
        this.table.put(new MessageTypeCodeKey(4, 27), GetAsyncReplyMessageFactory.getInstance());
    }

    public OFDeserializer<?> getDecoder(MessageTypeCodeKey msgTypeKey) {
        return this.table.get(msgTypeKey);
    }
}

