/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.ssl.SslHandler;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.opendaylight.openflowjava.protocol.impl.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.core.SslContextFactory;
import org.opendaylight.openflowjava.protocol.impl.core.TcpHandler;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TlsDetector
extends ByteToMessageDecoder {
    private boolean detectSsl;
    private static final Logger LOGGER = LoggerFactory.getLogger(TlsDetector.class);
    private ConnectionFacade connectionFacade;

    public TlsDetector() {
        LOGGER.trace("Creating TLS Detector");
        this.detectSsl = true;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOGGER.warn("Unexpected exception from downstream.", cause);
        ctx.close();
    }

    private boolean isSsl(ByteBuf bb) {
        if (this.detectSsl) {
            LOGGER.trace("Testing connection for TLS");
            return SslHandler.isEncrypted((ByteBuf)bb);
        }
        return false;
    }

    private static void enableSsl(ChannelHandlerContext ctx) {
        if (ctx.pipeline().get(TcpHandler.COMPONENT_NAMES.SSL_HANDLER.name()) == null) {
            LOGGER.trace("Engaging TLS handler");
            ChannelPipeline p = ctx.channel().pipeline();
            SSLEngine engine = SslContextFactory.getServerContext().createSSLEngine();
            engine.setUseClientMode(false);
            p.addAfter(TcpHandler.COMPONENT_NAMES.TLS_DETECTOR.name(), TcpHandler.COMPONENT_NAMES.SSL_HANDLER.name(), (ChannelHandler)new SslHandler(engine));
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf bb, List<Object> list) throws Exception {
        if (bb.readableBytes() < 5) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(ByteBufUtils.byteBufToHexString(bb));
        }
        if (this.isSsl(bb)) {
            LOGGER.debug("Connection is encrypted");
            TlsDetector.enableSsl(ctx);
        } else {
            LOGGER.debug("Connection is not encrypted");
        }
        if (this.connectionFacade != null) {
            LOGGER.trace("Firing onConnectionReady notification");
            this.connectionFacade.fireConnectionReadyNotification();
        }
        ctx.pipeline().remove(TcpHandler.COMPONENT_NAMES.TLS_DETECTOR.name());
    }

    public void setConnectionFacade(ConnectionFacade connectionFacade) {
        this.connectionFacade = connectionFacade;
    }
}

