/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.connection.ServerFacade;
import org.opendaylight.openflowjava.protocol.impl.core.PublishingChannelInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpHandler
implements ServerFacade {
    private int port;
    private String address;
    private InetAddress startupAddress;
    private NioEventLoopGroup workerGroup;
    private NioEventLoopGroup bossGroup;
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpHandler.class);
    private SettableFuture<Boolean> isOnlineFuture;
    private PublishingChannelInitializer channelInitializer;

    public TcpHandler(int port) {
        this(null, port);
    }

    public TcpHandler(InetAddress address, int port) {
        this.port = port;
        this.startupAddress = address;
        this.channelInitializer = new PublishingChannelInitializer();
        this.isOnlineFuture = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.DEBUG))).childHandler((ChannelHandler)this.channelInitializer).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.SO_REUSEADDR, (Object)true)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            ChannelFuture f = this.startupAddress != null ? b.bind(this.startupAddress.getHostAddress(), this.port).sync() : b.bind(this.port).sync();
            InetSocketAddress isa = (InetSocketAddress)f.channel().localAddress();
            this.address = isa.getHostString();
            LOGGER.debug("address from tcphandler: " + this.address);
            this.port = isa.getPort();
            this.isOnlineFuture.set((Object)true);
            LOGGER.info("Switch listener started and ready to accept incoming connections on port: " + this.port);
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            this.shutdown();
        }
    }

    @Override
    public ListenableFuture<Boolean> shutdown() {
        final SettableFuture result = SettableFuture.create();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.shutdownGracefully().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

            public void operationComplete(Future<Object> downResult) throws Exception {
                result.set((Object)downResult.isSuccess());
                if (downResult.cause() != null) {
                    result.setException(downResult.cause());
                }
            }
        });
        return result;
    }

    public int getNumberOfConnections() {
        return this.channelInitializer.size();
    }

    public PublishingChannelInitializer getChannelInitializer() {
        return this.channelInitializer;
    }

    @Override
    public ListenableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    public int getPort() {
        return this.port;
    }

    public String getAddress() {
        return this.address;
    }

    public void setSwitchConnectionHandler(SwitchConnectionHandler switchConnectionHandler) {
        this.channelInitializer.setSwitchConnectionHandler(switchConnectionHandler);
    }

    public void setSwitchIdleTimeout(long switchIdleTimeout) {
        this.channelInitializer.setSwitchIdleTimeout(switchIdleTimeout);
    }

    public void setEncryption(boolean tlsSupported) {
        this.channelInitializer.setEncryption(tlsSupported);
    }

    public static enum COMPONENT_NAMES {
        IDLE_HANDLER,
        TLS_DETECTOR,
        SSL_HANDLER,
        OF_FRAME_DECODER,
        OF_VERSION_DETECTOR,
        OF_DECODER,
        OF_ENCODER,
        DELEGATING_INBOUND_HANDLER;

    }
}

