/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.opendaylight.openflowjava.protocol.impl.core.SslKeyStore;
import org.opendaylight.openflowjava.protocol.impl.core.SslTrustManagerFactory;

public final class SslContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final SSLContext SERVER_CONTEXT;
    private static final SSLContext CLIENT_CONTEXT;

    public static SSLContext getServerContext() {
        return SERVER_CONTEXT;
    }

    public static SSLContext getClientContext() {
        return CLIENT_CONTEXT;
    }

    static {
        SSLContext clientContext;
        SSLContext serverContext;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(SslKeyStore.asInputStream(), SslKeyStore.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, SslKeyStore.getCertificatePassword());
            serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (RuntimeException e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        try {
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(null, SslTrustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        SERVER_CONTEXT = serverContext;
        CLIENT_CONTEXT = clientContext;
    }
}

