/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.api.connection.ConnectionAdapter;
import org.opendaylight.openflowjava.protocol.api.connection.SwitchConnectionHandler;
import org.opendaylight.openflowjava.protocol.impl.connection.ConnectionAdapterFactory;
import org.opendaylight.openflowjava.protocol.impl.connection.ConnectionFacade;
import org.opendaylight.openflowjava.protocol.impl.core.DelegatingInboundHandler;
import org.opendaylight.openflowjava.protocol.impl.core.IdleHandler;
import org.opendaylight.openflowjava.protocol.impl.core.OFDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFEncoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFFrameDecoder;
import org.opendaylight.openflowjava.protocol.impl.core.OFVersionDetector;
import org.opendaylight.openflowjava.protocol.impl.core.TcpHandler;
import org.opendaylight.openflowjava.protocol.impl.core.TlsDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishingChannelInitializer.class);
    private DefaultChannelGroup allChannels = new DefaultChannelGroup("netty-receiver", null);
    private SwitchConnectionHandler switchConnectionHandler;
    private long switchIdleTimeout;
    private boolean encryption;

    protected void initChannel(SocketChannel ch) {
        InetAddress switchAddress = ch.remoteAddress().getAddress();
        int port = ch.localAddress().getPort();
        int remotePort = ch.remoteAddress().getPort();
        LOGGER.info("Incoming connection from (remote address): " + switchAddress.toString() + ":" + remotePort + " --> :" + port);
        if (!this.switchConnectionHandler.accept(switchAddress)) {
            ch.disconnect();
            LOGGER.info("Incoming connection rejected");
            return;
        }
        LOGGER.info("Incoming connection accepted - building pipeline");
        this.allChannels.add((Channel)ch);
        ConnectionFacade connectionFacade = null;
        connectionFacade = ConnectionAdapterFactory.createConnectionFacade(ch);
        try {
            LOGGER.debug("calling plugin: " + this.switchConnectionHandler);
            this.switchConnectionHandler.onSwitchConnected((ConnectionAdapter)connectionFacade);
            connectionFacade.checkListeners();
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.IDLE_HANDLER.name(), (ChannelHandler)new IdleHandler(this.switchIdleTimeout, 0L, 0L, TimeUnit.MILLISECONDS));
            if (this.encryption) {
                TlsDetector tlsDetector = new TlsDetector();
                tlsDetector.setConnectionFacade(connectionFacade);
                ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.TLS_DETECTOR.name(), (ChannelHandler)tlsDetector);
            }
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.OF_FRAME_DECODER.name(), (ChannelHandler)new OFFrameDecoder());
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.OF_VERSION_DETECTOR.name(), (ChannelHandler)new OFVersionDetector());
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.OF_DECODER.name(), (ChannelHandler)new OFDecoder());
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.OF_ENCODER.name(), (ChannelHandler)new OFEncoder());
            ch.pipeline().addLast(TcpHandler.COMPONENT_NAMES.DELEGATING_INBOUND_HANDLER.name(), (ChannelHandler)new DelegatingInboundHandler(connectionFacade));
            if (!this.encryption) {
                connectionFacade.fireConnectionReadyNotification();
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ch.close();
        }
    }

    public Iterator<Channel> getConnectionIterator() {
        return this.allChannels.iterator();
    }

    public int size() {
        return this.allChannels.size();
    }

    public void setSwitchConnectionHandler(SwitchConnectionHandler switchConnectionHandler) {
        this.switchConnectionHandler = switchConnectionHandler;
    }

    public void setSwitchIdleTimeout(long switchIdleTimeout) {
        this.switchIdleTimeout = switchIdleTimeout;
    }

    public void setEncryption(boolean tlsSupported) {
        this.encryption = tlsSupported;
    }
}

