/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.core.VersionMessageWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFVersionDetector
extends ByteToMessageDecoder {
    private static final byte OF10_VERSION_ID = 1;
    private static final byte OF13_VERSION_ID = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(OFVersionDetector.class);

    public OFVersionDetector() {
        LOGGER.trace("Creating OFVersionDetector");
    }

    protected void decode(ChannelHandlerContext chc, ByteBuf bb, List<Object> list) throws Exception {
        if (bb.readableBytes() == 0) {
            LOGGER.debug("not enough data");
            bb.release();
            return;
        }
        byte version = bb.readByte();
        if (version != 4 && version != 1) {
            LOGGER.warn("detected version: " + version + " - currently not supported");
            bb.skipBytes(bb.readableBytes());
            return;
        }
        LOGGER.debug("detected version: " + version);
        ByteBuf messageBuffer = bb.slice();
        list.add(new VersionMessageWrapper(version, messageBuffer));
        messageBuffer.retain();
        bb.skipBytes(bb.readableBytes());
    }
}

