/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.core;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.opendaylight.openflowjava.protocol.impl.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFFrameDecoder
extends ByteToMessageDecoder {
    public static final byte LENGTH_OF_HEADER = 8;
    private static final byte LENGTH_INDEX_IN_HEADER = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(OFFrameDecoder.class);

    public OFFrameDecoder() {
        LOGGER.trace("Creating OFFrameDecoder");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOGGER.warn("Unexpected exception from downstream.", cause);
        ctx.close();
    }

    protected void decode(ChannelHandlerContext chc, ByteBuf bb, List<Object> list) throws Exception {
        int readableBytes = bb.readableBytes();
        if (readableBytes < 8) {
            LOGGER.debug("skipping bb - too few data for header: " + readableBytes);
            return;
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        LOGGER.debug("length of actual message: {}", (Object)length);
        if (readableBytes < length) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("skipping bb - too few data for msg: " + readableBytes + " < " + length);
                LOGGER.debug("bb: " + ByteBufUtils.byteBufToHexString(bb));
            }
            return;
        }
        LOGGER.debug("OF Protocol message received, type:{}", (Object)bb.getByte(bb.readerIndex() + 1));
        ByteBuf messageBuffer = bb.slice(bb.readerIndex(), length);
        list.add(messageBuffer);
        messageBuffer.retain();
        bb.skipBytes(length);
    }
}

